<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherServiceInfoType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOtherServiceInfoType extends AbstractStructBase
{
    /**
     * The TravelerRefNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTravelerRefNumber[]
     */
    public $TravelerRefNumber;
    /**
     * The Airline
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType
     */
    public $Airline;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * Constructor method for OtherServiceInfoType
     * @uses DgOtherServiceInfoType::setTravelerRefNumber()
     * @uses DgOtherServiceInfoType::setAirline()
     * @uses DgOtherServiceInfoType::setText()
     * @param \dgsoft\StructType\DgTravelerRefNumber[] $travelerRefNumber
     * @param \dgsoft\StructType\DgCompanyNameType $airline
     * @param string $text
     */
    public function __construct(array $travelerRefNumber = array(), \dgsoft\StructType\DgCompanyNameType $airline = null, $text = null)
    {
        $this
            ->setTravelerRefNumber($travelerRefNumber)
            ->setAirline($airline)
            ->setText($text);
    }
    /**
     * Get TravelerRefNumber value
     * @return \dgsoft\StructType\DgTravelerRefNumber[]|null
     */
    public function getTravelerRefNumber()
    {
        return $this->TravelerRefNumber;
    }
    /**
     * Set TravelerRefNumber value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelerRefNumber[] $travelerRefNumber
     * @return \dgsoft\StructType\DgOtherServiceInfoType
     */
    public function setTravelerRefNumber(array $travelerRefNumber = array())
    {
        foreach ($travelerRefNumber as $otherServiceInfoTypeTravelerRefNumberItem) {
            // validation for constraint: itemType
            if (!$otherServiceInfoTypeTravelerRefNumberItem instanceof \dgsoft\StructType\DgTravelerRefNumber) {
                throw new \InvalidArgumentException(sprintf('The TravelerRefNumber property can only contain items of \dgsoft\StructType\DgTravelerRefNumber, "%s" given', is_object($otherServiceInfoTypeTravelerRefNumberItem) ? get_class($otherServiceInfoTypeTravelerRefNumberItem) : gettype($otherServiceInfoTypeTravelerRefNumberItem)), __LINE__);
            }
        }
        $this->TravelerRefNumber = $travelerRefNumber;
        return $this;
    }
    /**
     * Add item to TravelerRefNumber value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelerRefNumber $item
     * @return \dgsoft\StructType\DgOtherServiceInfoType
     */
    public function addToTravelerRefNumber(\dgsoft\StructType\DgTravelerRefNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTravelerRefNumber) {
            throw new \InvalidArgumentException(sprintf('The TravelerRefNumber property can only contain items of \dgsoft\StructType\DgTravelerRefNumber, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelerRefNumber[] = $item;
        return $this;
    }
    /**
     * Get Airline value
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param \dgsoft\StructType\DgCompanyNameType $airline
     * @return \dgsoft\StructType\DgOtherServiceInfoType
     */
    public function setAirline(\dgsoft\StructType\DgCompanyNameType $airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \dgsoft\StructType\DgOtherServiceInfoType
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOtherServiceInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
