<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperationSchedulesType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOperationSchedulesType extends AbstractStructBase
{
    /**
     * The OperationSchedule
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOperationScheduleType[]
     */
    public $OperationSchedule;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * Constructor method for OperationSchedulesType
     * @uses DgOperationSchedulesType::setOperationSchedule()
     * @uses DgOperationSchedulesType::setStart()
     * @uses DgOperationSchedulesType::setDuration()
     * @uses DgOperationSchedulesType::setEnd()
     * @param \dgsoft\StructType\DgOperationScheduleType[] $operationSchedule
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct(array $operationSchedule = array(), $start = null, $duration = null, $end = null)
    {
        $this
            ->setOperationSchedule($operationSchedule)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get OperationSchedule value
     * @return \dgsoft\StructType\DgOperationScheduleType[]|null
     */
    public function getOperationSchedule()
    {
        return $this->OperationSchedule;
    }
    /**
     * Set OperationSchedule value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOperationScheduleType[] $operationSchedule
     * @return \dgsoft\StructType\DgOperationSchedulesType
     */
    public function setOperationSchedule(array $operationSchedule = array())
    {
        foreach ($operationSchedule as $operationSchedulesTypeOperationScheduleItem) {
            // validation for constraint: itemType
            if (!$operationSchedulesTypeOperationScheduleItem instanceof \dgsoft\StructType\DgOperationScheduleType) {
                throw new \InvalidArgumentException(sprintf('The OperationSchedule property can only contain items of \dgsoft\StructType\DgOperationScheduleType, "%s" given', is_object($operationSchedulesTypeOperationScheduleItem) ? get_class($operationSchedulesTypeOperationScheduleItem) : gettype($operationSchedulesTypeOperationScheduleItem)), __LINE__);
            }
        }
        $this->OperationSchedule = $operationSchedule;
        return $this;
    }
    /**
     * Add item to OperationSchedule value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOperationScheduleType $item
     * @return \dgsoft\StructType\DgOperationSchedulesType
     */
    public function addToOperationSchedule(\dgsoft\StructType\DgOperationScheduleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgOperationScheduleType) {
            throw new \InvalidArgumentException(sprintf('The OperationSchedule property can only contain items of \dgsoft\StructType\DgOperationScheduleType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OperationSchedule[] = $item;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \dgsoft\StructType\DgOperationSchedulesType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \dgsoft\StructType\DgOperationSchedulesType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \dgsoft\StructType\DgOperationSchedulesType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOperationSchedulesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
