<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperationScheduleType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOperationScheduleType extends AbstractStructBase
{
    /**
     * The OperationTimes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfOperationScheduleTypeOperationTime
     */
    public $OperationTimes;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * Constructor method for OperationScheduleType
     * @uses DgOperationScheduleType::setOperationTimes()
     * @uses DgOperationScheduleType::setStart()
     * @uses DgOperationScheduleType::setDuration()
     * @uses DgOperationScheduleType::setEnd()
     * @param \dgsoft\ArrayType\DgArrayOfOperationScheduleTypeOperationTime $operationTimes
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfOperationScheduleTypeOperationTime $operationTimes = null, $start = null, $duration = null, $end = null)
    {
        $this
            ->setOperationTimes($operationTimes)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get OperationTimes value
     * @return \dgsoft\ArrayType\DgArrayOfOperationScheduleTypeOperationTime|null
     */
    public function getOperationTimes()
    {
        return $this->OperationTimes;
    }
    /**
     * Set OperationTimes value
     * @param \dgsoft\ArrayType\DgArrayOfOperationScheduleTypeOperationTime $operationTimes
     * @return \dgsoft\StructType\DgOperationScheduleType
     */
    public function setOperationTimes(\dgsoft\ArrayType\DgArrayOfOperationScheduleTypeOperationTime $operationTimes = null)
    {
        $this->OperationTimes = $operationTimes;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \dgsoft\StructType\DgOperationScheduleType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \dgsoft\StructType\DgOperationScheduleType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \dgsoft\StructType\DgOperationScheduleType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOperationScheduleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
