<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OffLocationServiceCoreTypeAddress StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOffLocationServiceCoreTypeAddress extends DgAddressType
{
    /**
     * The SiteID
     * @var string
     */
    public $SiteID;
    /**
     * The SiteName
     * @var string
     */
    public $SiteName;
    /**
     * Constructor method for OffLocationServiceCoreTypeAddress
     * @uses DgOffLocationServiceCoreTypeAddress::setSiteID()
     * @uses DgOffLocationServiceCoreTypeAddress::setSiteName()
     * @param string $siteID
     * @param string $siteName
     */
    public function __construct($siteID = null, $siteName = null)
    {
        $this
            ->setSiteID($siteID)
            ->setSiteName($siteName);
    }
    /**
     * Get SiteID value
     * @return string|null
     */
    public function getSiteID()
    {
        return $this->SiteID;
    }
    /**
     * Set SiteID value
     * @param string $siteID
     * @return \dgsoft\StructType\DgOffLocationServiceCoreTypeAddress
     */
    public function setSiteID($siteID = null)
    {
        // validation for constraint: string
        if (!is_null($siteID) && !is_string($siteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siteID)), __LINE__);
        }
        $this->SiteID = $siteID;
        return $this;
    }
    /**
     * Get SiteName value
     * @return string|null
     */
    public function getSiteName()
    {
        return $this->SiteName;
    }
    /**
     * Set SiteName value
     * @param string $siteName
     * @return \dgsoft\StructType\DgOffLocationServiceCoreTypeAddress
     */
    public function setSiteName($siteName = null)
    {
        // validation for constraint: string
        if (!is_null($siteName) && !is_string($siteName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siteName)), __LINE__);
        }
        $this->SiteName = $siteName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOffLocationServiceCoreTypeAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
