<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_VehResRS StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_VehResRS extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Version;
    /**
     * The VehResRSCore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_VehResRSVehResRSCore
     */
    public $VehResRSCore;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgWarningsType
     */
    public $Warnings;
    /**
     * The VehResRSInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleResRSAdditionalInfoType
     */
    public $VehResRSInfo;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgErrorsType
     */
    public $Errors;
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSuccessType
     */
    public $Success;
    /**
     * The ReferenceNumber
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - default: Production
     * @var string
     */
    public $Target;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * Constructor method for OTA_VehResRS
     * @uses DgOTA_VehResRS::setVersion()
     * @uses DgOTA_VehResRS::setVehResRSCore()
     * @uses DgOTA_VehResRS::setWarnings()
     * @uses DgOTA_VehResRS::setVehResRSInfo()
     * @uses DgOTA_VehResRS::setErrors()
     * @uses DgOTA_VehResRS::setSuccess()
     * @uses DgOTA_VehResRS::setReferenceNumber()
     * @uses DgOTA_VehResRS::setEchoToken()
     * @uses DgOTA_VehResRS::setTimeStamp()
     * @uses DgOTA_VehResRS::setTarget()
     * @uses DgOTA_VehResRS::setTransactionIdentifier()
     * @uses DgOTA_VehResRS::setSequenceNmbr()
     * @uses DgOTA_VehResRS::setTransactionStatusCode()
     * @uses DgOTA_VehResRS::setRetransmissionIndicator()
     * @param float $version
     * @param \dgsoft\StructType\DgOTA_VehResRSVehResRSCore $vehResRSCore
     * @param \dgsoft\StructType\DgWarningsType $warnings
     * @param \dgsoft\StructType\DgVehicleResRSAdditionalInfoType $vehResRSInfo
     * @param \dgsoft\StructType\DgErrorsType $errors
     * @param \dgsoft\StructType\DgSuccessType $success
     * @param string $referenceNumber
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     */
    public function __construct($version = null, \dgsoft\StructType\DgOTA_VehResRSVehResRSCore $vehResRSCore = null, \dgsoft\StructType\DgWarningsType $warnings = null, \dgsoft\StructType\DgVehicleResRSAdditionalInfoType $vehResRSInfo = null, \dgsoft\StructType\DgErrorsType $errors = null, \dgsoft\StructType\DgSuccessType $success = null, $referenceNumber = null, $echoToken = null, $timeStamp = null, $target = 'Production', $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null)
    {
        $this
            ->setVersion($version)
            ->setVehResRSCore($vehResRSCore)
            ->setWarnings($warnings)
            ->setVehResRSInfo($vehResRSInfo)
            ->setErrors($errors)
            ->setSuccess($success)
            ->setReferenceNumber($referenceNumber)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator);
    }
    /**
     * Get Version value
     * @return float
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \dgsoft\StructType\DgOTA_VehResRS
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get VehResRSCore value
     * @return \dgsoft\StructType\DgOTA_VehResRSVehResRSCore|null
     */
    public function getVehResRSCore()
    {
        return $this->VehResRSCore;
    }
    /**
     * Set VehResRSCore value
     * @param \dgsoft\StructType\DgOTA_VehResRSVehResRSCore $vehResRSCore
     * @return \dgsoft\StructType\DgOTA_VehResRS
     */
    public function setVehResRSCore(\dgsoft\StructType\DgOTA_VehResRSVehResRSCore $vehResRSCore = null)
    {
        $this->VehResRSCore = $vehResRSCore;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \dgsoft\StructType\DgWarningsType|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \dgsoft\StructType\DgWarningsType $warnings
     * @return \dgsoft\StructType\DgOTA_VehResRS
     */
    public function setWarnings(\dgsoft\StructType\DgWarningsType $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get VehResRSInfo value
     * @return \dgsoft\StructType\DgVehicleResRSAdditionalInfoType|null
     */
    public function getVehResRSInfo()
    {
        return $this->VehResRSInfo;
    }
    /**
     * Set VehResRSInfo value
     * @param \dgsoft\StructType\DgVehicleResRSAdditionalInfoType $vehResRSInfo
     * @return \dgsoft\StructType\DgOTA_VehResRS
     */
    public function setVehResRSInfo(\dgsoft\StructType\DgVehicleResRSAdditionalInfoType $vehResRSInfo = null)
    {
        $this->VehResRSInfo = $vehResRSInfo;
        return $this;
    }
    /**
     * Get Errors value
     * @return \dgsoft\StructType\DgErrorsType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \dgsoft\StructType\DgErrorsType $errors
     * @return \dgsoft\StructType\DgOTA_VehResRS
     */
    public function setErrors(\dgsoft\StructType\DgErrorsType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Success value
     * @return \dgsoft\StructType\DgSuccessType|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \dgsoft\StructType\DgSuccessType $success
     * @return \dgsoft\StructType\DgOTA_VehResRS
     */
    public function setSuccess(\dgsoft\StructType\DgSuccessType $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \dgsoft\StructType\DgOTA_VehResRS
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \dgsoft\StructType\DgOTA_VehResRS
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \dgsoft\StructType\DgOTA_VehResRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @uses \dgsoft\EnumType\DgOTA_VehResRSTarget::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_VehResRSTarget::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $target
     * @return \dgsoft\StructType\DgOTA_VehResRS
     */
    public function setTarget($target = 'Production')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_VehResRSTarget::valueIsValid($target)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $target, implode(', ', \dgsoft\EnumType\DgOTA_VehResRSTarget::getValidValues())), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \dgsoft\StructType\DgOTA_VehResRS
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \dgsoft\StructType\DgOTA_VehResRS
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @uses \dgsoft\EnumType\DgOTA_VehResRSTransactionStatusCode::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_VehResRSTransactionStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionStatusCode
     * @return \dgsoft\StructType\DgOTA_VehResRS
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_VehResRSTransactionStatusCode::valueIsValid($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionStatusCode, implode(', ', \dgsoft\EnumType\DgOTA_VehResRSTransactionStatusCode::getValidValues())), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \dgsoft\StructType\DgOTA_VehResRS
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_VehResRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
