<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_VehResRQVehResRQInfo StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_VehResRQVehResRQInfo extends DgVehicleReservationRQAdditionalInfoType
{
    /**
     * The ResStatus
     * @var string
     */
    public $ResStatus;
    /**
     * Constructor method for OTA_VehResRQVehResRQInfo
     * @uses DgOTA_VehResRQVehResRQInfo::setResStatus()
     * @param string $resStatus
     */
    public function __construct($resStatus = null)
    {
        $this
            ->setResStatus($resStatus);
    }
    /**
     * Get ResStatus value
     * @return string|null
     */
    public function getResStatus()
    {
        return $this->ResStatus;
    }
    /**
     * Set ResStatus value
     * @uses \dgsoft\EnumType\DgTransactionActionType::valueIsValid()
     * @uses \dgsoft\EnumType\DgTransactionActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resStatus
     * @return \dgsoft\StructType\DgOTA_VehResRQVehResRQInfo
     */
    public function setResStatus($resStatus = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgTransactionActionType::valueIsValid($resStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $resStatus, implode(', ', \dgsoft\EnumType\DgTransactionActionType::getValidValues())), __LINE__);
        }
        $this->ResStatus = $resStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_VehResRQVehResRQInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
