<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePayments
 * StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePayments extends AbstractStructBase
{
    /**
     * The AcceptablePayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePaymentsAcceptablePayment[]
     */
    public $AcceptablePayment;
    /**
     * The PaymentTypeCode
     * @var string
     */
    public $PaymentTypeCode;
    /**
     * Constructor method for OTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePayments
     * @uses DgOTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePayments::setAcceptablePayment()
     * @uses DgOTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePayments::setPaymentTypeCode()
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePaymentsAcceptablePayment[] $acceptablePayment
     * @param string $paymentTypeCode
     */
    public function __construct(array $acceptablePayment = array(), $paymentTypeCode = null)
    {
        $this
            ->setAcceptablePayment($acceptablePayment)
            ->setPaymentTypeCode($paymentTypeCode);
    }
    /**
     * Get AcceptablePayment value
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePaymentsAcceptablePayment[]|null
     */
    public function getAcceptablePayment()
    {
        return $this->AcceptablePayment;
    }
    /**
     * Set AcceptablePayment value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePaymentsAcceptablePayment[] $acceptablePayment
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePayments
     */
    public function setAcceptablePayment(array $acceptablePayment = array())
    {
        foreach ($acceptablePayment as $oTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePaymentsAcceptablePaymentItem) {
            // validation for constraint: itemType
            if (!$oTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePaymentsAcceptablePaymentItem instanceof \dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePaymentsAcceptablePayment) {
                throw new \InvalidArgumentException(sprintf('The AcceptablePayment property can only contain items of \dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePaymentsAcceptablePayment, "%s" given', is_object($oTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePaymentsAcceptablePaymentItem) ? get_class($oTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePaymentsAcceptablePaymentItem) : gettype($oTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePaymentsAcceptablePaymentItem)), __LINE__);
            }
        }
        $this->AcceptablePayment = $acceptablePayment;
        return $this;
    }
    /**
     * Add item to AcceptablePayment value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePaymentsAcceptablePayment $item
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePayments
     */
    public function addToAcceptablePayment(\dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePaymentsAcceptablePayment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePaymentsAcceptablePayment) {
            throw new \InvalidArgumentException(sprintf('The AcceptablePayment property can only contain items of \dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePaymentsAcceptablePayment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AcceptablePayment[] = $item;
        return $this;
    }
    /**
     * Get PaymentTypeCode value
     * @return string|null
     */
    public function getPaymentTypeCode()
    {
        return $this->PaymentTypeCode;
    }
    /**
     * Set PaymentTypeCode value
     * @param string $paymentTypeCode
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePayments
     */
    public function setPaymentTypeCode($paymentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTypeCode) && !is_string($paymentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentTypeCode)), __LINE__);
        }
        $this->PaymentTypeCode = $paymentTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSRateRulesPaymentRulesAcceptablePayments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
