<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_VehRateRuleRS StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_VehRateRuleRS extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Version;
    /**
     * The VendorMessages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVendorMessagesType
     */
    public $VendorMessages;
    /**
     * The RateRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_VehRateRuleRSRateRules
     */
    public $RateRules;
    /**
     * The RentalRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_VehRateRuleRSRentalRate
     */
    public $RentalRate;
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSuccessType
     */
    public $Success;
    /**
     * The LocationDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_VehRateRuleRSLocationDetails
     */
    public $LocationDetails;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The Fees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_VehRateRuleRSFees
     */
    public $Fees;
    /**
     * The TotalCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_VehRateRuleRSTotalCharge
     */
    public $TotalCharge;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgErrorsType
     */
    public $Errors;
    /**
     * The VehRentalCore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_VehRateRuleRSVehRentalCore
     */
    public $VehRentalCore;
    /**
     * The Vehicle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_VehRateRuleRSVehicle
     */
    public $Vehicle;
    /**
     * The PricedCoverages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_VehRateRuleRSPricedCoverages
     */
    public $PricedCoverages;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgWarningsType
     */
    public $Warnings;
    /**
     * The PricedEquips
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_VehRateRuleRSPricedEquips
     */
    public $PricedEquips;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - default: Production
     * @var string
     */
    public $Target;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * Constructor method for OTA_VehRateRuleRS
     * @uses DgOTA_VehRateRuleRS::setVersion()
     * @uses DgOTA_VehRateRuleRS::setVendorMessages()
     * @uses DgOTA_VehRateRuleRS::setRateRules()
     * @uses DgOTA_VehRateRuleRS::setRentalRate()
     * @uses DgOTA_VehRateRuleRS::setSuccess()
     * @uses DgOTA_VehRateRuleRS::setLocationDetails()
     * @uses DgOTA_VehRateRuleRS::setTPA_Extensions()
     * @uses DgOTA_VehRateRuleRS::setFees()
     * @uses DgOTA_VehRateRuleRS::setTotalCharge()
     * @uses DgOTA_VehRateRuleRS::setErrors()
     * @uses DgOTA_VehRateRuleRS::setVehRentalCore()
     * @uses DgOTA_VehRateRuleRS::setVehicle()
     * @uses DgOTA_VehRateRuleRS::setPricedCoverages()
     * @uses DgOTA_VehRateRuleRS::setWarnings()
     * @uses DgOTA_VehRateRuleRS::setPricedEquips()
     * @uses DgOTA_VehRateRuleRS::setEchoToken()
     * @uses DgOTA_VehRateRuleRS::setTimeStamp()
     * @uses DgOTA_VehRateRuleRS::setTarget()
     * @uses DgOTA_VehRateRuleRS::setTransactionIdentifier()
     * @uses DgOTA_VehRateRuleRS::setSequenceNmbr()
     * @uses DgOTA_VehRateRuleRS::setTransactionStatusCode()
     * @uses DgOTA_VehRateRuleRS::setRetransmissionIndicator()
     * @param float $version
     * @param \dgsoft\StructType\DgVendorMessagesType $vendorMessages
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSRateRules $rateRules
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSRentalRate $rentalRate
     * @param \dgsoft\StructType\DgSuccessType $success
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSLocationDetails $locationDetails
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSFees $fees
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSTotalCharge $totalCharge
     * @param \dgsoft\StructType\DgErrorsType $errors
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSVehRentalCore $vehRentalCore
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSVehicle $vehicle
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSPricedCoverages $pricedCoverages
     * @param \dgsoft\StructType\DgWarningsType $warnings
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSPricedEquips $pricedEquips
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     */
    public function __construct($version = null, \dgsoft\StructType\DgVendorMessagesType $vendorMessages = null, \dgsoft\StructType\DgOTA_VehRateRuleRSRateRules $rateRules = null, \dgsoft\StructType\DgOTA_VehRateRuleRSRentalRate $rentalRate = null, \dgsoft\StructType\DgSuccessType $success = null, \dgsoft\StructType\DgOTA_VehRateRuleRSLocationDetails $locationDetails = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, \dgsoft\StructType\DgOTA_VehRateRuleRSFees $fees = null, \dgsoft\StructType\DgOTA_VehRateRuleRSTotalCharge $totalCharge = null, \dgsoft\StructType\DgErrorsType $errors = null, \dgsoft\StructType\DgOTA_VehRateRuleRSVehRentalCore $vehRentalCore = null, \dgsoft\StructType\DgOTA_VehRateRuleRSVehicle $vehicle = null, \dgsoft\StructType\DgOTA_VehRateRuleRSPricedCoverages $pricedCoverages = null, \dgsoft\StructType\DgWarningsType $warnings = null, \dgsoft\StructType\DgOTA_VehRateRuleRSPricedEquips $pricedEquips = null, $echoToken = null, $timeStamp = null, $target = 'Production', $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null)
    {
        $this
            ->setVersion($version)
            ->setVendorMessages($vendorMessages)
            ->setRateRules($rateRules)
            ->setRentalRate($rentalRate)
            ->setSuccess($success)
            ->setLocationDetails($locationDetails)
            ->setTPA_Extensions($tPA_Extensions)
            ->setFees($fees)
            ->setTotalCharge($totalCharge)
            ->setErrors($errors)
            ->setVehRentalCore($vehRentalCore)
            ->setVehicle($vehicle)
            ->setPricedCoverages($pricedCoverages)
            ->setWarnings($warnings)
            ->setPricedEquips($pricedEquips)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator);
    }
    /**
     * Get Version value
     * @return float
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get VendorMessages value
     * @return \dgsoft\StructType\DgVendorMessagesType|null
     */
    public function getVendorMessages()
    {
        return $this->VendorMessages;
    }
    /**
     * Set VendorMessages value
     * @param \dgsoft\StructType\DgVendorMessagesType $vendorMessages
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setVendorMessages(\dgsoft\StructType\DgVendorMessagesType $vendorMessages = null)
    {
        $this->VendorMessages = $vendorMessages;
        return $this;
    }
    /**
     * Get RateRules value
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSRateRules|null
     */
    public function getRateRules()
    {
        return $this->RateRules;
    }
    /**
     * Set RateRules value
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSRateRules $rateRules
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setRateRules(\dgsoft\StructType\DgOTA_VehRateRuleRSRateRules $rateRules = null)
    {
        $this->RateRules = $rateRules;
        return $this;
    }
    /**
     * Get RentalRate value
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSRentalRate|null
     */
    public function getRentalRate()
    {
        return $this->RentalRate;
    }
    /**
     * Set RentalRate value
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSRentalRate $rentalRate
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setRentalRate(\dgsoft\StructType\DgOTA_VehRateRuleRSRentalRate $rentalRate = null)
    {
        $this->RentalRate = $rentalRate;
        return $this;
    }
    /**
     * Get Success value
     * @return \dgsoft\StructType\DgSuccessType|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \dgsoft\StructType\DgSuccessType $success
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setSuccess(\dgsoft\StructType\DgSuccessType $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get LocationDetails value
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSLocationDetails|null
     */
    public function getLocationDetails()
    {
        return $this->LocationDetails;
    }
    /**
     * Set LocationDetails value
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSLocationDetails $locationDetails
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setLocationDetails(\dgsoft\StructType\DgOTA_VehRateRuleRSLocationDetails $locationDetails = null)
    {
        $this->LocationDetails = $locationDetails;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Fees value
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSFees|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSFees $fees
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setFees(\dgsoft\StructType\DgOTA_VehRateRuleRSFees $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get TotalCharge value
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSTotalCharge|null
     */
    public function getTotalCharge()
    {
        return $this->TotalCharge;
    }
    /**
     * Set TotalCharge value
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSTotalCharge $totalCharge
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setTotalCharge(\dgsoft\StructType\DgOTA_VehRateRuleRSTotalCharge $totalCharge = null)
    {
        $this->TotalCharge = $totalCharge;
        return $this;
    }
    /**
     * Get Errors value
     * @return \dgsoft\StructType\DgErrorsType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \dgsoft\StructType\DgErrorsType $errors
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setErrors(\dgsoft\StructType\DgErrorsType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get VehRentalCore value
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSVehRentalCore|null
     */
    public function getVehRentalCore()
    {
        return $this->VehRentalCore;
    }
    /**
     * Set VehRentalCore value
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSVehRentalCore $vehRentalCore
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setVehRentalCore(\dgsoft\StructType\DgOTA_VehRateRuleRSVehRentalCore $vehRentalCore = null)
    {
        $this->VehRentalCore = $vehRentalCore;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSVehicle|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSVehicle $vehicle
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setVehicle(\dgsoft\StructType\DgOTA_VehRateRuleRSVehicle $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get PricedCoverages value
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSPricedCoverages|null
     */
    public function getPricedCoverages()
    {
        return $this->PricedCoverages;
    }
    /**
     * Set PricedCoverages value
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSPricedCoverages $pricedCoverages
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setPricedCoverages(\dgsoft\StructType\DgOTA_VehRateRuleRSPricedCoverages $pricedCoverages = null)
    {
        $this->PricedCoverages = $pricedCoverages;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \dgsoft\StructType\DgWarningsType|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \dgsoft\StructType\DgWarningsType $warnings
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setWarnings(\dgsoft\StructType\DgWarningsType $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get PricedEquips value
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRSPricedEquips|null
     */
    public function getPricedEquips()
    {
        return $this->PricedEquips;
    }
    /**
     * Set PricedEquips value
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRSPricedEquips $pricedEquips
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setPricedEquips(\dgsoft\StructType\DgOTA_VehRateRuleRSPricedEquips $pricedEquips = null)
    {
        $this->PricedEquips = $pricedEquips;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @uses \dgsoft\EnumType\DgOTA_VehRateRuleRSTarget::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_VehRateRuleRSTarget::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $target
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setTarget($target = 'Production')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_VehRateRuleRSTarget::valueIsValid($target)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $target, implode(', ', \dgsoft\EnumType\DgOTA_VehRateRuleRSTarget::getValidValues())), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @uses \dgsoft\EnumType\DgOTA_VehRateRuleRSTransactionStatusCode::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_VehRateRuleRSTransactionStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionStatusCode
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_VehRateRuleRSTransactionStatusCode::valueIsValid($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionStatusCode, implode(', ', \dgsoft\EnumType\DgOTA_VehRateRuleRSTransactionStatusCode::getValidValues())), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
