<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_VehRateRuleRQRentalInfo StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_VehRateRuleRQRentalInfo extends AbstractStructBase
{
    /**
     * The VehRentalCore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleRentalCoreType
     */
    public $VehRentalCore;
    /**
     * The VehicleInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehiclePrefType
     */
    public $VehicleInfo;
    /**
     * The SpecialEquipPrefs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfOTA_VehRateRuleRQRentalInfoSpecialEquipPref
     */
    public $SpecialEquipPrefs;
    /**
     * The CustLoyalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfoCustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The RateQualifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfoRateQualifier
     */
    public $RateQualifier;
    /**
     * The OffLocService
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOffLocationServiceType
     */
    public $OffLocService;
    /**
     * The ArrivalDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleArrivalDetailsType
     */
    public $ArrivalDetails;
    /**
     * The TourInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleTourInfoType
     */
    public $TourInfo;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID_Type
     */
    public $CustomerID;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * Constructor method for OTA_VehRateRuleRQRentalInfo
     * @uses DgOTA_VehRateRuleRQRentalInfo::setVehRentalCore()
     * @uses DgOTA_VehRateRuleRQRentalInfo::setVehicleInfo()
     * @uses DgOTA_VehRateRuleRQRentalInfo::setSpecialEquipPrefs()
     * @uses DgOTA_VehRateRuleRQRentalInfo::setCustLoyalty()
     * @uses DgOTA_VehRateRuleRQRentalInfo::setRateQualifier()
     * @uses DgOTA_VehRateRuleRQRentalInfo::setOffLocService()
     * @uses DgOTA_VehRateRuleRQRentalInfo::setArrivalDetails()
     * @uses DgOTA_VehRateRuleRQRentalInfo::setTourInfo()
     * @uses DgOTA_VehRateRuleRQRentalInfo::setCustomerID()
     * @uses DgOTA_VehRateRuleRQRentalInfo::setTPA_Extensions()
     * @param \dgsoft\StructType\DgVehicleRentalCoreType $vehRentalCore
     * @param \dgsoft\StructType\DgVehiclePrefType $vehicleInfo
     * @param \dgsoft\ArrayType\DgArrayOfOTA_VehRateRuleRQRentalInfoSpecialEquipPref $specialEquipPrefs
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfoCustLoyalty[] $custLoyalty
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfoRateQualifier $rateQualifier
     * @param \dgsoft\StructType\DgOffLocationServiceType $offLocService
     * @param \dgsoft\StructType\DgVehicleArrivalDetailsType $arrivalDetails
     * @param \dgsoft\StructType\DgVehicleTourInfoType $tourInfo
     * @param \dgsoft\StructType\DgUniqueID_Type $customerID
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     */
    public function __construct(\dgsoft\StructType\DgVehicleRentalCoreType $vehRentalCore = null, \dgsoft\StructType\DgVehiclePrefType $vehicleInfo = null, \dgsoft\ArrayType\DgArrayOfOTA_VehRateRuleRQRentalInfoSpecialEquipPref $specialEquipPrefs = null, array $custLoyalty = array(), \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfoRateQualifier $rateQualifier = null, \dgsoft\StructType\DgOffLocationServiceType $offLocService = null, \dgsoft\StructType\DgVehicleArrivalDetailsType $arrivalDetails = null, \dgsoft\StructType\DgVehicleTourInfoType $tourInfo = null, \dgsoft\StructType\DgUniqueID_Type $customerID = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this
            ->setVehRentalCore($vehRentalCore)
            ->setVehicleInfo($vehicleInfo)
            ->setSpecialEquipPrefs($specialEquipPrefs)
            ->setCustLoyalty($custLoyalty)
            ->setRateQualifier($rateQualifier)
            ->setOffLocService($offLocService)
            ->setArrivalDetails($arrivalDetails)
            ->setTourInfo($tourInfo)
            ->setCustomerID($customerID)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get VehRentalCore value
     * @return \dgsoft\StructType\DgVehicleRentalCoreType|null
     */
    public function getVehRentalCore()
    {
        return $this->VehRentalCore;
    }
    /**
     * Set VehRentalCore value
     * @param \dgsoft\StructType\DgVehicleRentalCoreType $vehRentalCore
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfo
     */
    public function setVehRentalCore(\dgsoft\StructType\DgVehicleRentalCoreType $vehRentalCore = null)
    {
        $this->VehRentalCore = $vehRentalCore;
        return $this;
    }
    /**
     * Get VehicleInfo value
     * @return \dgsoft\StructType\DgVehiclePrefType|null
     */
    public function getVehicleInfo()
    {
        return $this->VehicleInfo;
    }
    /**
     * Set VehicleInfo value
     * @param \dgsoft\StructType\DgVehiclePrefType $vehicleInfo
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfo
     */
    public function setVehicleInfo(\dgsoft\StructType\DgVehiclePrefType $vehicleInfo = null)
    {
        $this->VehicleInfo = $vehicleInfo;
        return $this;
    }
    /**
     * Get SpecialEquipPrefs value
     * @return \dgsoft\ArrayType\DgArrayOfOTA_VehRateRuleRQRentalInfoSpecialEquipPref|null
     */
    public function getSpecialEquipPrefs()
    {
        return $this->SpecialEquipPrefs;
    }
    /**
     * Set SpecialEquipPrefs value
     * @param \dgsoft\ArrayType\DgArrayOfOTA_VehRateRuleRQRentalInfoSpecialEquipPref $specialEquipPrefs
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfo
     */
    public function setSpecialEquipPrefs(\dgsoft\ArrayType\DgArrayOfOTA_VehRateRuleRQRentalInfoSpecialEquipPref $specialEquipPrefs = null)
    {
        $this->SpecialEquipPrefs = $specialEquipPrefs;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfoCustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfoCustLoyalty[] $custLoyalty
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfo
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        foreach ($custLoyalty as $oTA_VehRateRuleRQRentalInfoCustLoyaltyItem) {
            // validation for constraint: itemType
            if (!$oTA_VehRateRuleRQRentalInfoCustLoyaltyItem instanceof \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfoCustLoyalty) {
                throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfoCustLoyalty, "%s" given', is_object($oTA_VehRateRuleRQRentalInfoCustLoyaltyItem) ? get_class($oTA_VehRateRuleRQRentalInfoCustLoyaltyItem) : gettype($oTA_VehRateRuleRQRentalInfoCustLoyaltyItem)), __LINE__);
            }
        }
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfoCustLoyalty $item
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfo
     */
    public function addToCustLoyalty(\dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfoCustLoyalty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfoCustLoyalty) {
            throw new \InvalidArgumentException(sprintf('The CustLoyalty property can only contain items of \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfoCustLoyalty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get RateQualifier value
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfoRateQualifier|null
     */
    public function getRateQualifier()
    {
        return $this->RateQualifier;
    }
    /**
     * Set RateQualifier value
     * @param \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfoRateQualifier $rateQualifier
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfo
     */
    public function setRateQualifier(\dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfoRateQualifier $rateQualifier = null)
    {
        $this->RateQualifier = $rateQualifier;
        return $this;
    }
    /**
     * Get OffLocService value
     * @return \dgsoft\StructType\DgOffLocationServiceType|null
     */
    public function getOffLocService()
    {
        return $this->OffLocService;
    }
    /**
     * Set OffLocService value
     * @param \dgsoft\StructType\DgOffLocationServiceType $offLocService
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfo
     */
    public function setOffLocService(\dgsoft\StructType\DgOffLocationServiceType $offLocService = null)
    {
        $this->OffLocService = $offLocService;
        return $this;
    }
    /**
     * Get ArrivalDetails value
     * @return \dgsoft\StructType\DgVehicleArrivalDetailsType|null
     */
    public function getArrivalDetails()
    {
        return $this->ArrivalDetails;
    }
    /**
     * Set ArrivalDetails value
     * @param \dgsoft\StructType\DgVehicleArrivalDetailsType $arrivalDetails
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfo
     */
    public function setArrivalDetails(\dgsoft\StructType\DgVehicleArrivalDetailsType $arrivalDetails = null)
    {
        $this->ArrivalDetails = $arrivalDetails;
        return $this;
    }
    /**
     * Get TourInfo value
     * @return \dgsoft\StructType\DgVehicleTourInfoType|null
     */
    public function getTourInfo()
    {
        return $this->TourInfo;
    }
    /**
     * Set TourInfo value
     * @param \dgsoft\StructType\DgVehicleTourInfoType $tourInfo
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfo
     */
    public function setTourInfo(\dgsoft\StructType\DgVehicleTourInfoType $tourInfo = null)
    {
        $this->TourInfo = $tourInfo;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return \dgsoft\StructType\DgUniqueID_Type|null
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param \dgsoft\StructType\DgUniqueID_Type $customerID
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfo
     */
    public function setCustomerID(\dgsoft\StructType\DgUniqueID_Type $customerID = null)
    {
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfo
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_VehRateRuleRQRentalInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
