<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_VehLocSearchRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_VehLocSearchRQ extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Version;
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSourceType
     */
    public $POS;
    /**
     * The VehLocSearchCriterion
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgItemSearchCriterionType[]
     */
    public $VehLocSearchCriterion;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType
     */
    public $Vendor;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - default: Production
     * @var string
     */
    public $Target;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The MaxResponses
     * @var int
     */
    public $MaxResponses;
    /**
     * The ReqRespVersion
     * @var string
     */
    public $ReqRespVersion;
    /**
     * The JustAddressPhone
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $JustAddressPhone;
    /**
     * Constructor method for OTA_VehLocSearchRQ
     * @uses DgOTA_VehLocSearchRQ::setVersion()
     * @uses DgOTA_VehLocSearchRQ::setPOS()
     * @uses DgOTA_VehLocSearchRQ::setVehLocSearchCriterion()
     * @uses DgOTA_VehLocSearchRQ::setVendor()
     * @uses DgOTA_VehLocSearchRQ::setTPA_Extensions()
     * @uses DgOTA_VehLocSearchRQ::setEchoToken()
     * @uses DgOTA_VehLocSearchRQ::setTimeStamp()
     * @uses DgOTA_VehLocSearchRQ::setTarget()
     * @uses DgOTA_VehLocSearchRQ::setTransactionIdentifier()
     * @uses DgOTA_VehLocSearchRQ::setSequenceNmbr()
     * @uses DgOTA_VehLocSearchRQ::setTransactionStatusCode()
     * @uses DgOTA_VehLocSearchRQ::setRetransmissionIndicator()
     * @uses DgOTA_VehLocSearchRQ::setMaxResponses()
     * @uses DgOTA_VehLocSearchRQ::setReqRespVersion()
     * @uses DgOTA_VehLocSearchRQ::setJustAddressPhone()
     * @param float $version
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @param \dgsoft\StructType\DgItemSearchCriterionType[] $vehLocSearchCriterion
     * @param \dgsoft\StructType\DgCompanyNameType $vendor
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param int $maxResponses
     * @param string $reqRespVersion
     * @param bool $justAddressPhone
     */
    public function __construct($version = null, \dgsoft\ArrayType\DgArrayOfSourceType $pOS = null, array $vehLocSearchCriterion = array(), \dgsoft\StructType\DgCompanyNameType $vendor = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $echoToken = null, $timeStamp = null, $target = 'Production', $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $maxResponses = null, $reqRespVersion = null, $justAddressPhone = false)
    {
        $this
            ->setVersion($version)
            ->setPOS($pOS)
            ->setVehLocSearchCriterion($vehLocSearchCriterion)
            ->setVendor($vendor)
            ->setTPA_Extensions($tPA_Extensions)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setMaxResponses($maxResponses)
            ->setReqRespVersion($reqRespVersion)
            ->setJustAddressPhone($justAddressPhone);
    }
    /**
     * Get Version value
     * @return float
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \dgsoft\StructType\DgOTA_VehLocSearchRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get POS value
     * @return \dgsoft\ArrayType\DgArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @return \dgsoft\StructType\DgOTA_VehLocSearchRQ
     */
    public function setPOS(\dgsoft\ArrayType\DgArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get VehLocSearchCriterion value
     * @return \dgsoft\StructType\DgItemSearchCriterionType[]|null
     */
    public function getVehLocSearchCriterion()
    {
        return $this->VehLocSearchCriterion;
    }
    /**
     * Set VehLocSearchCriterion value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgItemSearchCriterionType[] $vehLocSearchCriterion
     * @return \dgsoft\StructType\DgOTA_VehLocSearchRQ
     */
    public function setVehLocSearchCriterion(array $vehLocSearchCriterion = array())
    {
        foreach ($vehLocSearchCriterion as $oTA_VehLocSearchRQVehLocSearchCriterionItem) {
            // validation for constraint: itemType
            if (!$oTA_VehLocSearchRQVehLocSearchCriterionItem instanceof \dgsoft\StructType\DgItemSearchCriterionType) {
                throw new \InvalidArgumentException(sprintf('The VehLocSearchCriterion property can only contain items of \dgsoft\StructType\DgItemSearchCriterionType, "%s" given', is_object($oTA_VehLocSearchRQVehLocSearchCriterionItem) ? get_class($oTA_VehLocSearchRQVehLocSearchCriterionItem) : gettype($oTA_VehLocSearchRQVehLocSearchCriterionItem)), __LINE__);
            }
        }
        $this->VehLocSearchCriterion = $vehLocSearchCriterion;
        return $this;
    }
    /**
     * Add item to VehLocSearchCriterion value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgItemSearchCriterionType $item
     * @return \dgsoft\StructType\DgOTA_VehLocSearchRQ
     */
    public function addToVehLocSearchCriterion(\dgsoft\StructType\DgItemSearchCriterionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgItemSearchCriterionType) {
            throw new \InvalidArgumentException(sprintf('The VehLocSearchCriterion property can only contain items of \dgsoft\StructType\DgItemSearchCriterionType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehLocSearchCriterion[] = $item;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \dgsoft\StructType\DgCompanyNameType $vendor
     * @return \dgsoft\StructType\DgOTA_VehLocSearchRQ
     */
    public function setVendor(\dgsoft\StructType\DgCompanyNameType $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgOTA_VehLocSearchRQ
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \dgsoft\StructType\DgOTA_VehLocSearchRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \dgsoft\StructType\DgOTA_VehLocSearchRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @uses \dgsoft\EnumType\DgOTA_VehLocSearchRQTarget::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_VehLocSearchRQTarget::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $target
     * @return \dgsoft\StructType\DgOTA_VehLocSearchRQ
     */
    public function setTarget($target = 'Production')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_VehLocSearchRQTarget::valueIsValid($target)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $target, implode(', ', \dgsoft\EnumType\DgOTA_VehLocSearchRQTarget::getValidValues())), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \dgsoft\StructType\DgOTA_VehLocSearchRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \dgsoft\StructType\DgOTA_VehLocSearchRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @uses \dgsoft\EnumType\DgOTA_VehLocSearchRQTransactionStatusCode::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_VehLocSearchRQTransactionStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionStatusCode
     * @return \dgsoft\StructType\DgOTA_VehLocSearchRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_VehLocSearchRQTransactionStatusCode::valueIsValid($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionStatusCode, implode(', ', \dgsoft\EnumType\DgOTA_VehLocSearchRQTransactionStatusCode::getValidValues())), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \dgsoft\StructType\DgOTA_VehLocSearchRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get MaxResponses value
     * @return int|null
     */
    public function getMaxResponses()
    {
        return $this->MaxResponses;
    }
    /**
     * Set MaxResponses value
     * @param int $maxResponses
     * @return \dgsoft\StructType\DgOTA_VehLocSearchRQ
     */
    public function setMaxResponses($maxResponses = null)
    {
        // validation for constraint: int
        if (!is_null($maxResponses) && !is_numeric($maxResponses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxResponses)), __LINE__);
        }
        $this->MaxResponses = $maxResponses;
        return $this;
    }
    /**
     * Get ReqRespVersion value
     * @return string|null
     */
    public function getReqRespVersion()
    {
        return $this->ReqRespVersion;
    }
    /**
     * Set ReqRespVersion value
     * @param string $reqRespVersion
     * @return \dgsoft\StructType\DgOTA_VehLocSearchRQ
     */
    public function setReqRespVersion($reqRespVersion = null)
    {
        // validation for constraint: string
        if (!is_null($reqRespVersion) && !is_string($reqRespVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reqRespVersion)), __LINE__);
        }
        $this->ReqRespVersion = $reqRespVersion;
        return $this;
    }
    /**
     * Get JustAddressPhone value
     * @return bool|null
     */
    public function getJustAddressPhone()
    {
        return $this->JustAddressPhone;
    }
    /**
     * Set JustAddressPhone value
     * @param bool $justAddressPhone
     * @return \dgsoft\StructType\DgOTA_VehLocSearchRQ
     */
    public function setJustAddressPhone($justAddressPhone = false)
    {
        // validation for constraint: boolean
        if (!is_null($justAddressPhone) && !is_bool($justAddressPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($justAddressPhone)), __LINE__);
        }
        $this->JustAddressPhone = $justAddressPhone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_VehLocSearchRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
