<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_VehAvailRateRS StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_VehAvailRateRS extends AbstractStructBase
{
    /**
     * The HasMoreResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasMoreResult;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Version;
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSuccessType
     */
    public $Success;
    /**
     * The VehAvailRSCore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleAvailRSCoreType
     */
    public $VehAvailRSCore;
    /**
     * The VehAvailRSInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleAvailRSAdditionalInfoType
     */
    public $VehAvailRSInfo;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgWarningsType
     */
    public $Warnings;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgErrorsType
     */
    public $Errors;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - default: Production
     * @var string
     */
    public $Target;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * Constructor method for OTA_VehAvailRateRS
     * @uses DgOTA_VehAvailRateRS::setHasMoreResult()
     * @uses DgOTA_VehAvailRateRS::setVersion()
     * @uses DgOTA_VehAvailRateRS::setSuccess()
     * @uses DgOTA_VehAvailRateRS::setVehAvailRSCore()
     * @uses DgOTA_VehAvailRateRS::setVehAvailRSInfo()
     * @uses DgOTA_VehAvailRateRS::setWarnings()
     * @uses DgOTA_VehAvailRateRS::setErrors()
     * @uses DgOTA_VehAvailRateRS::setEchoToken()
     * @uses DgOTA_VehAvailRateRS::setTimeStamp()
     * @uses DgOTA_VehAvailRateRS::setTarget()
     * @uses DgOTA_VehAvailRateRS::setTransactionIdentifier()
     * @uses DgOTA_VehAvailRateRS::setSequenceNmbr()
     * @uses DgOTA_VehAvailRateRS::setTransactionStatusCode()
     * @uses DgOTA_VehAvailRateRS::setRetransmissionIndicator()
     * @param bool $hasMoreResult
     * @param float $version
     * @param \dgsoft\StructType\DgSuccessType $success
     * @param \dgsoft\StructType\DgVehicleAvailRSCoreType $vehAvailRSCore
     * @param \dgsoft\StructType\DgVehicleAvailRSAdditionalInfoType $vehAvailRSInfo
     * @param \dgsoft\StructType\DgWarningsType $warnings
     * @param \dgsoft\StructType\DgErrorsType $errors
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     */
    public function __construct($hasMoreResult = null, $version = null, \dgsoft\StructType\DgSuccessType $success = null, \dgsoft\StructType\DgVehicleAvailRSCoreType $vehAvailRSCore = null, \dgsoft\StructType\DgVehicleAvailRSAdditionalInfoType $vehAvailRSInfo = null, \dgsoft\StructType\DgWarningsType $warnings = null, \dgsoft\StructType\DgErrorsType $errors = null, $echoToken = null, $timeStamp = null, $target = 'Production', $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null)
    {
        $this
            ->setHasMoreResult($hasMoreResult)
            ->setVersion($version)
            ->setSuccess($success)
            ->setVehAvailRSCore($vehAvailRSCore)
            ->setVehAvailRSInfo($vehAvailRSInfo)
            ->setWarnings($warnings)
            ->setErrors($errors)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator);
    }
    /**
     * Get HasMoreResult value
     * @return bool
     */
    public function getHasMoreResult()
    {
        return $this->HasMoreResult;
    }
    /**
     * Set HasMoreResult value
     * @param bool $hasMoreResult
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRS
     */
    public function setHasMoreResult($hasMoreResult = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMoreResult) && !is_bool($hasMoreResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasMoreResult)), __LINE__);
        }
        $this->HasMoreResult = $hasMoreResult;
        return $this;
    }
    /**
     * Get Version value
     * @return float
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRS
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Success value
     * @return \dgsoft\StructType\DgSuccessType|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \dgsoft\StructType\DgSuccessType $success
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRS
     */
    public function setSuccess(\dgsoft\StructType\DgSuccessType $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get VehAvailRSCore value
     * @return \dgsoft\StructType\DgVehicleAvailRSCoreType|null
     */
    public function getVehAvailRSCore()
    {
        return $this->VehAvailRSCore;
    }
    /**
     * Set VehAvailRSCore value
     * @param \dgsoft\StructType\DgVehicleAvailRSCoreType $vehAvailRSCore
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRS
     */
    public function setVehAvailRSCore(\dgsoft\StructType\DgVehicleAvailRSCoreType $vehAvailRSCore = null)
    {
        $this->VehAvailRSCore = $vehAvailRSCore;
        return $this;
    }
    /**
     * Get VehAvailRSInfo value
     * @return \dgsoft\StructType\DgVehicleAvailRSAdditionalInfoType|null
     */
    public function getVehAvailRSInfo()
    {
        return $this->VehAvailRSInfo;
    }
    /**
     * Set VehAvailRSInfo value
     * @param \dgsoft\StructType\DgVehicleAvailRSAdditionalInfoType $vehAvailRSInfo
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRS
     */
    public function setVehAvailRSInfo(\dgsoft\StructType\DgVehicleAvailRSAdditionalInfoType $vehAvailRSInfo = null)
    {
        $this->VehAvailRSInfo = $vehAvailRSInfo;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \dgsoft\StructType\DgWarningsType|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \dgsoft\StructType\DgWarningsType $warnings
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRS
     */
    public function setWarnings(\dgsoft\StructType\DgWarningsType $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get Errors value
     * @return \dgsoft\StructType\DgErrorsType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \dgsoft\StructType\DgErrorsType $errors
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRS
     */
    public function setErrors(\dgsoft\StructType\DgErrorsType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRS
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @uses \dgsoft\EnumType\DgOTA_VehAvailRateRSTarget::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_VehAvailRateRSTarget::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $target
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRS
     */
    public function setTarget($target = 'Production')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_VehAvailRateRSTarget::valueIsValid($target)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $target, implode(', ', \dgsoft\EnumType\DgOTA_VehAvailRateRSTarget::getValidValues())), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRS
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRS
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @uses \dgsoft\EnumType\DgOTA_VehAvailRateRSTransactionStatusCode::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_VehAvailRateRSTransactionStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionStatusCode
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRS
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_VehAvailRateRSTransactionStatusCode::valueIsValid($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionStatusCode, implode(', ', \dgsoft\EnumType\DgOTA_VehAvailRateRSTransactionStatusCode::getValidValues())), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRS
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
