<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_VehAvailRateRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_VehAvailRateRQ extends AbstractStructBase
{
    /**
     * The MoreResults
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $MoreResults;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Version;
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSourceType
     */
    public $POS;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID_Type[]
     */
    public $CustomerID;
    /**
     * The VehAvailRQCore
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_VehAvailRateRQVehAvailRQCore
     */
    public $VehAvailRQCore;
    /**
     * The VehAvailRQInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType
     */
    public $VehAvailRQInfo;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - default: Production
     * @var string
     */
    public $Target;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The ReqRespVersion
     * @var string
     */
    public $ReqRespVersion;
    /**
     * The MaxResponses
     * @var int
     */
    public $MaxResponses;
    /**
     * The MaxPerVendorInd
     * @var bool
     */
    public $MaxPerVendorInd;
    /**
     * Constructor method for OTA_VehAvailRateRQ
     * @uses DgOTA_VehAvailRateRQ::setMoreResults()
     * @uses DgOTA_VehAvailRateRQ::setVersion()
     * @uses DgOTA_VehAvailRateRQ::setPOS()
     * @uses DgOTA_VehAvailRateRQ::setCustomerID()
     * @uses DgOTA_VehAvailRateRQ::setVehAvailRQCore()
     * @uses DgOTA_VehAvailRateRQ::setVehAvailRQInfo()
     * @uses DgOTA_VehAvailRateRQ::setEchoToken()
     * @uses DgOTA_VehAvailRateRQ::setTimeStamp()
     * @uses DgOTA_VehAvailRateRQ::setTarget()
     * @uses DgOTA_VehAvailRateRQ::setTransactionIdentifier()
     * @uses DgOTA_VehAvailRateRQ::setSequenceNmbr()
     * @uses DgOTA_VehAvailRateRQ::setTransactionStatusCode()
     * @uses DgOTA_VehAvailRateRQ::setRetransmissionIndicator()
     * @uses DgOTA_VehAvailRateRQ::setReqRespVersion()
     * @uses DgOTA_VehAvailRateRQ::setMaxResponses()
     * @uses DgOTA_VehAvailRateRQ::setMaxPerVendorInd()
     * @param bool $moreResults
     * @param float $version
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @param \dgsoft\StructType\DgUniqueID_Type[] $customerID
     * @param \dgsoft\StructType\DgOTA_VehAvailRateRQVehAvailRQCore $vehAvailRQCore
     * @param \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType $vehAvailRQInfo
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param string $reqRespVersion
     * @param int $maxResponses
     * @param bool $maxPerVendorInd
     */
    public function __construct($moreResults = null, $version = null, \dgsoft\ArrayType\DgArrayOfSourceType $pOS = null, array $customerID = array(), \dgsoft\StructType\DgOTA_VehAvailRateRQVehAvailRQCore $vehAvailRQCore = null, \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType $vehAvailRQInfo = null, $echoToken = null, $timeStamp = null, $target = 'Production', $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $reqRespVersion = null, $maxResponses = null, $maxPerVendorInd = null)
    {
        $this
            ->setMoreResults($moreResults)
            ->setVersion($version)
            ->setPOS($pOS)
            ->setCustomerID($customerID)
            ->setVehAvailRQCore($vehAvailRQCore)
            ->setVehAvailRQInfo($vehAvailRQInfo)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setReqRespVersion($reqRespVersion)
            ->setMaxResponses($maxResponses)
            ->setMaxPerVendorInd($maxPerVendorInd);
    }
    /**
     * Get MoreResults value
     * @return bool
     */
    public function getMoreResults()
    {
        return $this->MoreResults;
    }
    /**
     * Set MoreResults value
     * @param bool $moreResults
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRQ
     */
    public function setMoreResults($moreResults = null)
    {
        // validation for constraint: boolean
        if (!is_null($moreResults) && !is_bool($moreResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($moreResults)), __LINE__);
        }
        $this->MoreResults = $moreResults;
        return $this;
    }
    /**
     * Get Version value
     * @return float
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get POS value
     * @return \dgsoft\ArrayType\DgArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRQ
     */
    public function setPOS(\dgsoft\ArrayType\DgArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return \dgsoft\StructType\DgUniqueID_Type[]|null
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID_Type[] $customerID
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRQ
     */
    public function setCustomerID(array $customerID = array())
    {
        foreach ($customerID as $oTA_VehAvailRateRQCustomerIDItem) {
            // validation for constraint: itemType
            if (!$oTA_VehAvailRateRQCustomerIDItem instanceof \dgsoft\StructType\DgUniqueID_Type) {
                throw new \InvalidArgumentException(sprintf('The CustomerID property can only contain items of \dgsoft\StructType\DgUniqueID_Type, "%s" given', is_object($oTA_VehAvailRateRQCustomerIDItem) ? get_class($oTA_VehAvailRateRQCustomerIDItem) : gettype($oTA_VehAvailRateRQCustomerIDItem)), __LINE__);
            }
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Add item to CustomerID value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID_Type $item
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRQ
     */
    public function addToCustomerID(\dgsoft\StructType\DgUniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgUniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The CustomerID property can only contain items of \dgsoft\StructType\DgUniqueID_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerID[] = $item;
        return $this;
    }
    /**
     * Get VehAvailRQCore value
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRQVehAvailRQCore|null
     */
    public function getVehAvailRQCore()
    {
        return $this->VehAvailRQCore;
    }
    /**
     * Set VehAvailRQCore value
     * @param \dgsoft\StructType\DgOTA_VehAvailRateRQVehAvailRQCore $vehAvailRQCore
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRQ
     */
    public function setVehAvailRQCore(\dgsoft\StructType\DgOTA_VehAvailRateRQVehAvailRQCore $vehAvailRQCore = null)
    {
        $this->VehAvailRQCore = $vehAvailRQCore;
        return $this;
    }
    /**
     * Get VehAvailRQInfo value
     * @return \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType|null
     */
    public function getVehAvailRQInfo()
    {
        return $this->VehAvailRQInfo;
    }
    /**
     * Set VehAvailRQInfo value
     * @param \dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType $vehAvailRQInfo
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRQ
     */
    public function setVehAvailRQInfo(\dgsoft\StructType\DgVehicleAvailRQAdditionalInfoType $vehAvailRQInfo = null)
    {
        $this->VehAvailRQInfo = $vehAvailRQInfo;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @uses \dgsoft\EnumType\DgOTA_VehAvailRateRQTarget::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_VehAvailRateRQTarget::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $target
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRQ
     */
    public function setTarget($target = 'Production')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_VehAvailRateRQTarget::valueIsValid($target)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $target, implode(', ', \dgsoft\EnumType\DgOTA_VehAvailRateRQTarget::getValidValues())), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @uses \dgsoft\EnumType\DgOTA_VehAvailRateRQTransactionStatusCode::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_VehAvailRateRQTransactionStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionStatusCode
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_VehAvailRateRQTransactionStatusCode::valueIsValid($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionStatusCode, implode(', ', \dgsoft\EnumType\DgOTA_VehAvailRateRQTransactionStatusCode::getValidValues())), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get ReqRespVersion value
     * @return string|null
     */
    public function getReqRespVersion()
    {
        return $this->ReqRespVersion;
    }
    /**
     * Set ReqRespVersion value
     * @param string $reqRespVersion
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRQ
     */
    public function setReqRespVersion($reqRespVersion = null)
    {
        // validation for constraint: string
        if (!is_null($reqRespVersion) && !is_string($reqRespVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reqRespVersion)), __LINE__);
        }
        $this->ReqRespVersion = $reqRespVersion;
        return $this;
    }
    /**
     * Get MaxResponses value
     * @return int|null
     */
    public function getMaxResponses()
    {
        return $this->MaxResponses;
    }
    /**
     * Set MaxResponses value
     * @param int $maxResponses
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRQ
     */
    public function setMaxResponses($maxResponses = null)
    {
        // validation for constraint: int
        if (!is_null($maxResponses) && !is_numeric($maxResponses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxResponses)), __LINE__);
        }
        $this->MaxResponses = $maxResponses;
        return $this;
    }
    /**
     * Get MaxPerVendorInd value
     * @return bool|null
     */
    public function getMaxPerVendorInd()
    {
        return $this->MaxPerVendorInd;
    }
    /**
     * Set MaxPerVendorInd value
     * @param bool $maxPerVendorInd
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRQ
     */
    public function setMaxPerVendorInd($maxPerVendorInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($maxPerVendorInd) && !is_bool($maxPerVendorInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($maxPerVendorInd)), __LINE__);
        }
        $this->MaxPerVendorInd = $maxPerVendorInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_VehAvailRateRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
