<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_InsurancePlanSearchRQSearchTripInfo StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_InsurancePlanSearchRQSearchTripInfo extends AbstractStructBase
{
    /**
     * The TravelSector
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TravelSector;
    /**
     * The TotalTripCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTripInfoTotalTripCost
     */
    public $TotalTripCost;
    /**
     * The MaximumTripLength
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTimeDurationType
     */
    public $MaximumTripLength;
    /**
     * The CoveredTrips
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfOTA_InsurancePlanSearchRQSearchTripInfoCoveredTrip
     */
    public $CoveredTrips;
    /**
     * Constructor method for OTA_InsurancePlanSearchRQSearchTripInfo
     * @uses DgOTA_InsurancePlanSearchRQSearchTripInfo::setTravelSector()
     * @uses DgOTA_InsurancePlanSearchRQSearchTripInfo::setTotalTripCost()
     * @uses DgOTA_InsurancePlanSearchRQSearchTripInfo::setMaximumTripLength()
     * @uses DgOTA_InsurancePlanSearchRQSearchTripInfo::setCoveredTrips()
     * @param string[] $travelSector
     * @param \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTripInfoTotalTripCost $totalTripCost
     * @param \dgsoft\StructType\DgTimeDurationType $maximumTripLength
     * @param \dgsoft\ArrayType\DgArrayOfOTA_InsurancePlanSearchRQSearchTripInfoCoveredTrip $coveredTrips
     */
    public function __construct(array $travelSector = array(), \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTripInfoTotalTripCost $totalTripCost = null, \dgsoft\StructType\DgTimeDurationType $maximumTripLength = null, \dgsoft\ArrayType\DgArrayOfOTA_InsurancePlanSearchRQSearchTripInfoCoveredTrip $coveredTrips = null)
    {
        $this
            ->setTravelSector($travelSector)
            ->setTotalTripCost($totalTripCost)
            ->setMaximumTripLength($maximumTripLength)
            ->setCoveredTrips($coveredTrips);
    }
    /**
     * Get TravelSector value
     * @return string[]|null
     */
    public function getTravelSector()
    {
        return $this->TravelSector;
    }
    /**
     * Set TravelSector value
     * @throws \InvalidArgumentException
     * @param string[] $travelSector
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTripInfo
     */
    public function setTravelSector(array $travelSector = array())
    {
        foreach ($travelSector as $oTA_InsurancePlanSearchRQSearchTripInfoTravelSectorItem) {
            // validation for constraint: itemType
            if (!is_string($oTA_InsurancePlanSearchRQSearchTripInfoTravelSectorItem)) {
                throw new \InvalidArgumentException(sprintf('The TravelSector property can only contain items of string, "%s" given', is_object($oTA_InsurancePlanSearchRQSearchTripInfoTravelSectorItem) ? get_class($oTA_InsurancePlanSearchRQSearchTripInfoTravelSectorItem) : gettype($oTA_InsurancePlanSearchRQSearchTripInfoTravelSectorItem)), __LINE__);
            }
        }
        $this->TravelSector = $travelSector;
        return $this;
    }
    /**
     * Add item to TravelSector value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTripInfo
     */
    public function addToTravelSector($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The TravelSector property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelSector[] = $item;
        return $this;
    }
    /**
     * Get TotalTripCost value
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTripInfoTotalTripCost|null
     */
    public function getTotalTripCost()
    {
        return $this->TotalTripCost;
    }
    /**
     * Set TotalTripCost value
     * @param \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTripInfoTotalTripCost $totalTripCost
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTripInfo
     */
    public function setTotalTripCost(\dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTripInfoTotalTripCost $totalTripCost = null)
    {
        $this->TotalTripCost = $totalTripCost;
        return $this;
    }
    /**
     * Get MaximumTripLength value
     * @return \dgsoft\StructType\DgTimeDurationType|null
     */
    public function getMaximumTripLength()
    {
        return $this->MaximumTripLength;
    }
    /**
     * Set MaximumTripLength value
     * @param \dgsoft\StructType\DgTimeDurationType $maximumTripLength
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTripInfo
     */
    public function setMaximumTripLength(\dgsoft\StructType\DgTimeDurationType $maximumTripLength = null)
    {
        $this->MaximumTripLength = $maximumTripLength;
        return $this;
    }
    /**
     * Get CoveredTrips value
     * @return \dgsoft\ArrayType\DgArrayOfOTA_InsurancePlanSearchRQSearchTripInfoCoveredTrip|null
     */
    public function getCoveredTrips()
    {
        return $this->CoveredTrips;
    }
    /**
     * Set CoveredTrips value
     * @param \dgsoft\ArrayType\DgArrayOfOTA_InsurancePlanSearchRQSearchTripInfoCoveredTrip $coveredTrips
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTripInfo
     */
    public function setCoveredTrips(\dgsoft\ArrayType\DgArrayOfOTA_InsurancePlanSearchRQSearchTripInfoCoveredTrip $coveredTrips = null)
    {
        $this->CoveredTrips = $coveredTrips;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_InsurancePlanSearchRQSearchTripInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
