<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_InsuranceBookRSPlanForBookRSPolicyDetail StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_InsuranceBookRSPlanForBookRSPolicyDetail extends AbstractStructBase
{
    /**
     * The PolicyNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID_Type
     */
    public $PolicyNumber;
    /**
     * The RefNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID_Type[]
     */
    public $RefNumber;
    /**
     * The PlanRestrictions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfPlanRestrictionTypePlanRestriction
     */
    public $PlanRestrictions;
    /**
     * The PolicyDetailURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgURL_Type
     */
    public $PolicyDetailURL;
    /**
     * The OrderDate
     * @var string
     */
    public $OrderDate;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * Constructor method for OTA_InsuranceBookRSPlanForBookRSPolicyDetail
     * @uses DgOTA_InsuranceBookRSPlanForBookRSPolicyDetail::setPolicyNumber()
     * @uses DgOTA_InsuranceBookRSPlanForBookRSPolicyDetail::setRefNumber()
     * @uses DgOTA_InsuranceBookRSPlanForBookRSPolicyDetail::setPlanRestrictions()
     * @uses DgOTA_InsuranceBookRSPlanForBookRSPolicyDetail::setPolicyDetailURL()
     * @uses DgOTA_InsuranceBookRSPlanForBookRSPolicyDetail::setOrderDate()
     * @uses DgOTA_InsuranceBookRSPlanForBookRSPolicyDetail::setEffectiveDate()
     * @uses DgOTA_InsuranceBookRSPlanForBookRSPolicyDetail::setExpireDate()
     * @param \dgsoft\StructType\DgUniqueID_Type $policyNumber
     * @param \dgsoft\StructType\DgUniqueID_Type[] $refNumber
     * @param \dgsoft\ArrayType\DgArrayOfPlanRestrictionTypePlanRestriction $planRestrictions
     * @param \dgsoft\StructType\DgURL_Type $policyDetailURL
     * @param string $orderDate
     * @param string $effectiveDate
     * @param string $expireDate
     */
    public function __construct(\dgsoft\StructType\DgUniqueID_Type $policyNumber = null, array $refNumber = array(), \dgsoft\ArrayType\DgArrayOfPlanRestrictionTypePlanRestriction $planRestrictions = null, \dgsoft\StructType\DgURL_Type $policyDetailURL = null, $orderDate = null, $effectiveDate = null, $expireDate = null)
    {
        $this
            ->setPolicyNumber($policyNumber)
            ->setRefNumber($refNumber)
            ->setPlanRestrictions($planRestrictions)
            ->setPolicyDetailURL($policyDetailURL)
            ->setOrderDate($orderDate)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate);
    }
    /**
     * Get PolicyNumber value
     * @return \dgsoft\StructType\DgUniqueID_Type|null
     */
    public function getPolicyNumber()
    {
        return $this->PolicyNumber;
    }
    /**
     * Set PolicyNumber value
     * @param \dgsoft\StructType\DgUniqueID_Type $policyNumber
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRSPolicyDetail
     */
    public function setPolicyNumber(\dgsoft\StructType\DgUniqueID_Type $policyNumber = null)
    {
        $this->PolicyNumber = $policyNumber;
        return $this;
    }
    /**
     * Get RefNumber value
     * @return \dgsoft\StructType\DgUniqueID_Type[]|null
     */
    public function getRefNumber()
    {
        return $this->RefNumber;
    }
    /**
     * Set RefNumber value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID_Type[] $refNumber
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRSPolicyDetail
     */
    public function setRefNumber(array $refNumber = array())
    {
        foreach ($refNumber as $oTA_InsuranceBookRSPlanForBookRSPolicyDetailRefNumberItem) {
            // validation for constraint: itemType
            if (!$oTA_InsuranceBookRSPlanForBookRSPolicyDetailRefNumberItem instanceof \dgsoft\StructType\DgUniqueID_Type) {
                throw new \InvalidArgumentException(sprintf('The RefNumber property can only contain items of \dgsoft\StructType\DgUniqueID_Type, "%s" given', is_object($oTA_InsuranceBookRSPlanForBookRSPolicyDetailRefNumberItem) ? get_class($oTA_InsuranceBookRSPlanForBookRSPolicyDetailRefNumberItem) : gettype($oTA_InsuranceBookRSPlanForBookRSPolicyDetailRefNumberItem)), __LINE__);
            }
        }
        $this->RefNumber = $refNumber;
        return $this;
    }
    /**
     * Add item to RefNumber value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID_Type $item
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRSPolicyDetail
     */
    public function addToRefNumber(\dgsoft\StructType\DgUniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgUniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The RefNumber property can only contain items of \dgsoft\StructType\DgUniqueID_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RefNumber[] = $item;
        return $this;
    }
    /**
     * Get PlanRestrictions value
     * @return \dgsoft\ArrayType\DgArrayOfPlanRestrictionTypePlanRestriction|null
     */
    public function getPlanRestrictions()
    {
        return $this->PlanRestrictions;
    }
    /**
     * Set PlanRestrictions value
     * @param \dgsoft\ArrayType\DgArrayOfPlanRestrictionTypePlanRestriction $planRestrictions
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRSPolicyDetail
     */
    public function setPlanRestrictions(\dgsoft\ArrayType\DgArrayOfPlanRestrictionTypePlanRestriction $planRestrictions = null)
    {
        $this->PlanRestrictions = $planRestrictions;
        return $this;
    }
    /**
     * Get PolicyDetailURL value
     * @return \dgsoft\StructType\DgURL_Type|null
     */
    public function getPolicyDetailURL()
    {
        return $this->PolicyDetailURL;
    }
    /**
     * Set PolicyDetailURL value
     * @param \dgsoft\StructType\DgURL_Type $policyDetailURL
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRSPolicyDetail
     */
    public function setPolicyDetailURL(\dgsoft\StructType\DgURL_Type $policyDetailURL = null)
    {
        $this->PolicyDetailURL = $policyDetailURL;
        return $this;
    }
    /**
     * Get OrderDate value
     * @return string|null
     */
    public function getOrderDate()
    {
        return $this->OrderDate;
    }
    /**
     * Set OrderDate value
     * @param string $orderDate
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRSPolicyDetail
     */
    public function setOrderDate($orderDate = null)
    {
        // validation for constraint: string
        if (!is_null($orderDate) && !is_string($orderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderDate)), __LINE__);
        }
        $this->OrderDate = $orderDate;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRSPolicyDetail
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRSPolicyDetail
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRSPolicyDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
