<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_HotelSearchRS StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_HotelSearchRS extends AbstractStructBase
{
    /**
     * The HasMoreResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasMoreResult;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Version;
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSourceType
     */
    public $POS;
    /**
     * The Criteria
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgHotelSearchCriteriaType
     */
    public $Criteria;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgErrorsType
     */
    public $Errors;
    /**
     * The Areas
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfAreasTypeArea
     */
    public $Areas;
    /**
     * The Properties
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfPropertiesTypeProperty
     */
    public $Properties;
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSuccessType
     */
    public $Success;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfWarningType
     */
    public $Warnings;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - default: Production
     * @var string
     */
    public $Target;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * Constructor method for OTA_HotelSearchRS
     * @uses DgOTA_HotelSearchRS::setHasMoreResult()
     * @uses DgOTA_HotelSearchRS::setVersion()
     * @uses DgOTA_HotelSearchRS::setPOS()
     * @uses DgOTA_HotelSearchRS::setCriteria()
     * @uses DgOTA_HotelSearchRS::setErrors()
     * @uses DgOTA_HotelSearchRS::setAreas()
     * @uses DgOTA_HotelSearchRS::setProperties()
     * @uses DgOTA_HotelSearchRS::setSuccess()
     * @uses DgOTA_HotelSearchRS::setTPA_Extensions()
     * @uses DgOTA_HotelSearchRS::setWarnings()
     * @uses DgOTA_HotelSearchRS::setEchoToken()
     * @uses DgOTA_HotelSearchRS::setTimeStamp()
     * @uses DgOTA_HotelSearchRS::setTarget()
     * @uses DgOTA_HotelSearchRS::setTransactionIdentifier()
     * @uses DgOTA_HotelSearchRS::setSequenceNmbr()
     * @uses DgOTA_HotelSearchRS::setTransactionStatusCode()
     * @uses DgOTA_HotelSearchRS::setRetransmissionIndicator()
     * @param bool $hasMoreResult
     * @param float $version
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @param \dgsoft\StructType\DgHotelSearchCriteriaType $criteria
     * @param \dgsoft\StructType\DgErrorsType $errors
     * @param \dgsoft\ArrayType\DgArrayOfAreasTypeArea $areas
     * @param \dgsoft\ArrayType\DgArrayOfPropertiesTypeProperty $properties
     * @param \dgsoft\StructType\DgSuccessType $success
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param \dgsoft\ArrayType\DgArrayOfWarningType $warnings
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     */
    public function __construct($hasMoreResult = null, $version = null, \dgsoft\ArrayType\DgArrayOfSourceType $pOS = null, \dgsoft\StructType\DgHotelSearchCriteriaType $criteria = null, \dgsoft\StructType\DgErrorsType $errors = null, \dgsoft\ArrayType\DgArrayOfAreasTypeArea $areas = null, \dgsoft\ArrayType\DgArrayOfPropertiesTypeProperty $properties = null, \dgsoft\StructType\DgSuccessType $success = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, \dgsoft\ArrayType\DgArrayOfWarningType $warnings = null, $echoToken = null, $timeStamp = null, $target = 'Production', $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null)
    {
        $this
            ->setHasMoreResult($hasMoreResult)
            ->setVersion($version)
            ->setPOS($pOS)
            ->setCriteria($criteria)
            ->setErrors($errors)
            ->setAreas($areas)
            ->setProperties($properties)
            ->setSuccess($success)
            ->setTPA_Extensions($tPA_Extensions)
            ->setWarnings($warnings)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator);
    }
    /**
     * Get HasMoreResult value
     * @return bool
     */
    public function getHasMoreResult()
    {
        return $this->HasMoreResult;
    }
    /**
     * Set HasMoreResult value
     * @param bool $hasMoreResult
     * @return \dgsoft\StructType\DgOTA_HotelSearchRS
     */
    public function setHasMoreResult($hasMoreResult = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMoreResult) && !is_bool($hasMoreResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasMoreResult)), __LINE__);
        }
        $this->HasMoreResult = $hasMoreResult;
        return $this;
    }
    /**
     * Get Version value
     * @return float
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \dgsoft\StructType\DgOTA_HotelSearchRS
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get POS value
     * @return \dgsoft\ArrayType\DgArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @return \dgsoft\StructType\DgOTA_HotelSearchRS
     */
    public function setPOS(\dgsoft\ArrayType\DgArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get Criteria value
     * @return \dgsoft\StructType\DgHotelSearchCriteriaType|null
     */
    public function getCriteria()
    {
        return $this->Criteria;
    }
    /**
     * Set Criteria value
     * @param \dgsoft\StructType\DgHotelSearchCriteriaType $criteria
     * @return \dgsoft\StructType\DgOTA_HotelSearchRS
     */
    public function setCriteria(\dgsoft\StructType\DgHotelSearchCriteriaType $criteria = null)
    {
        $this->Criteria = $criteria;
        return $this;
    }
    /**
     * Get Errors value
     * @return \dgsoft\StructType\DgErrorsType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \dgsoft\StructType\DgErrorsType $errors
     * @return \dgsoft\StructType\DgOTA_HotelSearchRS
     */
    public function setErrors(\dgsoft\StructType\DgErrorsType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Areas value
     * @return \dgsoft\ArrayType\DgArrayOfAreasTypeArea|null
     */
    public function getAreas()
    {
        return $this->Areas;
    }
    /**
     * Set Areas value
     * @param \dgsoft\ArrayType\DgArrayOfAreasTypeArea $areas
     * @return \dgsoft\StructType\DgOTA_HotelSearchRS
     */
    public function setAreas(\dgsoft\ArrayType\DgArrayOfAreasTypeArea $areas = null)
    {
        $this->Areas = $areas;
        return $this;
    }
    /**
     * Get Properties value
     * @return \dgsoft\ArrayType\DgArrayOfPropertiesTypeProperty|null
     */
    public function getProperties()
    {
        return $this->Properties;
    }
    /**
     * Set Properties value
     * @param \dgsoft\ArrayType\DgArrayOfPropertiesTypeProperty $properties
     * @return \dgsoft\StructType\DgOTA_HotelSearchRS
     */
    public function setProperties(\dgsoft\ArrayType\DgArrayOfPropertiesTypeProperty $properties = null)
    {
        $this->Properties = $properties;
        return $this;
    }
    /**
     * Get Success value
     * @return \dgsoft\StructType\DgSuccessType|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \dgsoft\StructType\DgSuccessType $success
     * @return \dgsoft\StructType\DgOTA_HotelSearchRS
     */
    public function setSuccess(\dgsoft\StructType\DgSuccessType $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgOTA_HotelSearchRS
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \dgsoft\ArrayType\DgArrayOfWarningType|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \dgsoft\ArrayType\DgArrayOfWarningType $warnings
     * @return \dgsoft\StructType\DgOTA_HotelSearchRS
     */
    public function setWarnings(\dgsoft\ArrayType\DgArrayOfWarningType $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \dgsoft\StructType\DgOTA_HotelSearchRS
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \dgsoft\StructType\DgOTA_HotelSearchRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \dgsoft\StructType\DgOTA_HotelSearchRS
     */
    public function setTarget($target = 'Production')
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \dgsoft\StructType\DgOTA_HotelSearchRS
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \dgsoft\StructType\DgOTA_HotelSearchRS
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \dgsoft\StructType\DgOTA_HotelSearchRS
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \dgsoft\StructType\DgOTA_HotelSearchRS
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_HotelSearchRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
