<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_HotelInfoRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_HotelInfoRQ extends AbstractStructBase
{
    /**
     * The HotelID
     * @var string
     */
    public $HotelID;
    /**
     * The CityCode
     * @var string
     */
    public $CityCode;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelChainCode
     * @var string
     */
    public $HotelChainCode;
    /**
     * Constructor method for OTA_HotelInfoRQ
     * @uses DgOTA_HotelInfoRQ::setHotelID()
     * @uses DgOTA_HotelInfoRQ::setCityCode()
     * @uses DgOTA_HotelInfoRQ::setHotelCode()
     * @uses DgOTA_HotelInfoRQ::setHotelChainCode()
     * @param string $hotelID
     * @param string $cityCode
     * @param string $hotelCode
     * @param string $hotelChainCode
     */
    public function __construct($hotelID = null, $cityCode = null, $hotelCode = null, $hotelChainCode = null)
    {
        $this
            ->setHotelID($hotelID)
            ->setCityCode($cityCode)
            ->setHotelCode($hotelCode)
            ->setHotelChainCode($hotelChainCode);
    }
    /**
     * Get HotelID value
     * @return string|null
     */
    public function getHotelID()
    {
        return $this->HotelID;
    }
    /**
     * Set HotelID value
     * @param string $hotelID
     * @return \dgsoft\StructType\DgOTA_HotelInfoRQ
     */
    public function setHotelID($hotelID = null)
    {
        // validation for constraint: string
        if (!is_null($hotelID) && !is_string($hotelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelID)), __LINE__);
        }
        $this->HotelID = $hotelID;
        return $this;
    }
    /**
     * Get CityCode value
     * @return string|null
     */
    public function getCityCode()
    {
        return $this->CityCode;
    }
    /**
     * Set CityCode value
     * @param string $cityCode
     * @return \dgsoft\StructType\DgOTA_HotelInfoRQ
     */
    public function setCityCode($cityCode = null)
    {
        // validation for constraint: string
        if (!is_null($cityCode) && !is_string($cityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityCode)), __LINE__);
        }
        $this->CityCode = $cityCode;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \dgsoft\StructType\DgOTA_HotelInfoRQ
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelChainCode value
     * @return string|null
     */
    public function getHotelChainCode()
    {
        return $this->HotelChainCode;
    }
    /**
     * Set HotelChainCode value
     * @param string $hotelChainCode
     * @return \dgsoft\StructType\DgOTA_HotelInfoRQ
     */
    public function setHotelChainCode($hotelChainCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelChainCode) && !is_string($hotelChainCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelChainCode)), __LINE__);
        }
        $this->HotelChainCode = $hotelChainCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_HotelInfoRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
