<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_HotelAvailRS StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_HotelAvailRS extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Version;
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSourceType
     */
    public $POS;
    /**
     * The Profiles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfProfilesTypeProfileInfo1
     */
    public $Profiles;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The Areas
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfAreasTypeArea
     */
    public $Areas;
    /**
     * The Criteria
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfHotelSearchCriterionType
     */
    public $Criteria;
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSuccessType
     */
    public $Success;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgErrorsType
     */
    public $Errors;
    /**
     * The RoomStays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRoomStays
     */
    public $RoomStays;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfWarningType
     */
    public $Warnings;
    /**
     * The Services
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfServicesTypeService1
     */
    public $Services;
    /**
     * The HotelStays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfOTA_HotelAvailRSHotelStaysHotelStay
     */
    public $HotelStays;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - default: Production
     * @var string
     */
    public $Target;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The SearchCacheLevel
     * @var string
     */
    public $SearchCacheLevel;
    /**
     * Constructor method for OTA_HotelAvailRS
     * @uses DgOTA_HotelAvailRS::setVersion()
     * @uses DgOTA_HotelAvailRS::setPOS()
     * @uses DgOTA_HotelAvailRS::setProfiles()
     * @uses DgOTA_HotelAvailRS::setTPA_Extensions()
     * @uses DgOTA_HotelAvailRS::setAreas()
     * @uses DgOTA_HotelAvailRS::setCriteria()
     * @uses DgOTA_HotelAvailRS::setSuccess()
     * @uses DgOTA_HotelAvailRS::setErrors()
     * @uses DgOTA_HotelAvailRS::setRoomStays()
     * @uses DgOTA_HotelAvailRS::setWarnings()
     * @uses DgOTA_HotelAvailRS::setServices()
     * @uses DgOTA_HotelAvailRS::setHotelStays()
     * @uses DgOTA_HotelAvailRS::setEchoToken()
     * @uses DgOTA_HotelAvailRS::setTimeStamp()
     * @uses DgOTA_HotelAvailRS::setTarget()
     * @uses DgOTA_HotelAvailRS::setTransactionIdentifier()
     * @uses DgOTA_HotelAvailRS::setSequenceNmbr()
     * @uses DgOTA_HotelAvailRS::setTransactionStatusCode()
     * @uses DgOTA_HotelAvailRS::setRetransmissionIndicator()
     * @uses DgOTA_HotelAvailRS::setSearchCacheLevel()
     * @param float $version
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @param \dgsoft\ArrayType\DgArrayOfProfilesTypeProfileInfo1 $profiles
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param \dgsoft\ArrayType\DgArrayOfAreasTypeArea $areas
     * @param \dgsoft\ArrayType\DgArrayOfHotelSearchCriterionType $criteria
     * @param \dgsoft\StructType\DgSuccessType $success
     * @param \dgsoft\StructType\DgErrorsType $errors
     * @param \dgsoft\StructType\DgRoomStays $roomStays
     * @param \dgsoft\ArrayType\DgArrayOfWarningType $warnings
     * @param \dgsoft\ArrayType\DgArrayOfServicesTypeService1 $services
     * @param \dgsoft\ArrayType\DgArrayOfOTA_HotelAvailRSHotelStaysHotelStay $hotelStays
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param string $searchCacheLevel
     */
    public function __construct($version = null, \dgsoft\ArrayType\DgArrayOfSourceType $pOS = null, \dgsoft\ArrayType\DgArrayOfProfilesTypeProfileInfo1 $profiles = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, \dgsoft\ArrayType\DgArrayOfAreasTypeArea $areas = null, \dgsoft\ArrayType\DgArrayOfHotelSearchCriterionType $criteria = null, \dgsoft\StructType\DgSuccessType $success = null, \dgsoft\StructType\DgErrorsType $errors = null, \dgsoft\StructType\DgRoomStays $roomStays = null, \dgsoft\ArrayType\DgArrayOfWarningType $warnings = null, \dgsoft\ArrayType\DgArrayOfServicesTypeService1 $services = null, \dgsoft\ArrayType\DgArrayOfOTA_HotelAvailRSHotelStaysHotelStay $hotelStays = null, $echoToken = null, $timeStamp = null, $target = 'Production', $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $searchCacheLevel = null)
    {
        $this
            ->setVersion($version)
            ->setPOS($pOS)
            ->setProfiles($profiles)
            ->setTPA_Extensions($tPA_Extensions)
            ->setAreas($areas)
            ->setCriteria($criteria)
            ->setSuccess($success)
            ->setErrors($errors)
            ->setRoomStays($roomStays)
            ->setWarnings($warnings)
            ->setServices($services)
            ->setHotelStays($hotelStays)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setSearchCacheLevel($searchCacheLevel);
    }
    /**
     * Get Version value
     * @return float
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get POS value
     * @return \dgsoft\ArrayType\DgArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setPOS(\dgsoft\ArrayType\DgArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get Profiles value
     * @return \dgsoft\ArrayType\DgArrayOfProfilesTypeProfileInfo1|null
     */
    public function getProfiles()
    {
        return $this->Profiles;
    }
    /**
     * Set Profiles value
     * @param \dgsoft\ArrayType\DgArrayOfProfilesTypeProfileInfo1 $profiles
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setProfiles(\dgsoft\ArrayType\DgArrayOfProfilesTypeProfileInfo1 $profiles = null)
    {
        $this->Profiles = $profiles;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Areas value
     * @return \dgsoft\ArrayType\DgArrayOfAreasTypeArea|null
     */
    public function getAreas()
    {
        return $this->Areas;
    }
    /**
     * Set Areas value
     * @param \dgsoft\ArrayType\DgArrayOfAreasTypeArea $areas
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setAreas(\dgsoft\ArrayType\DgArrayOfAreasTypeArea $areas = null)
    {
        $this->Areas = $areas;
        return $this;
    }
    /**
     * Get Criteria value
     * @return \dgsoft\ArrayType\DgArrayOfHotelSearchCriterionType|null
     */
    public function getCriteria()
    {
        return $this->Criteria;
    }
    /**
     * Set Criteria value
     * @param \dgsoft\ArrayType\DgArrayOfHotelSearchCriterionType $criteria
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setCriteria(\dgsoft\ArrayType\DgArrayOfHotelSearchCriterionType $criteria = null)
    {
        $this->Criteria = $criteria;
        return $this;
    }
    /**
     * Get Success value
     * @return \dgsoft\StructType\DgSuccessType|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \dgsoft\StructType\DgSuccessType $success
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setSuccess(\dgsoft\StructType\DgSuccessType $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get Errors value
     * @return \dgsoft\StructType\DgErrorsType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \dgsoft\StructType\DgErrorsType $errors
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setErrors(\dgsoft\StructType\DgErrorsType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get RoomStays value
     * @return \dgsoft\StructType\DgRoomStays|null
     */
    public function getRoomStays()
    {
        return $this->RoomStays;
    }
    /**
     * Set RoomStays value
     * @param \dgsoft\StructType\DgRoomStays $roomStays
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setRoomStays(\dgsoft\StructType\DgRoomStays $roomStays = null)
    {
        $this->RoomStays = $roomStays;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \dgsoft\ArrayType\DgArrayOfWarningType|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \dgsoft\ArrayType\DgArrayOfWarningType $warnings
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setWarnings(\dgsoft\ArrayType\DgArrayOfWarningType $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get Services value
     * @return \dgsoft\ArrayType\DgArrayOfServicesTypeService1|null
     */
    public function getServices()
    {
        return $this->Services;
    }
    /**
     * Set Services value
     * @param \dgsoft\ArrayType\DgArrayOfServicesTypeService1 $services
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setServices(\dgsoft\ArrayType\DgArrayOfServicesTypeService1 $services = null)
    {
        $this->Services = $services;
        return $this;
    }
    /**
     * Get HotelStays value
     * @return \dgsoft\ArrayType\DgArrayOfOTA_HotelAvailRSHotelStaysHotelStay|null
     */
    public function getHotelStays()
    {
        return $this->HotelStays;
    }
    /**
     * Set HotelStays value
     * @param \dgsoft\ArrayType\DgArrayOfOTA_HotelAvailRSHotelStaysHotelStay $hotelStays
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setHotelStays(\dgsoft\ArrayType\DgArrayOfOTA_HotelAvailRSHotelStaysHotelStay $hotelStays = null)
    {
        $this->HotelStays = $hotelStays;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setTarget($target = 'Production')
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get SearchCacheLevel value
     * @return string|null
     */
    public function getSearchCacheLevel()
    {
        return $this->SearchCacheLevel;
    }
    /**
     * Set SearchCacheLevel value
     * @param string $searchCacheLevel
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public function setSearchCacheLevel($searchCacheLevel = null)
    {
        // validation for constraint: string
        if (!is_null($searchCacheLevel) && !is_string($searchCacheLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchCacheLevel)), __LINE__);
        }
        $this->SearchCacheLevel = $searchCacheLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_HotelAvailRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
