<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_HotelAvailRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_HotelAvailRQ extends AbstractStructBase
{
    /**
     * The HotelID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $HotelID;
    /**
     * Constructor method for OTA_HotelAvailRQ
     * @uses DgOTA_HotelAvailRQ::setHotelID()
     * @param int $hotelID
     */
    public function __construct($hotelID = null)
    {
        $this
            ->setHotelID($hotelID);
    }
    /**
     * Get HotelID value
     * @return int
     */
    public function getHotelID()
    {
        return $this->HotelID;
    }
    /**
     * Set HotelID value
     * @param int $hotelID
     * @return \dgsoft\StructType\DgOTA_HotelAvailRQ
     */
    public function setHotelID($hotelID = null)
    {
        // validation for constraint: int
        if (!is_null($hotelID) && !is_numeric($hotelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hotelID)), __LINE__);
        }
        $this->HotelID = $hotelID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_HotelAvailRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
