<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirSeatMapRQSeatMapRequest StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_AirSeatMapRQSeatMapRequest extends AbstractStructBase
{
    /**
     * The FlightSegmentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFlightSegmentType
     */
    public $FlightSegmentInfo;
    /**
     * The SeatDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_AirSeatMapRQSeatMapRequestSeatDetails
     */
    public $SeatDetails;
    /**
     * The TravelerRefNumberRPHs
     * @var string[]
     */
    public $TravelerRefNumberRPHs;
    /**
     * Constructor method for OTA_AirSeatMapRQSeatMapRequest
     * @uses DgOTA_AirSeatMapRQSeatMapRequest::setFlightSegmentInfo()
     * @uses DgOTA_AirSeatMapRQSeatMapRequest::setSeatDetails()
     * @uses DgOTA_AirSeatMapRQSeatMapRequest::setTravelerRefNumberRPHs()
     * @param \dgsoft\StructType\DgFlightSegmentType $flightSegmentInfo
     * @param \dgsoft\StructType\DgOTA_AirSeatMapRQSeatMapRequestSeatDetails $seatDetails
     * @param string[] $travelerRefNumberRPHs
     */
    public function __construct(\dgsoft\StructType\DgFlightSegmentType $flightSegmentInfo = null, \dgsoft\StructType\DgOTA_AirSeatMapRQSeatMapRequestSeatDetails $seatDetails = null, array $travelerRefNumberRPHs = array())
    {
        $this
            ->setFlightSegmentInfo($flightSegmentInfo)
            ->setSeatDetails($seatDetails)
            ->setTravelerRefNumberRPHs($travelerRefNumberRPHs);
    }
    /**
     * Get FlightSegmentInfo value
     * @return \dgsoft\StructType\DgFlightSegmentType|null
     */
    public function getFlightSegmentInfo()
    {
        return $this->FlightSegmentInfo;
    }
    /**
     * Set FlightSegmentInfo value
     * @param \dgsoft\StructType\DgFlightSegmentType $flightSegmentInfo
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQSeatMapRequest
     */
    public function setFlightSegmentInfo(\dgsoft\StructType\DgFlightSegmentType $flightSegmentInfo = null)
    {
        $this->FlightSegmentInfo = $flightSegmentInfo;
        return $this;
    }
    /**
     * Get SeatDetails value
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQSeatMapRequestSeatDetails|null
     */
    public function getSeatDetails()
    {
        return $this->SeatDetails;
    }
    /**
     * Set SeatDetails value
     * @param \dgsoft\StructType\DgOTA_AirSeatMapRQSeatMapRequestSeatDetails $seatDetails
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQSeatMapRequest
     */
    public function setSeatDetails(\dgsoft\StructType\DgOTA_AirSeatMapRQSeatMapRequestSeatDetails $seatDetails = null)
    {
        $this->SeatDetails = $seatDetails;
        return $this;
    }
    /**
     * Get TravelerRefNumberRPHs value
     * @return string[]|null
     */
    public function getTravelerRefNumberRPHs()
    {
        return $this->TravelerRefNumberRPHs;
    }
    /**
     * Set TravelerRefNumberRPHs value
     * @throws \InvalidArgumentException
     * @param string[] $travelerRefNumberRPHs
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQSeatMapRequest
     */
    public function setTravelerRefNumberRPHs(array $travelerRefNumberRPHs = array())
    {
        foreach ($travelerRefNumberRPHs as $oTA_AirSeatMapRQSeatMapRequestTravelerRefNumberRPHsItem) {
            // validation for constraint: itemType
            if (!is_string($oTA_AirSeatMapRQSeatMapRequestTravelerRefNumberRPHsItem)) {
                throw new \InvalidArgumentException(sprintf('The TravelerRefNumberRPHs property can only contain items of string, "%s" given', is_object($oTA_AirSeatMapRQSeatMapRequestTravelerRefNumberRPHsItem) ? get_class($oTA_AirSeatMapRQSeatMapRequestTravelerRefNumberRPHsItem) : gettype($oTA_AirSeatMapRQSeatMapRequestTravelerRefNumberRPHsItem)), __LINE__);
            }
        }
        $this->TravelerRefNumberRPHs = $travelerRefNumberRPHs;
        return $this;
    }
    /**
     * Add item to TravelerRefNumberRPHs value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQSeatMapRequest
     */
    public function addToTravelerRefNumberRPHs($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The TravelerRefNumberRPHs property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelerRefNumberRPHs[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQSeatMapRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
