<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirSeatMapRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_AirSeatMapRQ extends AbstractStructBase
{
    /**
     * The GetJSONSeatMap
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $GetJSONSeatMap;
    /**
     * The RecommendationID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $RecommendationID;
    /**
     * The CombinationID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $CombinationID;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Version;
    /**
     * The FFCForSeatMap
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfFrequentFlyerCardsWithPassengerForSeatMap
     */
    public $FFCForSeatMap;
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSourceType
     */
    public $POS;
    /**
     * The SeatMapRequests
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfOTA_AirSeatMapRQSeatMapRequest
     */
    public $SeatMapRequests;
    /**
     * The AirTravelers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfOTA_AirSeatMapRQAirTraveler
     */
    public $AirTravelers;
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID_Type[]
     */
    public $BookingReferenceID;
    /**
     * The Culture
     * @var string
     */
    public $Culture;
    /**
     * The IsOneWayCombinable
     * @var bool
     */
    public $IsOneWayCombinable;
    /**
     * The ItineraryID
     * @var string
     */
    public $ItineraryID;
    /**
     * The SegmentID
     * @var string
     */
    public $SegmentID;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - default: Production
     * @var string
     */
    public $Target;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * Constructor method for OTA_AirSeatMapRQ
     * @uses DgOTA_AirSeatMapRQ::setGetJSONSeatMap()
     * @uses DgOTA_AirSeatMapRQ::setRecommendationID()
     * @uses DgOTA_AirSeatMapRQ::setCombinationID()
     * @uses DgOTA_AirSeatMapRQ::setVersion()
     * @uses DgOTA_AirSeatMapRQ::setFFCForSeatMap()
     * @uses DgOTA_AirSeatMapRQ::setPOS()
     * @uses DgOTA_AirSeatMapRQ::setSeatMapRequests()
     * @uses DgOTA_AirSeatMapRQ::setAirTravelers()
     * @uses DgOTA_AirSeatMapRQ::setBookingReferenceID()
     * @uses DgOTA_AirSeatMapRQ::setCulture()
     * @uses DgOTA_AirSeatMapRQ::setIsOneWayCombinable()
     * @uses DgOTA_AirSeatMapRQ::setItineraryID()
     * @uses DgOTA_AirSeatMapRQ::setSegmentID()
     * @uses DgOTA_AirSeatMapRQ::setEchoToken()
     * @uses DgOTA_AirSeatMapRQ::setTimeStamp()
     * @uses DgOTA_AirSeatMapRQ::setTarget()
     * @uses DgOTA_AirSeatMapRQ::setTransactionIdentifier()
     * @uses DgOTA_AirSeatMapRQ::setSequenceNmbr()
     * @uses DgOTA_AirSeatMapRQ::setTransactionStatusCode()
     * @uses DgOTA_AirSeatMapRQ::setRetransmissionIndicator()
     * @param bool $getJSONSeatMap
     * @param int $recommendationID
     * @param int $combinationID
     * @param float $version
     * @param \dgsoft\ArrayType\DgArrayOfFrequentFlyerCardsWithPassengerForSeatMap $fFCForSeatMap
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @param \dgsoft\ArrayType\DgArrayOfOTA_AirSeatMapRQSeatMapRequest $seatMapRequests
     * @param \dgsoft\ArrayType\DgArrayOfOTA_AirSeatMapRQAirTraveler $airTravelers
     * @param \dgsoft\StructType\DgUniqueID_Type[] $bookingReferenceID
     * @param string $culture
     * @param bool $isOneWayCombinable
     * @param string $itineraryID
     * @param string $segmentID
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     */
    public function __construct($getJSONSeatMap = null, $recommendationID = null, $combinationID = null, $version = null, \dgsoft\ArrayType\DgArrayOfFrequentFlyerCardsWithPassengerForSeatMap $fFCForSeatMap = null, \dgsoft\ArrayType\DgArrayOfSourceType $pOS = null, \dgsoft\ArrayType\DgArrayOfOTA_AirSeatMapRQSeatMapRequest $seatMapRequests = null, \dgsoft\ArrayType\DgArrayOfOTA_AirSeatMapRQAirTraveler $airTravelers = null, array $bookingReferenceID = array(), $culture = null, $isOneWayCombinable = null, $itineraryID = null, $segmentID = null, $echoToken = null, $timeStamp = null, $target = 'Production', $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null)
    {
        $this
            ->setGetJSONSeatMap($getJSONSeatMap)
            ->setRecommendationID($recommendationID)
            ->setCombinationID($combinationID)
            ->setVersion($version)
            ->setFFCForSeatMap($fFCForSeatMap)
            ->setPOS($pOS)
            ->setSeatMapRequests($seatMapRequests)
            ->setAirTravelers($airTravelers)
            ->setBookingReferenceID($bookingReferenceID)
            ->setCulture($culture)
            ->setIsOneWayCombinable($isOneWayCombinable)
            ->setItineraryID($itineraryID)
            ->setSegmentID($segmentID)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator);
    }
    /**
     * Get GetJSONSeatMap value
     * @return bool
     */
    public function getGetJSONSeatMap()
    {
        return $this->GetJSONSeatMap;
    }
    /**
     * Set GetJSONSeatMap value
     * @param bool $getJSONSeatMap
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setGetJSONSeatMap($getJSONSeatMap = null)
    {
        // validation for constraint: boolean
        if (!is_null($getJSONSeatMap) && !is_bool($getJSONSeatMap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($getJSONSeatMap)), __LINE__);
        }
        $this->GetJSONSeatMap = $getJSONSeatMap;
        return $this;
    }
    /**
     * Get RecommendationID value
     * @return int
     */
    public function getRecommendationID()
    {
        return $this->RecommendationID;
    }
    /**
     * Set RecommendationID value
     * @param int $recommendationID
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setRecommendationID($recommendationID = null)
    {
        // validation for constraint: int
        if (!is_null($recommendationID) && !is_numeric($recommendationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recommendationID)), __LINE__);
        }
        $this->RecommendationID = $recommendationID;
        return $this;
    }
    /**
     * Get CombinationID value
     * @return int
     */
    public function getCombinationID()
    {
        return $this->CombinationID;
    }
    /**
     * Set CombinationID value
     * @param int $combinationID
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setCombinationID($combinationID = null)
    {
        // validation for constraint: int
        if (!is_null($combinationID) && !is_numeric($combinationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($combinationID)), __LINE__);
        }
        $this->CombinationID = $combinationID;
        return $this;
    }
    /**
     * Get Version value
     * @return float
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get FFCForSeatMap value
     * @return \dgsoft\ArrayType\DgArrayOfFrequentFlyerCardsWithPassengerForSeatMap|null
     */
    public function getFFCForSeatMap()
    {
        return $this->FFCForSeatMap;
    }
    /**
     * Set FFCForSeatMap value
     * @param \dgsoft\ArrayType\DgArrayOfFrequentFlyerCardsWithPassengerForSeatMap $fFCForSeatMap
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setFFCForSeatMap(\dgsoft\ArrayType\DgArrayOfFrequentFlyerCardsWithPassengerForSeatMap $fFCForSeatMap = null)
    {
        $this->FFCForSeatMap = $fFCForSeatMap;
        return $this;
    }
    /**
     * Get POS value
     * @return \dgsoft\ArrayType\DgArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setPOS(\dgsoft\ArrayType\DgArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get SeatMapRequests value
     * @return \dgsoft\ArrayType\DgArrayOfOTA_AirSeatMapRQSeatMapRequest|null
     */
    public function getSeatMapRequests()
    {
        return $this->SeatMapRequests;
    }
    /**
     * Set SeatMapRequests value
     * @param \dgsoft\ArrayType\DgArrayOfOTA_AirSeatMapRQSeatMapRequest $seatMapRequests
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setSeatMapRequests(\dgsoft\ArrayType\DgArrayOfOTA_AirSeatMapRQSeatMapRequest $seatMapRequests = null)
    {
        $this->SeatMapRequests = $seatMapRequests;
        return $this;
    }
    /**
     * Get AirTravelers value
     * @return \dgsoft\ArrayType\DgArrayOfOTA_AirSeatMapRQAirTraveler|null
     */
    public function getAirTravelers()
    {
        return $this->AirTravelers;
    }
    /**
     * Set AirTravelers value
     * @param \dgsoft\ArrayType\DgArrayOfOTA_AirSeatMapRQAirTraveler $airTravelers
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setAirTravelers(\dgsoft\ArrayType\DgArrayOfOTA_AirSeatMapRQAirTraveler $airTravelers = null)
    {
        $this->AirTravelers = $airTravelers;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return \dgsoft\StructType\DgUniqueID_Type[]|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID_Type[] $bookingReferenceID
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setBookingReferenceID(array $bookingReferenceID = array())
    {
        foreach ($bookingReferenceID as $oTA_AirSeatMapRQBookingReferenceIDItem) {
            // validation for constraint: itemType
            if (!$oTA_AirSeatMapRQBookingReferenceIDItem instanceof \dgsoft\StructType\DgUniqueID_Type) {
                throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \dgsoft\StructType\DgUniqueID_Type, "%s" given', is_object($oTA_AirSeatMapRQBookingReferenceIDItem) ? get_class($oTA_AirSeatMapRQBookingReferenceIDItem) : gettype($oTA_AirSeatMapRQBookingReferenceIDItem)), __LINE__);
            }
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Add item to BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID_Type $item
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function addToBookingReferenceID(\dgsoft\StructType\DgUniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgUniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \dgsoft\StructType\DgUniqueID_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BookingReferenceID[] = $item;
        return $this;
    }
    /**
     * Get Culture value
     * @return string|null
     */
    public function getCulture()
    {
        return $this->Culture;
    }
    /**
     * Set Culture value
     * @param string $culture
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setCulture($culture = null)
    {
        // validation for constraint: string
        if (!is_null($culture) && !is_string($culture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($culture)), __LINE__);
        }
        $this->Culture = $culture;
        return $this;
    }
    /**
     * Get IsOneWayCombinable value
     * @return bool|null
     */
    public function getIsOneWayCombinable()
    {
        return $this->IsOneWayCombinable;
    }
    /**
     * Set IsOneWayCombinable value
     * @param bool $isOneWayCombinable
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setIsOneWayCombinable($isOneWayCombinable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOneWayCombinable) && !is_bool($isOneWayCombinable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isOneWayCombinable)), __LINE__);
        }
        $this->IsOneWayCombinable = $isOneWayCombinable;
        return $this;
    }
    /**
     * Get ItineraryID value
     * @return string|null
     */
    public function getItineraryID()
    {
        return $this->ItineraryID;
    }
    /**
     * Set ItineraryID value
     * @param string $itineraryID
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setItineraryID($itineraryID = null)
    {
        // validation for constraint: string
        if (!is_null($itineraryID) && !is_string($itineraryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itineraryID)), __LINE__);
        }
        $this->ItineraryID = $itineraryID;
        return $this;
    }
    /**
     * Get SegmentID value
     * @return string|null
     */
    public function getSegmentID()
    {
        return $this->SegmentID;
    }
    /**
     * Set SegmentID value
     * @param string $segmentID
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setSegmentID($segmentID = null)
    {
        // validation for constraint: string
        if (!is_null($segmentID) && !is_string($segmentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($segmentID)), __LINE__);
        }
        $this->SegmentID = $segmentID;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @uses \dgsoft\EnumType\DgOTA_AirSeatMapRQTarget::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_AirSeatMapRQTarget::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $target
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setTarget($target = 'Production')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_AirSeatMapRQTarget::valueIsValid($target)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $target, implode(', ', \dgsoft\EnumType\DgOTA_AirSeatMapRQTarget::getValidValues())), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @uses \dgsoft\EnumType\DgOTA_AirSeatMapRQTransactionStatusCode::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_AirSeatMapRQTransactionStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionStatusCode
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_AirSeatMapRQTransactionStatusCode::valueIsValid($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionStatusCode, implode(', ', \dgsoft\EnumType\DgOTA_AirSeatMapRQTransactionStatusCode::getValidValues())), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_AirSeatMapRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
