<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirScheduleRSOriginDestinationOptions StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_AirScheduleRSOriginDestinationOptions extends AbstractStructBase
{
    /**
     * The OriginDestinationOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOption[]
     */
    public $OriginDestinationOption;
    /**
     * The OriginCode
     * @var string
     */
    public $OriginCode;
    /**
     * The DestinationCode
     * @var string
     */
    public $DestinationCode;
    /**
     * Constructor method for OTA_AirScheduleRSOriginDestinationOptions
     * @uses DgOTA_AirScheduleRSOriginDestinationOptions::setOriginDestinationOption()
     * @uses DgOTA_AirScheduleRSOriginDestinationOptions::setOriginCode()
     * @uses DgOTA_AirScheduleRSOriginDestinationOptions::setDestinationCode()
     * @param \dgsoft\StructType\DgOTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOption[] $originDestinationOption
     * @param string $originCode
     * @param string $destinationCode
     */
    public function __construct(array $originDestinationOption = array(), $originCode = null, $destinationCode = null)
    {
        $this
            ->setOriginDestinationOption($originDestinationOption)
            ->setOriginCode($originCode)
            ->setDestinationCode($destinationCode);
    }
    /**
     * Get OriginDestinationOption value
     * @return \dgsoft\StructType\DgOTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOption[]|null
     */
    public function getOriginDestinationOption()
    {
        return $this->OriginDestinationOption;
    }
    /**
     * Set OriginDestinationOption value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOption[] $originDestinationOption
     * @return \dgsoft\StructType\DgOTA_AirScheduleRSOriginDestinationOptions
     */
    public function setOriginDestinationOption(array $originDestinationOption = array())
    {
        foreach ($originDestinationOption as $oTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOptionItem) {
            // validation for constraint: itemType
            if (!$oTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOptionItem instanceof \dgsoft\StructType\DgOTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOption) {
                throw new \InvalidArgumentException(sprintf('The OriginDestinationOption property can only contain items of \dgsoft\StructType\DgOTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOption, "%s" given', is_object($oTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOptionItem) ? get_class($oTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOptionItem) : gettype($oTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOptionItem)), __LINE__);
            }
        }
        $this->OriginDestinationOption = $originDestinationOption;
        return $this;
    }
    /**
     * Add item to OriginDestinationOption value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOption $item
     * @return \dgsoft\StructType\DgOTA_AirScheduleRSOriginDestinationOptions
     */
    public function addToOriginDestinationOption(\dgsoft\StructType\DgOTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgOTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOption) {
            throw new \InvalidArgumentException(sprintf('The OriginDestinationOption property can only contain items of \dgsoft\StructType\DgOTA_AirScheduleRSOriginDestinationOptionsOriginDestinationOption, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OriginDestinationOption[] = $item;
        return $this;
    }
    /**
     * Get OriginCode value
     * @return string|null
     */
    public function getOriginCode()
    {
        return $this->OriginCode;
    }
    /**
     * Set OriginCode value
     * @param string $originCode
     * @return \dgsoft\StructType\DgOTA_AirScheduleRSOriginDestinationOptions
     */
    public function setOriginCode($originCode = null)
    {
        // validation for constraint: string
        if (!is_null($originCode) && !is_string($originCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($originCode)), __LINE__);
        }
        $this->OriginCode = $originCode;
        return $this;
    }
    /**
     * Get DestinationCode value
     * @return string|null
     */
    public function getDestinationCode()
    {
        return $this->DestinationCode;
    }
    /**
     * Set DestinationCode value
     * @param string $destinationCode
     * @return \dgsoft\StructType\DgOTA_AirScheduleRSOriginDestinationOptions
     */
    public function setDestinationCode($destinationCode = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCode) && !is_string($destinationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationCode)), __LINE__);
        }
        $this->DestinationCode = $destinationCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_AirScheduleRSOriginDestinationOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
