<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirRulesRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_AirRulesRQ extends DgGenericFlightRQ
{
    /**
     * The MiniRuleEnabled
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $MiniRuleEnabled;
    /**
     * The PriceMessageEnabled
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PriceMessageEnabled;
    /**
     * The FlightRuleEnabled
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $FlightRuleEnabled;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Version;
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSourceType
     */
    public $POS;
    /**
     * The RuleReqInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_AirRulesRQRuleReqInfo
     */
    public $RuleReqInfo;
    /**
     * The PassengerType
     * @var string
     */
    public $PassengerType;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - default: Production
     * @var string
     */
    public $Target;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * Constructor method for OTA_AirRulesRQ
     * @uses DgOTA_AirRulesRQ::setMiniRuleEnabled()
     * @uses DgOTA_AirRulesRQ::setPriceMessageEnabled()
     * @uses DgOTA_AirRulesRQ::setFlightRuleEnabled()
     * @uses DgOTA_AirRulesRQ::setVersion()
     * @uses DgOTA_AirRulesRQ::setPOS()
     * @uses DgOTA_AirRulesRQ::setRuleReqInfo()
     * @uses DgOTA_AirRulesRQ::setPassengerType()
     * @uses DgOTA_AirRulesRQ::setEchoToken()
     * @uses DgOTA_AirRulesRQ::setTimeStamp()
     * @uses DgOTA_AirRulesRQ::setTarget()
     * @uses DgOTA_AirRulesRQ::setTransactionIdentifier()
     * @uses DgOTA_AirRulesRQ::setSequenceNmbr()
     * @uses DgOTA_AirRulesRQ::setTransactionStatusCode()
     * @uses DgOTA_AirRulesRQ::setRetransmissionIndicator()
     * @param int $miniRuleEnabled
     * @param int $priceMessageEnabled
     * @param int $flightRuleEnabled
     * @param float $version
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @param \dgsoft\StructType\DgOTA_AirRulesRQRuleReqInfo $ruleReqInfo
     * @param string $passengerType
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     */
    public function __construct($miniRuleEnabled = null, $priceMessageEnabled = null, $flightRuleEnabled = null, $version = null, \dgsoft\ArrayType\DgArrayOfSourceType $pOS = null, \dgsoft\StructType\DgOTA_AirRulesRQRuleReqInfo $ruleReqInfo = null, $passengerType = null, $echoToken = null, $timeStamp = null, $target = 'Production', $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null)
    {
        $this
            ->setMiniRuleEnabled($miniRuleEnabled)
            ->setPriceMessageEnabled($priceMessageEnabled)
            ->setFlightRuleEnabled($flightRuleEnabled)
            ->setVersion($version)
            ->setPOS($pOS)
            ->setRuleReqInfo($ruleReqInfo)
            ->setPassengerType($passengerType)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator);
    }
    /**
     * Get MiniRuleEnabled value
     * @return int
     */
    public function getMiniRuleEnabled()
    {
        return $this->MiniRuleEnabled;
    }
    /**
     * Set MiniRuleEnabled value
     * @param int $miniRuleEnabled
     * @return \dgsoft\StructType\DgOTA_AirRulesRQ
     */
    public function setMiniRuleEnabled($miniRuleEnabled = null)
    {
        // validation for constraint: int
        if (!is_null($miniRuleEnabled) && !is_numeric($miniRuleEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($miniRuleEnabled)), __LINE__);
        }
        $this->MiniRuleEnabled = $miniRuleEnabled;
        return $this;
    }
    /**
     * Get PriceMessageEnabled value
     * @return int
     */
    public function getPriceMessageEnabled()
    {
        return $this->PriceMessageEnabled;
    }
    /**
     * Set PriceMessageEnabled value
     * @param int $priceMessageEnabled
     * @return \dgsoft\StructType\DgOTA_AirRulesRQ
     */
    public function setPriceMessageEnabled($priceMessageEnabled = null)
    {
        // validation for constraint: int
        if (!is_null($priceMessageEnabled) && !is_numeric($priceMessageEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($priceMessageEnabled)), __LINE__);
        }
        $this->PriceMessageEnabled = $priceMessageEnabled;
        return $this;
    }
    /**
     * Get FlightRuleEnabled value
     * @return int
     */
    public function getFlightRuleEnabled()
    {
        return $this->FlightRuleEnabled;
    }
    /**
     * Set FlightRuleEnabled value
     * @param int $flightRuleEnabled
     * @return \dgsoft\StructType\DgOTA_AirRulesRQ
     */
    public function setFlightRuleEnabled($flightRuleEnabled = null)
    {
        // validation for constraint: int
        if (!is_null($flightRuleEnabled) && !is_numeric($flightRuleEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($flightRuleEnabled)), __LINE__);
        }
        $this->FlightRuleEnabled = $flightRuleEnabled;
        return $this;
    }
    /**
     * Get Version value
     * @return float
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \dgsoft\StructType\DgOTA_AirRulesRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get POS value
     * @return \dgsoft\ArrayType\DgArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @return \dgsoft\StructType\DgOTA_AirRulesRQ
     */
    public function setPOS(\dgsoft\ArrayType\DgArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get RuleReqInfo value
     * @return \dgsoft\StructType\DgOTA_AirRulesRQRuleReqInfo|null
     */
    public function getRuleReqInfo()
    {
        return $this->RuleReqInfo;
    }
    /**
     * Set RuleReqInfo value
     * @param \dgsoft\StructType\DgOTA_AirRulesRQRuleReqInfo $ruleReqInfo
     * @return \dgsoft\StructType\DgOTA_AirRulesRQ
     */
    public function setRuleReqInfo(\dgsoft\StructType\DgOTA_AirRulesRQRuleReqInfo $ruleReqInfo = null)
    {
        $this->RuleReqInfo = $ruleReqInfo;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return string|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @param string $passengerType
     * @return \dgsoft\StructType\DgOTA_AirRulesRQ
     */
    public function setPassengerType($passengerType = null)
    {
        // validation for constraint: string
        if (!is_null($passengerType) && !is_string($passengerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passengerType)), __LINE__);
        }
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \dgsoft\StructType\DgOTA_AirRulesRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \dgsoft\StructType\DgOTA_AirRulesRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @uses \dgsoft\EnumType\DgOTA_AirRulesRQTarget::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_AirRulesRQTarget::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $target
     * @return \dgsoft\StructType\DgOTA_AirRulesRQ
     */
    public function setTarget($target = 'Production')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_AirRulesRQTarget::valueIsValid($target)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $target, implode(', ', \dgsoft\EnumType\DgOTA_AirRulesRQTarget::getValidValues())), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \dgsoft\StructType\DgOTA_AirRulesRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \dgsoft\StructType\DgOTA_AirRulesRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @uses \dgsoft\EnumType\DgOTA_AirRulesRQTransactionStatusCode::valueIsValid()
     * @uses \dgsoft\EnumType\DgOTA_AirRulesRQTransactionStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionStatusCode
     * @return \dgsoft\StructType\DgOTA_AirRulesRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOTA_AirRulesRQTransactionStatusCode::valueIsValid($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transactionStatusCode, implode(', ', \dgsoft\EnumType\DgOTA_AirRulesRQTransactionStatusCode::getValidValues())), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \dgsoft\StructType\DgOTA_AirRulesRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_AirRulesRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
