<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_AirLowFareSearchRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOTA_AirLowFareSearchRQ extends AbstractStructBase
{
    /**
     * The RefundableType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $RefundableType;
    /**
     * The MaxPrice
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $MaxPrice;
    /**
     * The ProviderType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ProviderType;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Version;
    /**
     * The ForMetaBook
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $ForMetaBook;
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSourceType
     */
    public $POS;
    /**
     * The ProcessingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgProcessingInfo
     */
    public $ProcessingInfo;
    /**
     * The OriginDestinationInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOriginDestinationInformation[]
     */
    public $OriginDestinationInformation;
    /**
     * The SpecificFlightInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSpecificFlightInfoType
     */
    public $SpecificFlightInfo;
    /**
     * The TravelPreferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTravelPreferences[]
     */
    public $TravelPreferences;
    /**
     * The TravelerInfoSummary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTravelerInfoSummary
     */
    public $TravelerInfoSummary;
    /**
     * The AdvanceSearchInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAdvanceSearchInfo
     */
    public $AdvanceSearchInfo;
    /**
     * The MetaLink
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MetaLink;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * Meta informations extracted from the WSDL
     * - default: Production
     * @var string
     */
    public $Target;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The MaxResponses
     * @var int
     */
    public $MaxResponses;
    /**
     * The DirectFlightsOnly
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $DirectFlightsOnly;
    /**
     * The AvailableFlightsOnly
     * @var bool
     */
    public $AvailableFlightsOnly;
    /**
     * Constructor method for OTA_AirLowFareSearchRQ
     * @uses DgOTA_AirLowFareSearchRQ::setRefundableType()
     * @uses DgOTA_AirLowFareSearchRQ::setMaxPrice()
     * @uses DgOTA_AirLowFareSearchRQ::setProviderType()
     * @uses DgOTA_AirLowFareSearchRQ::setVersion()
     * @uses DgOTA_AirLowFareSearchRQ::setForMetaBook()
     * @uses DgOTA_AirLowFareSearchRQ::setPOS()
     * @uses DgOTA_AirLowFareSearchRQ::setProcessingInfo()
     * @uses DgOTA_AirLowFareSearchRQ::setOriginDestinationInformation()
     * @uses DgOTA_AirLowFareSearchRQ::setSpecificFlightInfo()
     * @uses DgOTA_AirLowFareSearchRQ::setTravelPreferences()
     * @uses DgOTA_AirLowFareSearchRQ::setTravelerInfoSummary()
     * @uses DgOTA_AirLowFareSearchRQ::setAdvanceSearchInfo()
     * @uses DgOTA_AirLowFareSearchRQ::setMetaLink()
     * @uses DgOTA_AirLowFareSearchRQ::setEchoToken()
     * @uses DgOTA_AirLowFareSearchRQ::setTimeStamp()
     * @uses DgOTA_AirLowFareSearchRQ::setTarget()
     * @uses DgOTA_AirLowFareSearchRQ::setTransactionIdentifier()
     * @uses DgOTA_AirLowFareSearchRQ::setSequenceNmbr()
     * @uses DgOTA_AirLowFareSearchRQ::setTransactionStatusCode()
     * @uses DgOTA_AirLowFareSearchRQ::setRetransmissionIndicator()
     * @uses DgOTA_AirLowFareSearchRQ::setMaxResponses()
     * @uses DgOTA_AirLowFareSearchRQ::setDirectFlightsOnly()
     * @uses DgOTA_AirLowFareSearchRQ::setAvailableFlightsOnly()
     * @param string $refundableType
     * @param float $maxPrice
     * @param string $providerType
     * @param float $version
     * @param bool $forMetaBook
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @param \dgsoft\StructType\DgProcessingInfo $processingInfo
     * @param \dgsoft\StructType\DgOriginDestinationInformation[] $originDestinationInformation
     * @param \dgsoft\StructType\DgSpecificFlightInfoType $specificFlightInfo
     * @param \dgsoft\StructType\DgTravelPreferences[] $travelPreferences
     * @param \dgsoft\StructType\DgTravelerInfoSummary $travelerInfoSummary
     * @param \dgsoft\StructType\DgAdvanceSearchInfo $advanceSearchInfo
     * @param string $metaLink
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param int $maxResponses
     * @param bool $directFlightsOnly
     * @param bool $availableFlightsOnly
     */
    public function __construct($refundableType = null, $maxPrice = null, $providerType = null, $version = null, $forMetaBook = null, \dgsoft\ArrayType\DgArrayOfSourceType $pOS = null, \dgsoft\StructType\DgProcessingInfo $processingInfo = null, array $originDestinationInformation = array(), \dgsoft\StructType\DgSpecificFlightInfoType $specificFlightInfo = null, array $travelPreferences = array(), \dgsoft\StructType\DgTravelerInfoSummary $travelerInfoSummary = null, \dgsoft\StructType\DgAdvanceSearchInfo $advanceSearchInfo = null, $metaLink = null, $echoToken = null, $timeStamp = null, $target = 'Production', $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $maxResponses = null, $directFlightsOnly = false, $availableFlightsOnly = null)
    {
        $this
            ->setRefundableType($refundableType)
            ->setMaxPrice($maxPrice)
            ->setProviderType($providerType)
            ->setVersion($version)
            ->setForMetaBook($forMetaBook)
            ->setPOS($pOS)
            ->setProcessingInfo($processingInfo)
            ->setOriginDestinationInformation($originDestinationInformation)
            ->setSpecificFlightInfo($specificFlightInfo)
            ->setTravelPreferences($travelPreferences)
            ->setTravelerInfoSummary($travelerInfoSummary)
            ->setAdvanceSearchInfo($advanceSearchInfo)
            ->setMetaLink($metaLink)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setMaxResponses($maxResponses)
            ->setDirectFlightsOnly($directFlightsOnly)
            ->setAvailableFlightsOnly($availableFlightsOnly);
    }
    /**
     * Get RefundableType value
     * @return string
     */
    public function getRefundableType()
    {
        return $this->RefundableType;
    }
    /**
     * Set RefundableType value
     * @uses \dgsoft\EnumType\DgRefundableTypesEnum::valueIsValid()
     * @uses \dgsoft\EnumType\DgRefundableTypesEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $refundableType
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setRefundableType($refundableType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgRefundableTypesEnum::valueIsValid($refundableType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $refundableType, implode(', ', \dgsoft\EnumType\DgRefundableTypesEnum::getValidValues())), __LINE__);
        }
        $this->RefundableType = $refundableType;
        return $this;
    }
    /**
     * Get MaxPrice value
     * @return float
     */
    public function getMaxPrice()
    {
        return $this->MaxPrice;
    }
    /**
     * Set MaxPrice value
     * @param float $maxPrice
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setMaxPrice($maxPrice = null)
    {
        $this->MaxPrice = $maxPrice;
        return $this;
    }
    /**
     * Get ProviderType value
     * @return string
     */
    public function getProviderType()
    {
        return $this->ProviderType;
    }
    /**
     * Set ProviderType value
     * @uses \dgsoft\EnumType\DgSearchTypeByProviderEnum::valueIsValid()
     * @uses \dgsoft\EnumType\DgSearchTypeByProviderEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $providerType
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setProviderType($providerType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgSearchTypeByProviderEnum::valueIsValid($providerType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $providerType, implode(', ', \dgsoft\EnumType\DgSearchTypeByProviderEnum::getValidValues())), __LINE__);
        }
        $this->ProviderType = $providerType;
        return $this;
    }
    /**
     * Get Version value
     * @return float
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param float $version
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get ForMetaBook value
     * @return bool
     */
    public function getForMetaBook()
    {
        return $this->ForMetaBook;
    }
    /**
     * Set ForMetaBook value
     * @param bool $forMetaBook
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setForMetaBook($forMetaBook = null)
    {
        // validation for constraint: boolean
        if (!is_null($forMetaBook) && !is_bool($forMetaBook)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($forMetaBook)), __LINE__);
        }
        $this->ForMetaBook = $forMetaBook;
        return $this;
    }
    /**
     * Get POS value
     * @return \dgsoft\ArrayType\DgArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setPOS(\dgsoft\ArrayType\DgArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get ProcessingInfo value
     * @return \dgsoft\StructType\DgProcessingInfo|null
     */
    public function getProcessingInfo()
    {
        return $this->ProcessingInfo;
    }
    /**
     * Set ProcessingInfo value
     * @param \dgsoft\StructType\DgProcessingInfo $processingInfo
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setProcessingInfo(\dgsoft\StructType\DgProcessingInfo $processingInfo = null)
    {
        $this->ProcessingInfo = $processingInfo;
        return $this;
    }
    /**
     * Get OriginDestinationInformation value
     * @return \dgsoft\StructType\DgOriginDestinationInformation[]|null
     */
    public function getOriginDestinationInformation()
    {
        return $this->OriginDestinationInformation;
    }
    /**
     * Set OriginDestinationInformation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOriginDestinationInformation[] $originDestinationInformation
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setOriginDestinationInformation(array $originDestinationInformation = array())
    {
        foreach ($originDestinationInformation as $oTA_AirLowFareSearchRQOriginDestinationInformationItem) {
            // validation for constraint: itemType
            if (!$oTA_AirLowFareSearchRQOriginDestinationInformationItem instanceof \dgsoft\StructType\DgOriginDestinationInformation) {
                throw new \InvalidArgumentException(sprintf('The OriginDestinationInformation property can only contain items of \dgsoft\StructType\DgOriginDestinationInformation, "%s" given', is_object($oTA_AirLowFareSearchRQOriginDestinationInformationItem) ? get_class($oTA_AirLowFareSearchRQOriginDestinationInformationItem) : gettype($oTA_AirLowFareSearchRQOriginDestinationInformationItem)), __LINE__);
            }
        }
        $this->OriginDestinationInformation = $originDestinationInformation;
        return $this;
    }
    /**
     * Add item to OriginDestinationInformation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgOriginDestinationInformation $item
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function addToOriginDestinationInformation(\dgsoft\StructType\DgOriginDestinationInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgOriginDestinationInformation) {
            throw new \InvalidArgumentException(sprintf('The OriginDestinationInformation property can only contain items of \dgsoft\StructType\DgOriginDestinationInformation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OriginDestinationInformation[] = $item;
        return $this;
    }
    /**
     * Get SpecificFlightInfo value
     * @return \dgsoft\StructType\DgSpecificFlightInfoType|null
     */
    public function getSpecificFlightInfo()
    {
        return $this->SpecificFlightInfo;
    }
    /**
     * Set SpecificFlightInfo value
     * @param \dgsoft\StructType\DgSpecificFlightInfoType $specificFlightInfo
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setSpecificFlightInfo(\dgsoft\StructType\DgSpecificFlightInfoType $specificFlightInfo = null)
    {
        $this->SpecificFlightInfo = $specificFlightInfo;
        return $this;
    }
    /**
     * Get TravelPreferences value
     * @return \dgsoft\StructType\DgTravelPreferences[]|null
     */
    public function getTravelPreferences()
    {
        return $this->TravelPreferences;
    }
    /**
     * Set TravelPreferences value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelPreferences[] $travelPreferences
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setTravelPreferences(array $travelPreferences = array())
    {
        foreach ($travelPreferences as $oTA_AirLowFareSearchRQTravelPreferencesItem) {
            // validation for constraint: itemType
            if (!$oTA_AirLowFareSearchRQTravelPreferencesItem instanceof \dgsoft\StructType\DgTravelPreferences) {
                throw new \InvalidArgumentException(sprintf('The TravelPreferences property can only contain items of \dgsoft\StructType\DgTravelPreferences, "%s" given', is_object($oTA_AirLowFareSearchRQTravelPreferencesItem) ? get_class($oTA_AirLowFareSearchRQTravelPreferencesItem) : gettype($oTA_AirLowFareSearchRQTravelPreferencesItem)), __LINE__);
            }
        }
        $this->TravelPreferences = $travelPreferences;
        return $this;
    }
    /**
     * Add item to TravelPreferences value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelPreferences $item
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function addToTravelPreferences(\dgsoft\StructType\DgTravelPreferences $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTravelPreferences) {
            throw new \InvalidArgumentException(sprintf('The TravelPreferences property can only contain items of \dgsoft\StructType\DgTravelPreferences, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelPreferences[] = $item;
        return $this;
    }
    /**
     * Get TravelerInfoSummary value
     * @return \dgsoft\StructType\DgTravelerInfoSummary|null
     */
    public function getTravelerInfoSummary()
    {
        return $this->TravelerInfoSummary;
    }
    /**
     * Set TravelerInfoSummary value
     * @param \dgsoft\StructType\DgTravelerInfoSummary $travelerInfoSummary
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setTravelerInfoSummary(\dgsoft\StructType\DgTravelerInfoSummary $travelerInfoSummary = null)
    {
        $this->TravelerInfoSummary = $travelerInfoSummary;
        return $this;
    }
    /**
     * Get AdvanceSearchInfo value
     * @return \dgsoft\StructType\DgAdvanceSearchInfo|null
     */
    public function getAdvanceSearchInfo()
    {
        return $this->AdvanceSearchInfo;
    }
    /**
     * Set AdvanceSearchInfo value
     * @param \dgsoft\StructType\DgAdvanceSearchInfo $advanceSearchInfo
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setAdvanceSearchInfo(\dgsoft\StructType\DgAdvanceSearchInfo $advanceSearchInfo = null)
    {
        $this->AdvanceSearchInfo = $advanceSearchInfo;
        return $this;
    }
    /**
     * Get MetaLink value
     * @return string|null
     */
    public function getMetaLink()
    {
        return $this->MetaLink;
    }
    /**
     * Set MetaLink value
     * @param string $metaLink
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setMetaLink($metaLink = null)
    {
        // validation for constraint: string
        if (!is_null($metaLink) && !is_string($metaLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($metaLink)), __LINE__);
        }
        $this->MetaLink = $metaLink;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setEchoToken($echoToken = null)
    {
        // validation for constraint: string
        if (!is_null($echoToken) && !is_string($echoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($echoToken)), __LINE__);
        }
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setTarget($target = 'Production')
    {
        // validation for constraint: string
        if (!is_null($target) && !is_string($target)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($target)), __LINE__);
        }
        $this->Target = $target;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($transactionIdentifier) && !is_string($transactionIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionIdentifier)), __LINE__);
        }
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        // validation for constraint: int
        if (!is_null($sequenceNmbr) && !is_numeric($sequenceNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequenceNmbr)), __LINE__);
        }
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($transactionStatusCode) && !is_string($transactionStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionStatusCode)), __LINE__);
        }
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get MaxResponses value
     * @return int|null
     */
    public function getMaxResponses()
    {
        return $this->MaxResponses;
    }
    /**
     * Set MaxResponses value
     * @param int $maxResponses
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setMaxResponses($maxResponses = null)
    {
        // validation for constraint: int
        if (!is_null($maxResponses) && !is_numeric($maxResponses)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxResponses)), __LINE__);
        }
        $this->MaxResponses = $maxResponses;
        return $this;
    }
    /**
     * Get DirectFlightsOnly value
     * @return bool|null
     */
    public function getDirectFlightsOnly()
    {
        return $this->DirectFlightsOnly;
    }
    /**
     * Set DirectFlightsOnly value
     * @param bool $directFlightsOnly
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setDirectFlightsOnly($directFlightsOnly = false)
    {
        // validation for constraint: boolean
        if (!is_null($directFlightsOnly) && !is_bool($directFlightsOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($directFlightsOnly)), __LINE__);
        }
        $this->DirectFlightsOnly = $directFlightsOnly;
        return $this;
    }
    /**
     * Get AvailableFlightsOnly value
     * @return bool|null
     */
    public function getAvailableFlightsOnly()
    {
        return $this->AvailableFlightsOnly;
    }
    /**
     * Set AvailableFlightsOnly value
     * @param bool $availableFlightsOnly
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public function setAvailableFlightsOnly($availableFlightsOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableFlightsOnly) && !is_bool($availableFlightsOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableFlightsOnly)), __LINE__);
        }
        $this->AvailableFlightsOnly = $availableFlightsOnly;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOTA_AirLowFareSearchRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
