<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OSIelement StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOSIelement extends AbstractStructBase
{
    /**
     * The NumberOfAssociatedPassenger
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NumberOfAssociatedPassenger;
    /**
     * The LineNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LineNumber;
    /**
     * The AirlineID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AirlineID;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The SubjectQualifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubjectQualifier;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The NumberOfAssociatedSegments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumberOfAssociatedSegments;
    /**
     * Constructor method for OSIelement
     * @uses DgOSIelement::setNumberOfAssociatedPassenger()
     * @uses DgOSIelement::setLineNumber()
     * @uses DgOSIelement::setAirlineID()
     * @uses DgOSIelement::setText()
     * @uses DgOSIelement::setSubjectQualifier()
     * @uses DgOSIelement::setType()
     * @uses DgOSIelement::setNumberOfAssociatedSegments()
     * @param int $numberOfAssociatedPassenger
     * @param int $lineNumber
     * @param string $airlineID
     * @param string $text
     * @param string $subjectQualifier
     * @param string $type
     * @param string $numberOfAssociatedSegments
     */
    public function __construct($numberOfAssociatedPassenger = null, $lineNumber = null, $airlineID = null, $text = null, $subjectQualifier = null, $type = null, $numberOfAssociatedSegments = null)
    {
        $this
            ->setNumberOfAssociatedPassenger($numberOfAssociatedPassenger)
            ->setLineNumber($lineNumber)
            ->setAirlineID($airlineID)
            ->setText($text)
            ->setSubjectQualifier($subjectQualifier)
            ->setType($type)
            ->setNumberOfAssociatedSegments($numberOfAssociatedSegments);
    }
    /**
     * Get NumberOfAssociatedPassenger value
     * @return int
     */
    public function getNumberOfAssociatedPassenger()
    {
        return $this->NumberOfAssociatedPassenger;
    }
    /**
     * Set NumberOfAssociatedPassenger value
     * @param int $numberOfAssociatedPassenger
     * @return \dgsoft\StructType\DgOSIelement
     */
    public function setNumberOfAssociatedPassenger($numberOfAssociatedPassenger = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfAssociatedPassenger) && !is_numeric($numberOfAssociatedPassenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfAssociatedPassenger)), __LINE__);
        }
        $this->NumberOfAssociatedPassenger = $numberOfAssociatedPassenger;
        return $this;
    }
    /**
     * Get LineNumber value
     * @return int
     */
    public function getLineNumber()
    {
        return $this->LineNumber;
    }
    /**
     * Set LineNumber value
     * @param int $lineNumber
     * @return \dgsoft\StructType\DgOSIelement
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lineNumber) && !is_numeric($lineNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lineNumber)), __LINE__);
        }
        $this->LineNumber = $lineNumber;
        return $this;
    }
    /**
     * Get AirlineID value
     * @return string|null
     */
    public function getAirlineID()
    {
        return $this->AirlineID;
    }
    /**
     * Set AirlineID value
     * @param string $airlineID
     * @return \dgsoft\StructType\DgOSIelement
     */
    public function setAirlineID($airlineID = null)
    {
        // validation for constraint: string
        if (!is_null($airlineID) && !is_string($airlineID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airlineID)), __LINE__);
        }
        $this->AirlineID = $airlineID;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \dgsoft\StructType\DgOSIelement
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get SubjectQualifier value
     * @return string|null
     */
    public function getSubjectQualifier()
    {
        return $this->SubjectQualifier;
    }
    /**
     * Set SubjectQualifier value
     * @param string $subjectQualifier
     * @return \dgsoft\StructType\DgOSIelement
     */
    public function setSubjectQualifier($subjectQualifier = null)
    {
        // validation for constraint: string
        if (!is_null($subjectQualifier) && !is_string($subjectQualifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subjectQualifier)), __LINE__);
        }
        $this->SubjectQualifier = $subjectQualifier;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \dgsoft\StructType\DgOSIelement
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get NumberOfAssociatedSegments value
     * @return string|null
     */
    public function getNumberOfAssociatedSegments()
    {
        return $this->NumberOfAssociatedSegments;
    }
    /**
     * Set NumberOfAssociatedSegments value
     * @param string $numberOfAssociatedSegments
     * @return \dgsoft\StructType\DgOSIelement
     */
    public function setNumberOfAssociatedSegments($numberOfAssociatedSegments = null)
    {
        // validation for constraint: string
        if (!is_null($numberOfAssociatedSegments) && !is_string($numberOfAssociatedSegments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberOfAssociatedSegments)), __LINE__);
        }
        $this->NumberOfAssociatedSegments = $numberOfAssociatedSegments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOSIelement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
