<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OPSProfile StructType
 * @package Dg
 * @subpackage Structs
 */
class DgOPSProfile extends AbstractStructBase
{
    /**
     * The CreatedIntegrationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CreatedIntegrationDate;
    /**
     * The ReadIntegrationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ReadIntegrationDate;
    /**
     * The UpdateIntegrationDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $UpdateIntegrationDate;
    /**
     * The ChangedPersonel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ChangedPersonel;
    /**
     * The ChangedContactInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ChangedContactInfo;
    /**
     * The NGP_ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NGP_ID;
    /**
     * The CSX_ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CSX_ID;
    /**
     * Constructor method for OPSProfile
     * @uses DgOPSProfile::setCreatedIntegrationDate()
     * @uses DgOPSProfile::setReadIntegrationDate()
     * @uses DgOPSProfile::setUpdateIntegrationDate()
     * @uses DgOPSProfile::setChangedPersonel()
     * @uses DgOPSProfile::setChangedContactInfo()
     * @uses DgOPSProfile::setNGP_ID()
     * @uses DgOPSProfile::setCSX_ID()
     * @param string $createdIntegrationDate
     * @param string $readIntegrationDate
     * @param string $updateIntegrationDate
     * @param bool $changedPersonel
     * @param bool $changedContactInfo
     * @param string $nGP_ID
     * @param string $cSX_ID
     */
    public function __construct($createdIntegrationDate = null, $readIntegrationDate = null, $updateIntegrationDate = null, $changedPersonel = null, $changedContactInfo = null, $nGP_ID = null, $cSX_ID = null)
    {
        $this
            ->setCreatedIntegrationDate($createdIntegrationDate)
            ->setReadIntegrationDate($readIntegrationDate)
            ->setUpdateIntegrationDate($updateIntegrationDate)
            ->setChangedPersonel($changedPersonel)
            ->setChangedContactInfo($changedContactInfo)
            ->setNGP_ID($nGP_ID)
            ->setCSX_ID($cSX_ID);
    }
    /**
     * Get CreatedIntegrationDate value
     * @return string
     */
    public function getCreatedIntegrationDate()
    {
        return $this->CreatedIntegrationDate;
    }
    /**
     * Set CreatedIntegrationDate value
     * @param string $createdIntegrationDate
     * @return \dgsoft\StructType\DgOPSProfile
     */
    public function setCreatedIntegrationDate($createdIntegrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdIntegrationDate) && !is_string($createdIntegrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdIntegrationDate)), __LINE__);
        }
        $this->CreatedIntegrationDate = $createdIntegrationDate;
        return $this;
    }
    /**
     * Get ReadIntegrationDate value
     * @return string
     */
    public function getReadIntegrationDate()
    {
        return $this->ReadIntegrationDate;
    }
    /**
     * Set ReadIntegrationDate value
     * @param string $readIntegrationDate
     * @return \dgsoft\StructType\DgOPSProfile
     */
    public function setReadIntegrationDate($readIntegrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($readIntegrationDate) && !is_string($readIntegrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readIntegrationDate)), __LINE__);
        }
        $this->ReadIntegrationDate = $readIntegrationDate;
        return $this;
    }
    /**
     * Get UpdateIntegrationDate value
     * @return string
     */
    public function getUpdateIntegrationDate()
    {
        return $this->UpdateIntegrationDate;
    }
    /**
     * Set UpdateIntegrationDate value
     * @param string $updateIntegrationDate
     * @return \dgsoft\StructType\DgOPSProfile
     */
    public function setUpdateIntegrationDate($updateIntegrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($updateIntegrationDate) && !is_string($updateIntegrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateIntegrationDate)), __LINE__);
        }
        $this->UpdateIntegrationDate = $updateIntegrationDate;
        return $this;
    }
    /**
     * Get ChangedPersonel value
     * @return bool
     */
    public function getChangedPersonel()
    {
        return $this->ChangedPersonel;
    }
    /**
     * Set ChangedPersonel value
     * @param bool $changedPersonel
     * @return \dgsoft\StructType\DgOPSProfile
     */
    public function setChangedPersonel($changedPersonel = null)
    {
        // validation for constraint: boolean
        if (!is_null($changedPersonel) && !is_bool($changedPersonel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($changedPersonel)), __LINE__);
        }
        $this->ChangedPersonel = $changedPersonel;
        return $this;
    }
    /**
     * Get ChangedContactInfo value
     * @return bool
     */
    public function getChangedContactInfo()
    {
        return $this->ChangedContactInfo;
    }
    /**
     * Set ChangedContactInfo value
     * @param bool $changedContactInfo
     * @return \dgsoft\StructType\DgOPSProfile
     */
    public function setChangedContactInfo($changedContactInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($changedContactInfo) && !is_bool($changedContactInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($changedContactInfo)), __LINE__);
        }
        $this->ChangedContactInfo = $changedContactInfo;
        return $this;
    }
    /**
     * Get NGP_ID value
     * @return string|null
     */
    public function getNGP_ID()
    {
        return $this->NGP_ID;
    }
    /**
     * Set NGP_ID value
     * @param string $nGP_ID
     * @return \dgsoft\StructType\DgOPSProfile
     */
    public function setNGP_ID($nGP_ID = null)
    {
        // validation for constraint: string
        if (!is_null($nGP_ID) && !is_string($nGP_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nGP_ID)), __LINE__);
        }
        $this->NGP_ID = $nGP_ID;
        return $this;
    }
    /**
     * Get CSX_ID value
     * @return string|null
     */
    public function getCSX_ID()
    {
        return $this->CSX_ID;
    }
    /**
     * Set CSX_ID value
     * @param string $cSX_ID
     * @return \dgsoft\StructType\DgOPSProfile
     */
    public function setCSX_ID($cSX_ID = null)
    {
        // validation for constraint: string
        if (!is_null($cSX_ID) && !is_string($cSX_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cSX_ID)), __LINE__);
        }
        $this->CSX_ID = $cSX_ID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgOPSProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
