<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NamePrefType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgNamePrefType extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID_Type
     */
    public $UniqueID;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPersonNameType
     */
    public $PersonName;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for NamePrefType
     * @uses DgNamePrefType::setUniqueID()
     * @uses DgNamePrefType::setPersonName()
     * @uses DgNamePrefType::setPreferLevel()
     * @param \dgsoft\StructType\DgUniqueID_Type $uniqueID
     * @param \dgsoft\StructType\DgPersonNameType $personName
     * @param string $preferLevel
     */
    public function __construct(\dgsoft\StructType\DgUniqueID_Type $uniqueID = null, \dgsoft\StructType\DgPersonNameType $personName = null, $preferLevel = 'Preferred')
    {
        $this
            ->setUniqueID($uniqueID)
            ->setPersonName($personName)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get UniqueID value
     * @return \dgsoft\StructType\DgUniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \dgsoft\StructType\DgUniqueID_Type $uniqueID
     * @return \dgsoft\StructType\DgNamePrefType
     */
    public function setUniqueID(\dgsoft\StructType\DgUniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \dgsoft\StructType\DgPersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \dgsoft\StructType\DgPersonNameType $personName
     * @return \dgsoft\StructType\DgNamePrefType
     */
    public function setPersonName(\dgsoft\StructType\DgPersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \dgsoft\EnumType\DgPreferLevelType::valueIsValid()
     * @uses \dgsoft\EnumType\DgPreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \dgsoft\StructType\DgNamePrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgPreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferLevel, implode(', ', \dgsoft\EnumType\DgPreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgNamePrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
