<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Membership StructType
 * @package Dg
 * @subpackage Structs
 */
class DgMembership extends AbstractStructBase
{
    /**
     * The ProgramCode
     * @var string
     */
    public $ProgramCode;
    /**
     * The BonusCode
     * @var string
     */
    public $BonusCode;
    /**
     * The AccountID
     * @var string
     */
    public $AccountID;
    /**
     * The PointsEarned
     * @var int
     */
    public $PointsEarned;
    /**
     * The TravelSector
     * @var string
     */
    public $TravelSector;
    /**
     * The ProgramID
     * @var string
     */
    public $ProgramID;
    /**
     * The MembershipID
     * @var string
     */
    public $MembershipID;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The VendorCode
     * @var string[]
     */
    public $VendorCode;
    /**
     * Constructor method for Membership
     * @uses DgMembership::setProgramCode()
     * @uses DgMembership::setBonusCode()
     * @uses DgMembership::setAccountID()
     * @uses DgMembership::setPointsEarned()
     * @uses DgMembership::setTravelSector()
     * @uses DgMembership::setProgramID()
     * @uses DgMembership::setMembershipID()
     * @uses DgMembership::setRPH()
     * @uses DgMembership::setVendorCode()
     * @param string $programCode
     * @param string $bonusCode
     * @param string $accountID
     * @param int $pointsEarned
     * @param string $travelSector
     * @param string $programID
     * @param string $membershipID
     * @param string $rPH
     * @param string[] $vendorCode
     */
    public function __construct($programCode = null, $bonusCode = null, $accountID = null, $pointsEarned = null, $travelSector = null, $programID = null, $membershipID = null, $rPH = null, array $vendorCode = array())
    {
        $this
            ->setProgramCode($programCode)
            ->setBonusCode($bonusCode)
            ->setAccountID($accountID)
            ->setPointsEarned($pointsEarned)
            ->setTravelSector($travelSector)
            ->setProgramID($programID)
            ->setMembershipID($membershipID)
            ->setRPH($rPH)
            ->setVendorCode($vendorCode);
    }
    /**
     * Get ProgramCode value
     * @return string|null
     */
    public function getProgramCode()
    {
        return $this->ProgramCode;
    }
    /**
     * Set ProgramCode value
     * @param string $programCode
     * @return \dgsoft\StructType\DgMembership
     */
    public function setProgramCode($programCode = null)
    {
        // validation for constraint: string
        if (!is_null($programCode) && !is_string($programCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($programCode)), __LINE__);
        }
        $this->ProgramCode = $programCode;
        return $this;
    }
    /**
     * Get BonusCode value
     * @return string|null
     */
    public function getBonusCode()
    {
        return $this->BonusCode;
    }
    /**
     * Set BonusCode value
     * @param string $bonusCode
     * @return \dgsoft\StructType\DgMembership
     */
    public function setBonusCode($bonusCode = null)
    {
        // validation for constraint: string
        if (!is_null($bonusCode) && !is_string($bonusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bonusCode)), __LINE__);
        }
        $this->BonusCode = $bonusCode;
        return $this;
    }
    /**
     * Get AccountID value
     * @return string|null
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param string $accountID
     * @return \dgsoft\StructType\DgMembership
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: string
        if (!is_null($accountID) && !is_string($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get PointsEarned value
     * @return int|null
     */
    public function getPointsEarned()
    {
        return $this->PointsEarned;
    }
    /**
     * Set PointsEarned value
     * @param int $pointsEarned
     * @return \dgsoft\StructType\DgMembership
     */
    public function setPointsEarned($pointsEarned = null)
    {
        // validation for constraint: int
        if (!is_null($pointsEarned) && !is_numeric($pointsEarned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pointsEarned)), __LINE__);
        }
        $this->PointsEarned = $pointsEarned;
        return $this;
    }
    /**
     * Get TravelSector value
     * @return string|null
     */
    public function getTravelSector()
    {
        return $this->TravelSector;
    }
    /**
     * Set TravelSector value
     * @param string $travelSector
     * @return \dgsoft\StructType\DgMembership
     */
    public function setTravelSector($travelSector = null)
    {
        // validation for constraint: string
        if (!is_null($travelSector) && !is_string($travelSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelSector)), __LINE__);
        }
        $this->TravelSector = $travelSector;
        return $this;
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \dgsoft\StructType\DgMembership
     */
    public function setProgramID($programID = null)
    {
        // validation for constraint: string
        if (!is_null($programID) && !is_string($programID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($programID)), __LINE__);
        }
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get MembershipID value
     * @return string|null
     */
    public function getMembershipID()
    {
        return $this->MembershipID;
    }
    /**
     * Set MembershipID value
     * @param string $membershipID
     * @return \dgsoft\StructType\DgMembership
     */
    public function setMembershipID($membershipID = null)
    {
        // validation for constraint: string
        if (!is_null($membershipID) && !is_string($membershipID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($membershipID)), __LINE__);
        }
        $this->MembershipID = $membershipID;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \dgsoft\StructType\DgMembership
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string[]|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @throws \InvalidArgumentException
     * @param string[] $vendorCode
     * @return \dgsoft\StructType\DgMembership
     */
    public function setVendorCode(array $vendorCode = array())
    {
        foreach ($vendorCode as $membershipVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($membershipVendorCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The VendorCode property can only contain items of string, "%s" given', is_object($membershipVendorCodeItem) ? get_class($membershipVendorCodeItem) : gettype($membershipVendorCodeItem)), __LINE__);
            }
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Add item to VendorCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgMembership
     */
    public function addToVendorCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The VendorCode property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VendorCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgMembership
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
