<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MealsIncluded StructType
 * @package Dg
 * @subpackage Structs
 */
class DgMealsIncluded extends AbstractStructBase
{
    /**
     * The Breakfast
     * @var bool
     */
    public $Breakfast;
    /**
     * The Lunch
     * @var bool
     */
    public $Lunch;
    /**
     * The Dinner
     * @var bool
     */
    public $Dinner;
    /**
     * The MealPlanIndicator
     * @var bool
     */
    public $MealPlanIndicator;
    /**
     * The MealPlanCodes
     * @var string[]
     */
    public $MealPlanCodes;
    /**
     * Constructor method for MealsIncluded
     * @uses DgMealsIncluded::setBreakfast()
     * @uses DgMealsIncluded::setLunch()
     * @uses DgMealsIncluded::setDinner()
     * @uses DgMealsIncluded::setMealPlanIndicator()
     * @uses DgMealsIncluded::setMealPlanCodes()
     * @param bool $breakfast
     * @param bool $lunch
     * @param bool $dinner
     * @param bool $mealPlanIndicator
     * @param string[] $mealPlanCodes
     */
    public function __construct($breakfast = null, $lunch = null, $dinner = null, $mealPlanIndicator = null, array $mealPlanCodes = array())
    {
        $this
            ->setBreakfast($breakfast)
            ->setLunch($lunch)
            ->setDinner($dinner)
            ->setMealPlanIndicator($mealPlanIndicator)
            ->setMealPlanCodes($mealPlanCodes);
    }
    /**
     * Get Breakfast value
     * @return bool|null
     */
    public function getBreakfast()
    {
        return $this->Breakfast;
    }
    /**
     * Set Breakfast value
     * @param bool $breakfast
     * @return \dgsoft\StructType\DgMealsIncluded
     */
    public function setBreakfast($breakfast = null)
    {
        // validation for constraint: boolean
        if (!is_null($breakfast) && !is_bool($breakfast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($breakfast)), __LINE__);
        }
        $this->Breakfast = $breakfast;
        return $this;
    }
    /**
     * Get Lunch value
     * @return bool|null
     */
    public function getLunch()
    {
        return $this->Lunch;
    }
    /**
     * Set Lunch value
     * @param bool $lunch
     * @return \dgsoft\StructType\DgMealsIncluded
     */
    public function setLunch($lunch = null)
    {
        // validation for constraint: boolean
        if (!is_null($lunch) && !is_bool($lunch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($lunch)), __LINE__);
        }
        $this->Lunch = $lunch;
        return $this;
    }
    /**
     * Get Dinner value
     * @return bool|null
     */
    public function getDinner()
    {
        return $this->Dinner;
    }
    /**
     * Set Dinner value
     * @param bool $dinner
     * @return \dgsoft\StructType\DgMealsIncluded
     */
    public function setDinner($dinner = null)
    {
        // validation for constraint: boolean
        if (!is_null($dinner) && !is_bool($dinner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($dinner)), __LINE__);
        }
        $this->Dinner = $dinner;
        return $this;
    }
    /**
     * Get MealPlanIndicator value
     * @return bool|null
     */
    public function getMealPlanIndicator()
    {
        return $this->MealPlanIndicator;
    }
    /**
     * Set MealPlanIndicator value
     * @param bool $mealPlanIndicator
     * @return \dgsoft\StructType\DgMealsIncluded
     */
    public function setMealPlanIndicator($mealPlanIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($mealPlanIndicator) && !is_bool($mealPlanIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mealPlanIndicator)), __LINE__);
        }
        $this->MealPlanIndicator = $mealPlanIndicator;
        return $this;
    }
    /**
     * Get MealPlanCodes value
     * @return string[]|null
     */
    public function getMealPlanCodes()
    {
        return $this->MealPlanCodes;
    }
    /**
     * Set MealPlanCodes value
     * @throws \InvalidArgumentException
     * @param string[] $mealPlanCodes
     * @return \dgsoft\StructType\DgMealsIncluded
     */
    public function setMealPlanCodes(array $mealPlanCodes = array())
    {
        foreach ($mealPlanCodes as $mealsIncludedMealPlanCodesItem) {
            // validation for constraint: itemType
            if (!is_string($mealsIncludedMealPlanCodesItem)) {
                throw new \InvalidArgumentException(sprintf('The MealPlanCodes property can only contain items of string, "%s" given', is_object($mealsIncludedMealPlanCodesItem) ? get_class($mealsIncludedMealPlanCodesItem) : gettype($mealsIncludedMealPlanCodesItem)), __LINE__);
            }
        }
        $this->MealPlanCodes = $mealPlanCodes;
        return $this;
    }
    /**
     * Add item to MealPlanCodes value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgMealsIncluded
     */
    public function addToMealPlanCodes($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The MealPlanCodes property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MealPlanCodes[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgMealsIncluded
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
