<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaximumStay StructType
 * @package Dg
 * @subpackage Structs
 */
class DgMaximumStay extends AbstractStructBase
{
    /**
     * The ReturnType
     * @var string
     */
    public $ReturnType;
    /**
     * The ReturnTimeOfDay
     * @var string
     */
    public $ReturnTimeOfDay;
    /**
     * The MaxStay
     * @var int
     */
    public $MaxStay;
    /**
     * The StayUnit
     * @var string
     */
    public $StayUnit;
    /**
     * The MaxStayDate
     * @var string
     */
    public $MaxStayDate;
    /**
     * The ComplicatedRulesInd
     * @var bool
     */
    public $ComplicatedRulesInd;
    /**
     * Constructor method for MaximumStay
     * @uses DgMaximumStay::setReturnType()
     * @uses DgMaximumStay::setReturnTimeOfDay()
     * @uses DgMaximumStay::setMaxStay()
     * @uses DgMaximumStay::setStayUnit()
     * @uses DgMaximumStay::setMaxStayDate()
     * @uses DgMaximumStay::setComplicatedRulesInd()
     * @param string $returnType
     * @param string $returnTimeOfDay
     * @param int $maxStay
     * @param string $stayUnit
     * @param string $maxStayDate
     * @param bool $complicatedRulesInd
     */
    public function __construct($returnType = null, $returnTimeOfDay = null, $maxStay = null, $stayUnit = null, $maxStayDate = null, $complicatedRulesInd = null)
    {
        $this
            ->setReturnType($returnType)
            ->setReturnTimeOfDay($returnTimeOfDay)
            ->setMaxStay($maxStay)
            ->setStayUnit($stayUnit)
            ->setMaxStayDate($maxStayDate)
            ->setComplicatedRulesInd($complicatedRulesInd);
    }
    /**
     * Get ReturnType value
     * @return string|null
     */
    public function getReturnType()
    {
        return $this->ReturnType;
    }
    /**
     * Set ReturnType value
     * @param string $returnType
     * @return \dgsoft\StructType\DgMaximumStay
     */
    public function setReturnType($returnType = null)
    {
        // validation for constraint: string
        if (!is_null($returnType) && !is_string($returnType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnType)), __LINE__);
        }
        $this->ReturnType = $returnType;
        return $this;
    }
    /**
     * Get ReturnTimeOfDay value
     * @return string|null
     */
    public function getReturnTimeOfDay()
    {
        return $this->ReturnTimeOfDay;
    }
    /**
     * Set ReturnTimeOfDay value
     * @param string $returnTimeOfDay
     * @return \dgsoft\StructType\DgMaximumStay
     */
    public function setReturnTimeOfDay($returnTimeOfDay = null)
    {
        // validation for constraint: string
        if (!is_null($returnTimeOfDay) && !is_string($returnTimeOfDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($returnTimeOfDay)), __LINE__);
        }
        $this->ReturnTimeOfDay = $returnTimeOfDay;
        return $this;
    }
    /**
     * Get MaxStay value
     * @return int|null
     */
    public function getMaxStay()
    {
        return $this->MaxStay;
    }
    /**
     * Set MaxStay value
     * @param int $maxStay
     * @return \dgsoft\StructType\DgMaximumStay
     */
    public function setMaxStay($maxStay = null)
    {
        // validation for constraint: int
        if (!is_null($maxStay) && !is_numeric($maxStay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxStay)), __LINE__);
        }
        $this->MaxStay = $maxStay;
        return $this;
    }
    /**
     * Get StayUnit value
     * @return string|null
     */
    public function getStayUnit()
    {
        return $this->StayUnit;
    }
    /**
     * Set StayUnit value
     * @uses \dgsoft\EnumType\DgStayUnitType::valueIsValid()
     * @uses \dgsoft\EnumType\DgStayUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stayUnit
     * @return \dgsoft\StructType\DgMaximumStay
     */
    public function setStayUnit($stayUnit = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgStayUnitType::valueIsValid($stayUnit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stayUnit, implode(', ', \dgsoft\EnumType\DgStayUnitType::getValidValues())), __LINE__);
        }
        $this->StayUnit = $stayUnit;
        return $this;
    }
    /**
     * Get MaxStayDate value
     * @return string|null
     */
    public function getMaxStayDate()
    {
        return $this->MaxStayDate;
    }
    /**
     * Set MaxStayDate value
     * @param string $maxStayDate
     * @return \dgsoft\StructType\DgMaximumStay
     */
    public function setMaxStayDate($maxStayDate = null)
    {
        // validation for constraint: string
        if (!is_null($maxStayDate) && !is_string($maxStayDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxStayDate)), __LINE__);
        }
        $this->MaxStayDate = $maxStayDate;
        return $this;
    }
    /**
     * Get ComplicatedRulesInd value
     * @return bool|null
     */
    public function getComplicatedRulesInd()
    {
        return $this->ComplicatedRulesInd;
    }
    /**
     * Set ComplicatedRulesInd value
     * @param bool $complicatedRulesInd
     * @return \dgsoft\StructType\DgMaximumStay
     */
    public function setComplicatedRulesInd($complicatedRulesInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($complicatedRulesInd) && !is_bool($complicatedRulesInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($complicatedRulesInd)), __LINE__);
        }
        $this->ComplicatedRulesInd = $complicatedRulesInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgMaximumStay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
