<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationOpeningHour StructType
 * @package Dg
 * @subpackage Structs
 */
class DgLocationOpeningHour extends AbstractStructBase
{
    /**
     * The OpeningHours
     * @var string
     */
    public $OpeningHours;
    /**
     * The DayOfWeek
     * @var string
     */
    public $DayOfWeek;
    /**
     * Constructor method for LocationOpeningHour
     * @uses DgLocationOpeningHour::setOpeningHours()
     * @uses DgLocationOpeningHour::setDayOfWeek()
     * @param string $openingHours
     * @param string $dayOfWeek
     */
    public function __construct($openingHours = null, $dayOfWeek = null)
    {
        $this
            ->setOpeningHours($openingHours)
            ->setDayOfWeek($dayOfWeek);
    }
    /**
     * Get OpeningHours value
     * @return string|null
     */
    public function getOpeningHours()
    {
        return $this->OpeningHours;
    }
    /**
     * Set OpeningHours value
     * @param string $openingHours
     * @return \dgsoft\StructType\DgLocationOpeningHour
     */
    public function setOpeningHours($openingHours = null)
    {
        // validation for constraint: string
        if (!is_null($openingHours) && !is_string($openingHours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($openingHours)), __LINE__);
        }
        $this->OpeningHours = $openingHours;
        return $this;
    }
    /**
     * Get DayOfWeek value
     * @return string|null
     */
    public function getDayOfWeek()
    {
        return $this->DayOfWeek;
    }
    /**
     * Set DayOfWeek value
     * @param string $dayOfWeek
     * @return \dgsoft\StructType\DgLocationOpeningHour
     */
    public function setDayOfWeek($dayOfWeek = null)
    {
        // validation for constraint: string
        if (!is_null($dayOfWeek) && !is_string($dayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dayOfWeek)), __LINE__);
        }
        $this->DayOfWeek = $dayOfWeek;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgLocationOpeningHour
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
