<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LengthsOfStayType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgLengthsOfStayType extends AbstractStructBase
{
    /**
     * The LengthOfStay
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLengthOfStay[]
     */
    public $LengthOfStay;
    /**
     * The ArrivalDateBased
     * @var bool
     */
    public $ArrivalDateBased;
    /**
     * The FixedPatternLength
     * @var int
     */
    public $FixedPatternLength;
    /**
     * Constructor method for LengthsOfStayType
     * @uses DgLengthsOfStayType::setLengthOfStay()
     * @uses DgLengthsOfStayType::setArrivalDateBased()
     * @uses DgLengthsOfStayType::setFixedPatternLength()
     * @param \dgsoft\StructType\DgLengthOfStay[] $lengthOfStay
     * @param bool $arrivalDateBased
     * @param int $fixedPatternLength
     */
    public function __construct(array $lengthOfStay = array(), $arrivalDateBased = null, $fixedPatternLength = null)
    {
        $this
            ->setLengthOfStay($lengthOfStay)
            ->setArrivalDateBased($arrivalDateBased)
            ->setFixedPatternLength($fixedPatternLength);
    }
    /**
     * Get LengthOfStay value
     * @return \dgsoft\StructType\DgLengthOfStay[]|null
     */
    public function getLengthOfStay()
    {
        return $this->LengthOfStay;
    }
    /**
     * Set LengthOfStay value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLengthOfStay[] $lengthOfStay
     * @return \dgsoft\StructType\DgLengthsOfStayType
     */
    public function setLengthOfStay(array $lengthOfStay = array())
    {
        foreach ($lengthOfStay as $lengthsOfStayTypeLengthOfStayItem) {
            // validation for constraint: itemType
            if (!$lengthsOfStayTypeLengthOfStayItem instanceof \dgsoft\StructType\DgLengthOfStay) {
                throw new \InvalidArgumentException(sprintf('The LengthOfStay property can only contain items of \dgsoft\StructType\DgLengthOfStay, "%s" given', is_object($lengthsOfStayTypeLengthOfStayItem) ? get_class($lengthsOfStayTypeLengthOfStayItem) : gettype($lengthsOfStayTypeLengthOfStayItem)), __LINE__);
            }
        }
        $this->LengthOfStay = $lengthOfStay;
        return $this;
    }
    /**
     * Add item to LengthOfStay value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLengthOfStay $item
     * @return \dgsoft\StructType\DgLengthsOfStayType
     */
    public function addToLengthOfStay(\dgsoft\StructType\DgLengthOfStay $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgLengthOfStay) {
            throw new \InvalidArgumentException(sprintf('The LengthOfStay property can only contain items of \dgsoft\StructType\DgLengthOfStay, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LengthOfStay[] = $item;
        return $this;
    }
    /**
     * Get ArrivalDateBased value
     * @return bool|null
     */
    public function getArrivalDateBased()
    {
        return $this->ArrivalDateBased;
    }
    /**
     * Set ArrivalDateBased value
     * @param bool $arrivalDateBased
     * @return \dgsoft\StructType\DgLengthsOfStayType
     */
    public function setArrivalDateBased($arrivalDateBased = null)
    {
        // validation for constraint: boolean
        if (!is_null($arrivalDateBased) && !is_bool($arrivalDateBased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($arrivalDateBased)), __LINE__);
        }
        $this->ArrivalDateBased = $arrivalDateBased;
        return $this;
    }
    /**
     * Get FixedPatternLength value
     * @return int|null
     */
    public function getFixedPatternLength()
    {
        return $this->FixedPatternLength;
    }
    /**
     * Set FixedPatternLength value
     * @param int $fixedPatternLength
     * @return \dgsoft\StructType\DgLengthsOfStayType
     */
    public function setFixedPatternLength($fixedPatternLength = null)
    {
        // validation for constraint: int
        if (!is_null($fixedPatternLength) && !is_numeric($fixedPatternLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fixedPatternLength)), __LINE__);
        }
        $this->FixedPatternLength = $fixedPatternLength;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgLengthsOfStayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
