<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LastTicketingDateData StructType
 * @package Dg
 * @subpackage Structs
 */
class DgLastTicketingDateData extends AbstractStructBase
{
    /**
     * The OldLastTicketingDate
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $OldLastTicketingDate;
    /**
     * The PnrNo
     * @var string
     */
    public $PnrNo;
    /**
     * The LastTicketingDate
     * @var string
     */
    public $LastTicketingDate;
    /**
     * Constructor method for LastTicketingDateData
     * @uses DgLastTicketingDateData::setOldLastTicketingDate()
     * @uses DgLastTicketingDateData::setPnrNo()
     * @uses DgLastTicketingDateData::setLastTicketingDate()
     * @param string $oldLastTicketingDate
     * @param string $pnrNo
     * @param string $lastTicketingDate
     */
    public function __construct($oldLastTicketingDate = null, $pnrNo = null, $lastTicketingDate = null)
    {
        $this
            ->setOldLastTicketingDate($oldLastTicketingDate)
            ->setPnrNo($pnrNo)
            ->setLastTicketingDate($lastTicketingDate);
    }
    /**
     * Get OldLastTicketingDate value
     * @return string
     */
    public function getOldLastTicketingDate()
    {
        return $this->OldLastTicketingDate;
    }
    /**
     * Set OldLastTicketingDate value
     * @param string $oldLastTicketingDate
     * @return \dgsoft\StructType\DgLastTicketingDateData
     */
    public function setOldLastTicketingDate($oldLastTicketingDate = null)
    {
        // validation for constraint: string
        if (!is_null($oldLastTicketingDate) && !is_string($oldLastTicketingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oldLastTicketingDate)), __LINE__);
        }
        $this->OldLastTicketingDate = $oldLastTicketingDate;
        return $this;
    }
    /**
     * Get PnrNo value
     * @return string|null
     */
    public function getPnrNo()
    {
        return $this->PnrNo;
    }
    /**
     * Set PnrNo value
     * @param string $pnrNo
     * @return \dgsoft\StructType\DgLastTicketingDateData
     */
    public function setPnrNo($pnrNo = null)
    {
        // validation for constraint: string
        if (!is_null($pnrNo) && !is_string($pnrNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pnrNo)), __LINE__);
        }
        $this->PnrNo = $pnrNo;
        return $this;
    }
    /**
     * Get LastTicketingDate value
     * @return string|null
     */
    public function getLastTicketingDate()
    {
        return $this->LastTicketingDate;
    }
    /**
     * Set LastTicketingDate value
     * @param string $lastTicketingDate
     * @return \dgsoft\StructType\DgLastTicketingDateData
     */
    public function setLastTicketingDate($lastTicketingDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastTicketingDate) && !is_string($lastTicketingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastTicketingDate)), __LINE__);
        }
        $this->LastTicketingDate = $lastTicketingDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgLastTicketingDateData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
