<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCCUserLogin StructType
 * @package Dg
 * @subpackage Structs
 */
class DgLCCUserLogin extends AbstractStructBase
{
    /**
     * The UserName
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * @var string
     */
    public $Password;
    /**
     * Constructor method for LCCUserLogin
     * @uses DgLCCUserLogin::setUserName()
     * @uses DgLCCUserLogin::setPassword()
     * @param string $userName
     * @param string $password
     */
    public function __construct($userName = null, $password = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \dgsoft\StructType\DgLCCUserLogin
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \dgsoft\StructType\DgLCCUserLogin
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgLCCUserLogin
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
