<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCCRequiredParameter StructType
 * @package Dg
 * @subpackage Structs
 */
class DgLCCRequiredParameter extends AbstractStructBase
{
    /**
     * The Enabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Enabled;
    /**
     * The Mandatory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Mandatory;
    /**
     * The PerPassenger
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PerPassenger;
    /**
     * The Info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Info;
    /**
     * Constructor method for LCCRequiredParameter
     * @uses DgLCCRequiredParameter::setEnabled()
     * @uses DgLCCRequiredParameter::setMandatory()
     * @uses DgLCCRequiredParameter::setPerPassenger()
     * @uses DgLCCRequiredParameter::setInfo()
     * @param bool $enabled
     * @param bool $mandatory
     * @param bool $perPassenger
     * @param string $info
     */
    public function __construct($enabled = null, $mandatory = null, $perPassenger = null, $info = null)
    {
        $this
            ->setEnabled($enabled)
            ->setMandatory($mandatory)
            ->setPerPassenger($perPassenger)
            ->setInfo($info);
    }
    /**
     * Get Enabled value
     * @return bool
     */
    public function getEnabled()
    {
        return $this->Enabled;
    }
    /**
     * Set Enabled value
     * @param bool $enabled
     * @return \dgsoft\StructType\DgLCCRequiredParameter
     */
    public function setEnabled($enabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($enabled) && !is_bool($enabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enabled)), __LINE__);
        }
        $this->Enabled = $enabled;
        return $this;
    }
    /**
     * Get Mandatory value
     * @return bool
     */
    public function getMandatory()
    {
        return $this->Mandatory;
    }
    /**
     * Set Mandatory value
     * @param bool $mandatory
     * @return \dgsoft\StructType\DgLCCRequiredParameter
     */
    public function setMandatory($mandatory = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatory) && !is_bool($mandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mandatory)), __LINE__);
        }
        $this->Mandatory = $mandatory;
        return $this;
    }
    /**
     * Get PerPassenger value
     * @return bool
     */
    public function getPerPassenger()
    {
        return $this->PerPassenger;
    }
    /**
     * Set PerPassenger value
     * @param bool $perPassenger
     * @return \dgsoft\StructType\DgLCCRequiredParameter
     */
    public function setPerPassenger($perPassenger = null)
    {
        // validation for constraint: boolean
        if (!is_null($perPassenger) && !is_bool($perPassenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($perPassenger)), __LINE__);
        }
        $this->PerPassenger = $perPassenger;
        return $this;
    }
    /**
     * Get Info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param string $info
     * @return \dgsoft\StructType\DgLCCRequiredParameter
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($info)), __LINE__);
        }
        $this->Info = $info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgLCCRequiredParameter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
