<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCCOtherFee StructType
 * @package Dg
 * @subpackage Structs
 */
class DgLCCOtherFee extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Amount;
    /**
     * The PerPassenger
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $PerPassenger;
    /**
     * The CostType
     * @var string
     */
    public $CostType;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for LCCOtherFee
     * @uses DgLCCOtherFee::setAmount()
     * @uses DgLCCOtherFee::setPerPassenger()
     * @uses DgLCCOtherFee::setCostType()
     * @uses DgLCCOtherFee::setCurrency()
     * @param float $amount
     * @param bool $perPassenger
     * @param string $costType
     * @param string $currency
     */
    public function __construct($amount = null, $perPassenger = null, $costType = null, $currency = null)
    {
        $this
            ->setAmount($amount)
            ->setPerPassenger($perPassenger)
            ->setCostType($costType)
            ->setCurrency($currency);
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgLCCOtherFee
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PerPassenger value
     * @return bool
     */
    public function getPerPassenger()
    {
        return $this->PerPassenger;
    }
    /**
     * Set PerPassenger value
     * @param bool $perPassenger
     * @return \dgsoft\StructType\DgLCCOtherFee
     */
    public function setPerPassenger($perPassenger = null)
    {
        // validation for constraint: boolean
        if (!is_null($perPassenger) && !is_bool($perPassenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($perPassenger)), __LINE__);
        }
        $this->PerPassenger = $perPassenger;
        return $this;
    }
    /**
     * Get CostType value
     * @return string|null
     */
    public function getCostType()
    {
        return $this->CostType;
    }
    /**
     * Set CostType value
     * @param string $costType
     * @return \dgsoft\StructType\DgLCCOtherFee
     */
    public function setCostType($costType = null)
    {
        // validation for constraint: string
        if (!is_null($costType) && !is_string($costType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($costType)), __LINE__);
        }
        $this->CostType = $costType;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \dgsoft\StructType\DgLCCOtherFee
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgLCCOtherFee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
