<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageDescriptionType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgImageDescriptionType extends AbstractStructBase
{
    /**
     * The ImageFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgImageFormat[]
     */
    public $ImageFormat;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDescription[]
     */
    public $Description;
    /**
     * The Category
     * @var string
     */
    public $Category;
    /**
     * Constructor method for ImageDescriptionType
     * @uses DgImageDescriptionType::setImageFormat()
     * @uses DgImageDescriptionType::setDescription()
     * @uses DgImageDescriptionType::setCategory()
     * @param \dgsoft\StructType\DgImageFormat[] $imageFormat
     * @param \dgsoft\StructType\DgDescription[] $description
     * @param string $category
     */
    public function __construct(array $imageFormat = array(), array $description = array(), $category = null)
    {
        $this
            ->setImageFormat($imageFormat)
            ->setDescription($description)
            ->setCategory($category);
    }
    /**
     * Get ImageFormat value
     * @return \dgsoft\StructType\DgImageFormat[]|null
     */
    public function getImageFormat()
    {
        return $this->ImageFormat;
    }
    /**
     * Set ImageFormat value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgImageFormat[] $imageFormat
     * @return \dgsoft\StructType\DgImageDescriptionType
     */
    public function setImageFormat(array $imageFormat = array())
    {
        foreach ($imageFormat as $imageDescriptionTypeImageFormatItem) {
            // validation for constraint: itemType
            if (!$imageDescriptionTypeImageFormatItem instanceof \dgsoft\StructType\DgImageFormat) {
                throw new \InvalidArgumentException(sprintf('The ImageFormat property can only contain items of \dgsoft\StructType\DgImageFormat, "%s" given', is_object($imageDescriptionTypeImageFormatItem) ? get_class($imageDescriptionTypeImageFormatItem) : gettype($imageDescriptionTypeImageFormatItem)), __LINE__);
            }
        }
        $this->ImageFormat = $imageFormat;
        return $this;
    }
    /**
     * Add item to ImageFormat value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgImageFormat $item
     * @return \dgsoft\StructType\DgImageDescriptionType
     */
    public function addToImageFormat(\dgsoft\StructType\DgImageFormat $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgImageFormat) {
            throw new \InvalidArgumentException(sprintf('The ImageFormat property can only contain items of \dgsoft\StructType\DgImageFormat, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ImageFormat[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return \dgsoft\StructType\DgDescription[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDescription[] $description
     * @return \dgsoft\StructType\DgImageDescriptionType
     */
    public function setDescription(array $description = array())
    {
        foreach ($description as $imageDescriptionTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$imageDescriptionTypeDescriptionItem instanceof \dgsoft\StructType\DgDescription) {
                throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \dgsoft\StructType\DgDescription, "%s" given', is_object($imageDescriptionTypeDescriptionItem) ? get_class($imageDescriptionTypeDescriptionItem) : gettype($imageDescriptionTypeDescriptionItem)), __LINE__);
            }
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDescription $item
     * @return \dgsoft\StructType\DgImageDescriptionType
     */
    public function addToDescription(\dgsoft\StructType\DgDescription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgDescription) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \dgsoft\StructType\DgDescription, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \dgsoft\StructType\DgImageDescriptionType
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgImageDescriptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
