<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelSearchCriterionType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgHotelSearchCriterionType extends DgItemSearchCriterionType
{
    /**
     * The HotelAmenity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgHotelAmenity[]
     */
    public $HotelAmenity;
    /**
     * The RoomAmenity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRoomAmenityPrefType[]
     */
    public $RoomAmenity;
    /**
     * The Award
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAward[]
     */
    public $Award;
    /**
     * The Recreation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRecreation[]
     */
    public $Recreation;
    /**
     * The Service
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgService[]
     */
    public $Service;
    /**
     * The Transportation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTransportation[]
     */
    public $Transportation;
    /**
     * The StayDateRange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDateTimeSpanType
     */
    public $StayDateRange;
    /**
     * The RateRange
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRateRange[]
     */
    public $RateRange;
    /**
     * The RatePlanCandidates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfRatePlanCandidatesTypeRatePlanCandidate
     */
    public $RatePlanCandidates;
    /**
     * The Profiles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfProfilesTypeProfileInfo
     */
    public $Profiles;
    /**
     * The RoomStayCandidates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfRoomStayCandidateType
     */
    public $RoomStayCandidates;
    /**
     * The AcceptedPayments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfPaymentFormType
     */
    public $AcceptedPayments;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The Occupancy
     * @var string
     */
    public $Occupancy;
    /**
     * The RateCodes
     * @var string
     */
    public $RateCodes;
    /**
     * The RefNumber
     * @var int
     */
    public $RefNumber;
    /**
     * Constructor method for HotelSearchCriterionType
     * @uses DgHotelSearchCriterionType::setHotelAmenity()
     * @uses DgHotelSearchCriterionType::setRoomAmenity()
     * @uses DgHotelSearchCriterionType::setAward()
     * @uses DgHotelSearchCriterionType::setRecreation()
     * @uses DgHotelSearchCriterionType::setService()
     * @uses DgHotelSearchCriterionType::setTransportation()
     * @uses DgHotelSearchCriterionType::setStayDateRange()
     * @uses DgHotelSearchCriterionType::setRateRange()
     * @uses DgHotelSearchCriterionType::setRatePlanCandidates()
     * @uses DgHotelSearchCriterionType::setProfiles()
     * @uses DgHotelSearchCriterionType::setRoomStayCandidates()
     * @uses DgHotelSearchCriterionType::setAcceptedPayments()
     * @uses DgHotelSearchCriterionType::setTPA_Extensions()
     * @uses DgHotelSearchCriterionType::setOccupancy()
     * @uses DgHotelSearchCriterionType::setRateCodes()
     * @uses DgHotelSearchCriterionType::setRefNumber()
     * @param \dgsoft\StructType\DgHotelAmenity[] $hotelAmenity
     * @param \dgsoft\StructType\DgRoomAmenityPrefType[] $roomAmenity
     * @param \dgsoft\StructType\DgAward[] $award
     * @param \dgsoft\StructType\DgRecreation[] $recreation
     * @param \dgsoft\StructType\DgService[] $service
     * @param \dgsoft\StructType\DgTransportation[] $transportation
     * @param \dgsoft\StructType\DgDateTimeSpanType $stayDateRange
     * @param \dgsoft\StructType\DgRateRange[] $rateRange
     * @param \dgsoft\ArrayType\DgArrayOfRatePlanCandidatesTypeRatePlanCandidate $ratePlanCandidates
     * @param \dgsoft\ArrayType\DgArrayOfProfilesTypeProfileInfo $profiles
     * @param \dgsoft\ArrayType\DgArrayOfRoomStayCandidateType $roomStayCandidates
     * @param \dgsoft\ArrayType\DgArrayOfPaymentFormType $acceptedPayments
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $occupancy
     * @param string $rateCodes
     * @param int $refNumber
     */
    public function __construct(array $hotelAmenity = array(), array $roomAmenity = array(), array $award = array(), array $recreation = array(), array $service = array(), array $transportation = array(), \dgsoft\StructType\DgDateTimeSpanType $stayDateRange = null, array $rateRange = array(), \dgsoft\ArrayType\DgArrayOfRatePlanCandidatesTypeRatePlanCandidate $ratePlanCandidates = null, \dgsoft\ArrayType\DgArrayOfProfilesTypeProfileInfo $profiles = null, \dgsoft\ArrayType\DgArrayOfRoomStayCandidateType $roomStayCandidates = null, \dgsoft\ArrayType\DgArrayOfPaymentFormType $acceptedPayments = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $occupancy = null, $rateCodes = null, $refNumber = null)
    {
        $this
            ->setHotelAmenity($hotelAmenity)
            ->setRoomAmenity($roomAmenity)
            ->setAward($award)
            ->setRecreation($recreation)
            ->setService($service)
            ->setTransportation($transportation)
            ->setStayDateRange($stayDateRange)
            ->setRateRange($rateRange)
            ->setRatePlanCandidates($ratePlanCandidates)
            ->setProfiles($profiles)
            ->setRoomStayCandidates($roomStayCandidates)
            ->setAcceptedPayments($acceptedPayments)
            ->setTPA_Extensions($tPA_Extensions)
            ->setOccupancy($occupancy)
            ->setRateCodes($rateCodes)
            ->setRefNumber($refNumber);
    }
    /**
     * Get HotelAmenity value
     * @return \dgsoft\StructType\DgHotelAmenity[]|null
     */
    public function getHotelAmenity()
    {
        return $this->HotelAmenity;
    }
    /**
     * Set HotelAmenity value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgHotelAmenity[] $hotelAmenity
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function setHotelAmenity(array $hotelAmenity = array())
    {
        foreach ($hotelAmenity as $hotelSearchCriterionTypeHotelAmenityItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriterionTypeHotelAmenityItem instanceof \dgsoft\StructType\DgHotelAmenity) {
                throw new \InvalidArgumentException(sprintf('The HotelAmenity property can only contain items of \dgsoft\StructType\DgHotelAmenity, "%s" given', is_object($hotelSearchCriterionTypeHotelAmenityItem) ? get_class($hotelSearchCriterionTypeHotelAmenityItem) : gettype($hotelSearchCriterionTypeHotelAmenityItem)), __LINE__);
            }
        }
        $this->HotelAmenity = $hotelAmenity;
        return $this;
    }
    /**
     * Add item to HotelAmenity value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgHotelAmenity $item
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function addToHotelAmenity(\dgsoft\StructType\DgHotelAmenity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgHotelAmenity) {
            throw new \InvalidArgumentException(sprintf('The HotelAmenity property can only contain items of \dgsoft\StructType\DgHotelAmenity, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->HotelAmenity[] = $item;
        return $this;
    }
    /**
     * Get RoomAmenity value
     * @return \dgsoft\StructType\DgRoomAmenityPrefType[]|null
     */
    public function getRoomAmenity()
    {
        return $this->RoomAmenity;
    }
    /**
     * Set RoomAmenity value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRoomAmenityPrefType[] $roomAmenity
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function setRoomAmenity(array $roomAmenity = array())
    {
        foreach ($roomAmenity as $hotelSearchCriterionTypeRoomAmenityItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriterionTypeRoomAmenityItem instanceof \dgsoft\StructType\DgRoomAmenityPrefType) {
                throw new \InvalidArgumentException(sprintf('The RoomAmenity property can only contain items of \dgsoft\StructType\DgRoomAmenityPrefType, "%s" given', is_object($hotelSearchCriterionTypeRoomAmenityItem) ? get_class($hotelSearchCriterionTypeRoomAmenityItem) : gettype($hotelSearchCriterionTypeRoomAmenityItem)), __LINE__);
            }
        }
        $this->RoomAmenity = $roomAmenity;
        return $this;
    }
    /**
     * Add item to RoomAmenity value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRoomAmenityPrefType $item
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function addToRoomAmenity(\dgsoft\StructType\DgRoomAmenityPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRoomAmenityPrefType) {
            throw new \InvalidArgumentException(sprintf('The RoomAmenity property can only contain items of \dgsoft\StructType\DgRoomAmenityPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoomAmenity[] = $item;
        return $this;
    }
    /**
     * Get Award value
     * @return \dgsoft\StructType\DgAward[]|null
     */
    public function getAward()
    {
        return $this->Award;
    }
    /**
     * Set Award value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAward[] $award
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function setAward(array $award = array())
    {
        foreach ($award as $hotelSearchCriterionTypeAwardItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriterionTypeAwardItem instanceof \dgsoft\StructType\DgAward) {
                throw new \InvalidArgumentException(sprintf('The Award property can only contain items of \dgsoft\StructType\DgAward, "%s" given', is_object($hotelSearchCriterionTypeAwardItem) ? get_class($hotelSearchCriterionTypeAwardItem) : gettype($hotelSearchCriterionTypeAwardItem)), __LINE__);
            }
        }
        $this->Award = $award;
        return $this;
    }
    /**
     * Add item to Award value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAward $item
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function addToAward(\dgsoft\StructType\DgAward $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAward) {
            throw new \InvalidArgumentException(sprintf('The Award property can only contain items of \dgsoft\StructType\DgAward, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Award[] = $item;
        return $this;
    }
    /**
     * Get Recreation value
     * @return \dgsoft\StructType\DgRecreation[]|null
     */
    public function getRecreation()
    {
        return $this->Recreation;
    }
    /**
     * Set Recreation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRecreation[] $recreation
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function setRecreation(array $recreation = array())
    {
        foreach ($recreation as $hotelSearchCriterionTypeRecreationItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriterionTypeRecreationItem instanceof \dgsoft\StructType\DgRecreation) {
                throw new \InvalidArgumentException(sprintf('The Recreation property can only contain items of \dgsoft\StructType\DgRecreation, "%s" given', is_object($hotelSearchCriterionTypeRecreationItem) ? get_class($hotelSearchCriterionTypeRecreationItem) : gettype($hotelSearchCriterionTypeRecreationItem)), __LINE__);
            }
        }
        $this->Recreation = $recreation;
        return $this;
    }
    /**
     * Add item to Recreation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRecreation $item
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function addToRecreation(\dgsoft\StructType\DgRecreation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRecreation) {
            throw new \InvalidArgumentException(sprintf('The Recreation property can only contain items of \dgsoft\StructType\DgRecreation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Recreation[] = $item;
        return $this;
    }
    /**
     * Get Service value
     * @return \dgsoft\StructType\DgService[]|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgService[] $service
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function setService(array $service = array())
    {
        foreach ($service as $hotelSearchCriterionTypeServiceItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriterionTypeServiceItem instanceof \dgsoft\StructType\DgService) {
                throw new \InvalidArgumentException(sprintf('The Service property can only contain items of \dgsoft\StructType\DgService, "%s" given', is_object($hotelSearchCriterionTypeServiceItem) ? get_class($hotelSearchCriterionTypeServiceItem) : gettype($hotelSearchCriterionTypeServiceItem)), __LINE__);
            }
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgService $item
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function addToService(\dgsoft\StructType\DgService $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgService) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of \dgsoft\StructType\DgService, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
    /**
     * Get Transportation value
     * @return \dgsoft\StructType\DgTransportation[]|null
     */
    public function getTransportation()
    {
        return $this->Transportation;
    }
    /**
     * Set Transportation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTransportation[] $transportation
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function setTransportation(array $transportation = array())
    {
        foreach ($transportation as $hotelSearchCriterionTypeTransportationItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriterionTypeTransportationItem instanceof \dgsoft\StructType\DgTransportation) {
                throw new \InvalidArgumentException(sprintf('The Transportation property can only contain items of \dgsoft\StructType\DgTransportation, "%s" given', is_object($hotelSearchCriterionTypeTransportationItem) ? get_class($hotelSearchCriterionTypeTransportationItem) : gettype($hotelSearchCriterionTypeTransportationItem)), __LINE__);
            }
        }
        $this->Transportation = $transportation;
        return $this;
    }
    /**
     * Add item to Transportation value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTransportation $item
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function addToTransportation(\dgsoft\StructType\DgTransportation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTransportation) {
            throw new \InvalidArgumentException(sprintf('The Transportation property can only contain items of \dgsoft\StructType\DgTransportation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Transportation[] = $item;
        return $this;
    }
    /**
     * Get StayDateRange value
     * @return \dgsoft\StructType\DgDateTimeSpanType|null
     */
    public function getStayDateRange()
    {
        return $this->StayDateRange;
    }
    /**
     * Set StayDateRange value
     * @param \dgsoft\StructType\DgDateTimeSpanType $stayDateRange
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function setStayDateRange(\dgsoft\StructType\DgDateTimeSpanType $stayDateRange = null)
    {
        $this->StayDateRange = $stayDateRange;
        return $this;
    }
    /**
     * Get RateRange value
     * @return \dgsoft\StructType\DgRateRange[]|null
     */
    public function getRateRange()
    {
        return $this->RateRange;
    }
    /**
     * Set RateRange value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRateRange[] $rateRange
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function setRateRange(array $rateRange = array())
    {
        foreach ($rateRange as $hotelSearchCriterionTypeRateRangeItem) {
            // validation for constraint: itemType
            if (!$hotelSearchCriterionTypeRateRangeItem instanceof \dgsoft\StructType\DgRateRange) {
                throw new \InvalidArgumentException(sprintf('The RateRange property can only contain items of \dgsoft\StructType\DgRateRange, "%s" given', is_object($hotelSearchCriterionTypeRateRangeItem) ? get_class($hotelSearchCriterionTypeRateRangeItem) : gettype($hotelSearchCriterionTypeRateRangeItem)), __LINE__);
            }
        }
        $this->RateRange = $rateRange;
        return $this;
    }
    /**
     * Add item to RateRange value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRateRange $item
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function addToRateRange(\dgsoft\StructType\DgRateRange $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRateRange) {
            throw new \InvalidArgumentException(sprintf('The RateRange property can only contain items of \dgsoft\StructType\DgRateRange, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RateRange[] = $item;
        return $this;
    }
    /**
     * Get RatePlanCandidates value
     * @return \dgsoft\ArrayType\DgArrayOfRatePlanCandidatesTypeRatePlanCandidate|null
     */
    public function getRatePlanCandidates()
    {
        return $this->RatePlanCandidates;
    }
    /**
     * Set RatePlanCandidates value
     * @param \dgsoft\ArrayType\DgArrayOfRatePlanCandidatesTypeRatePlanCandidate $ratePlanCandidates
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function setRatePlanCandidates(\dgsoft\ArrayType\DgArrayOfRatePlanCandidatesTypeRatePlanCandidate $ratePlanCandidates = null)
    {
        $this->RatePlanCandidates = $ratePlanCandidates;
        return $this;
    }
    /**
     * Get Profiles value
     * @return \dgsoft\ArrayType\DgArrayOfProfilesTypeProfileInfo|null
     */
    public function getProfiles()
    {
        return $this->Profiles;
    }
    /**
     * Set Profiles value
     * @param \dgsoft\ArrayType\DgArrayOfProfilesTypeProfileInfo $profiles
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function setProfiles(\dgsoft\ArrayType\DgArrayOfProfilesTypeProfileInfo $profiles = null)
    {
        $this->Profiles = $profiles;
        return $this;
    }
    /**
     * Get RoomStayCandidates value
     * @return \dgsoft\ArrayType\DgArrayOfRoomStayCandidateType|null
     */
    public function getRoomStayCandidates()
    {
        return $this->RoomStayCandidates;
    }
    /**
     * Set RoomStayCandidates value
     * @param \dgsoft\ArrayType\DgArrayOfRoomStayCandidateType $roomStayCandidates
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function setRoomStayCandidates(\dgsoft\ArrayType\DgArrayOfRoomStayCandidateType $roomStayCandidates = null)
    {
        $this->RoomStayCandidates = $roomStayCandidates;
        return $this;
    }
    /**
     * Get AcceptedPayments value
     * @return \dgsoft\ArrayType\DgArrayOfPaymentFormType|null
     */
    public function getAcceptedPayments()
    {
        return $this->AcceptedPayments;
    }
    /**
     * Set AcceptedPayments value
     * @param \dgsoft\ArrayType\DgArrayOfPaymentFormType $acceptedPayments
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function setAcceptedPayments(\dgsoft\ArrayType\DgArrayOfPaymentFormType $acceptedPayments = null)
    {
        $this->AcceptedPayments = $acceptedPayments;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Occupancy value
     * @return string|null
     */
    public function getOccupancy()
    {
        return $this->Occupancy;
    }
    /**
     * Set Occupancy value
     * @param string $occupancy
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function setOccupancy($occupancy = null)
    {
        // validation for constraint: string
        if (!is_null($occupancy) && !is_string($occupancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($occupancy)), __LINE__);
        }
        $this->Occupancy = $occupancy;
        return $this;
    }
    /**
     * Get RateCodes value
     * @return string|null
     */
    public function getRateCodes()
    {
        return $this->RateCodes;
    }
    /**
     * Set RateCodes value
     * @param string $rateCodes
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function setRateCodes($rateCodes = null)
    {
        // validation for constraint: string
        if (!is_null($rateCodes) && !is_string($rateCodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateCodes)), __LINE__);
        }
        $this->RateCodes = $rateCodes;
        return $this;
    }
    /**
     * Get RefNumber value
     * @return int|null
     */
    public function getRefNumber()
    {
        return $this->RefNumber;
    }
    /**
     * Set RefNumber value
     * @param int $refNumber
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public function setRefNumber($refNumber = null)
    {
        // validation for constraint: int
        if (!is_null($refNumber) && !is_numeric($refNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($refNumber)), __LINE__);
        }
        $this->RefNumber = $refNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgHotelSearchCriterionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
