<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelReservationType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgHotelReservationType extends AbstractStructBase
{
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSourceType
     */
    public $POS;
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID_Type[]
     */
    public $UniqueID;
    /**
     * The RoomStays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfOTA_HotelAvailRSRoomStaysRoomStay
     */
    public $RoomStays;
    /**
     * The HotelStay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgHotelStay
     */
    public $HotelStay;
    /**
     * The Areas
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAreas
     */
    public $Areas;
    /**
     * The Services
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfServicesTypeService
     */
    public $Services;
    /**
     * The ResGuests
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfResGuestsTypeResGuest
     */
    public $ResGuests;
    /**
     * The ResGlobalInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgResGlobalInfoType
     */
    public $ResGlobalInfo;
    /**
     * The WrittenConfInst
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgWrittenConfInstType
     */
    public $WrittenConfInst;
    /**
     * The Queue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgQueue
     */
    public $Queue;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The RoomStayReservation
     * @var bool
     */
    public $RoomStayReservation;
    /**
     * The CreateDateTime
     * @var string
     */
    public $CreateDateTime;
    /**
     * The CreatorID
     * @var string
     */
    public $CreatorID;
    /**
     * The LastModifyDateTime
     * @var string
     */
    public $LastModifyDateTime;
    /**
     * The LastModifierID
     * @var string
     */
    public $LastModifierID;
    /**
     * The PurgeDate
     * @var string
     */
    public $PurgeDate;
    /**
     * The ResStatus
     * @var string
     */
    public $ResStatus;
    /**
     * The ForcedSellIndicator
     * @var bool
     */
    public $ForcedSellIndicator;
    /**
     * The ServiceOverrideIndicator
     * @var bool
     */
    public $ServiceOverrideIndicator;
    /**
     * The RateOverrideIndicator
     * @var bool
     */
    public $RateOverrideIndicator;
    /**
     * The WalkInIndicator
     * @var bool
     */
    public $WalkInIndicator;
    /**
     * The RoomNumberLockedIndicator
     * @var bool
     */
    public $RoomNumberLockedIndicator;
    /**
     * Constructor method for HotelReservationType
     * @uses DgHotelReservationType::setPOS()
     * @uses DgHotelReservationType::setUniqueID()
     * @uses DgHotelReservationType::setRoomStays()
     * @uses DgHotelReservationType::setHotelStay()
     * @uses DgHotelReservationType::setAreas()
     * @uses DgHotelReservationType::setServices()
     * @uses DgHotelReservationType::setResGuests()
     * @uses DgHotelReservationType::setResGlobalInfo()
     * @uses DgHotelReservationType::setWrittenConfInst()
     * @uses DgHotelReservationType::setQueue()
     * @uses DgHotelReservationType::setTPA_Extensions()
     * @uses DgHotelReservationType::setRoomStayReservation()
     * @uses DgHotelReservationType::setCreateDateTime()
     * @uses DgHotelReservationType::setCreatorID()
     * @uses DgHotelReservationType::setLastModifyDateTime()
     * @uses DgHotelReservationType::setLastModifierID()
     * @uses DgHotelReservationType::setPurgeDate()
     * @uses DgHotelReservationType::setResStatus()
     * @uses DgHotelReservationType::setForcedSellIndicator()
     * @uses DgHotelReservationType::setServiceOverrideIndicator()
     * @uses DgHotelReservationType::setRateOverrideIndicator()
     * @uses DgHotelReservationType::setWalkInIndicator()
     * @uses DgHotelReservationType::setRoomNumberLockedIndicator()
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @param \dgsoft\StructType\DgUniqueID_Type[] $uniqueID
     * @param \dgsoft\ArrayType\DgArrayOfOTA_HotelAvailRSRoomStaysRoomStay $roomStays
     * @param \dgsoft\StructType\DgHotelStay $hotelStay
     * @param \dgsoft\StructType\DgAreas $areas
     * @param \dgsoft\ArrayType\DgArrayOfServicesTypeService $services
     * @param \dgsoft\ArrayType\DgArrayOfResGuestsTypeResGuest $resGuests
     * @param \dgsoft\StructType\DgResGlobalInfoType $resGlobalInfo
     * @param \dgsoft\StructType\DgWrittenConfInstType $writtenConfInst
     * @param \dgsoft\StructType\DgQueue $queue
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param bool $roomStayReservation
     * @param string $createDateTime
     * @param string $creatorID
     * @param string $lastModifyDateTime
     * @param string $lastModifierID
     * @param string $purgeDate
     * @param string $resStatus
     * @param bool $forcedSellIndicator
     * @param bool $serviceOverrideIndicator
     * @param bool $rateOverrideIndicator
     * @param bool $walkInIndicator
     * @param bool $roomNumberLockedIndicator
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfSourceType $pOS = null, array $uniqueID = array(), \dgsoft\ArrayType\DgArrayOfOTA_HotelAvailRSRoomStaysRoomStay $roomStays = null, \dgsoft\StructType\DgHotelStay $hotelStay = null, \dgsoft\StructType\DgAreas $areas = null, \dgsoft\ArrayType\DgArrayOfServicesTypeService $services = null, \dgsoft\ArrayType\DgArrayOfResGuestsTypeResGuest $resGuests = null, \dgsoft\StructType\DgResGlobalInfoType $resGlobalInfo = null, \dgsoft\StructType\DgWrittenConfInstType $writtenConfInst = null, \dgsoft\StructType\DgQueue $queue = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $roomStayReservation = null, $createDateTime = null, $creatorID = null, $lastModifyDateTime = null, $lastModifierID = null, $purgeDate = null, $resStatus = null, $forcedSellIndicator = null, $serviceOverrideIndicator = null, $rateOverrideIndicator = null, $walkInIndicator = null, $roomNumberLockedIndicator = null)
    {
        $this
            ->setPOS($pOS)
            ->setUniqueID($uniqueID)
            ->setRoomStays($roomStays)
            ->setHotelStay($hotelStay)
            ->setAreas($areas)
            ->setServices($services)
            ->setResGuests($resGuests)
            ->setResGlobalInfo($resGlobalInfo)
            ->setWrittenConfInst($writtenConfInst)
            ->setQueue($queue)
            ->setTPA_Extensions($tPA_Extensions)
            ->setRoomStayReservation($roomStayReservation)
            ->setCreateDateTime($createDateTime)
            ->setCreatorID($creatorID)
            ->setLastModifyDateTime($lastModifyDateTime)
            ->setLastModifierID($lastModifierID)
            ->setPurgeDate($purgeDate)
            ->setResStatus($resStatus)
            ->setForcedSellIndicator($forcedSellIndicator)
            ->setServiceOverrideIndicator($serviceOverrideIndicator)
            ->setRateOverrideIndicator($rateOverrideIndicator)
            ->setWalkInIndicator($walkInIndicator)
            ->setRoomNumberLockedIndicator($roomNumberLockedIndicator);
    }
    /**
     * Get POS value
     * @return \dgsoft\ArrayType\DgArrayOfSourceType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \dgsoft\ArrayType\DgArrayOfSourceType $pOS
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setPOS(\dgsoft\ArrayType\DgArrayOfSourceType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \dgsoft\StructType\DgUniqueID_Type[]|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID_Type[] $uniqueID
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setUniqueID(array $uniqueID = array())
    {
        foreach ($uniqueID as $hotelReservationTypeUniqueIDItem) {
            // validation for constraint: itemType
            if (!$hotelReservationTypeUniqueIDItem instanceof \dgsoft\StructType\DgUniqueID_Type) {
                throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of \dgsoft\StructType\DgUniqueID_Type, "%s" given', is_object($hotelReservationTypeUniqueIDItem) ? get_class($hotelReservationTypeUniqueIDItem) : gettype($hotelReservationTypeUniqueIDItem)), __LINE__);
            }
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Add item to UniqueID value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID_Type $item
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function addToUniqueID(\dgsoft\StructType\DgUniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgUniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of \dgsoft\StructType\DgUniqueID_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UniqueID[] = $item;
        return $this;
    }
    /**
     * Get RoomStays value
     * @return \dgsoft\ArrayType\DgArrayOfOTA_HotelAvailRSRoomStaysRoomStay|null
     */
    public function getRoomStays()
    {
        return $this->RoomStays;
    }
    /**
     * Set RoomStays value
     * @param \dgsoft\ArrayType\DgArrayOfOTA_HotelAvailRSRoomStaysRoomStay $roomStays
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setRoomStays(\dgsoft\ArrayType\DgArrayOfOTA_HotelAvailRSRoomStaysRoomStay $roomStays = null)
    {
        $this->RoomStays = $roomStays;
        return $this;
    }
    /**
     * Get HotelStay value
     * @return \dgsoft\StructType\DgHotelStay|null
     */
    public function getHotelStay()
    {
        return $this->HotelStay;
    }
    /**
     * Set HotelStay value
     * @param \dgsoft\StructType\DgHotelStay $hotelStay
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setHotelStay(\dgsoft\StructType\DgHotelStay $hotelStay = null)
    {
        $this->HotelStay = $hotelStay;
        return $this;
    }
    /**
     * Get Areas value
     * @return \dgsoft\StructType\DgAreas|null
     */
    public function getAreas()
    {
        return $this->Areas;
    }
    /**
     * Set Areas value
     * @param \dgsoft\StructType\DgAreas $areas
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setAreas(\dgsoft\StructType\DgAreas $areas = null)
    {
        $this->Areas = $areas;
        return $this;
    }
    /**
     * Get Services value
     * @return \dgsoft\ArrayType\DgArrayOfServicesTypeService|null
     */
    public function getServices()
    {
        return $this->Services;
    }
    /**
     * Set Services value
     * @param \dgsoft\ArrayType\DgArrayOfServicesTypeService $services
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setServices(\dgsoft\ArrayType\DgArrayOfServicesTypeService $services = null)
    {
        $this->Services = $services;
        return $this;
    }
    /**
     * Get ResGuests value
     * @return \dgsoft\ArrayType\DgArrayOfResGuestsTypeResGuest|null
     */
    public function getResGuests()
    {
        return $this->ResGuests;
    }
    /**
     * Set ResGuests value
     * @param \dgsoft\ArrayType\DgArrayOfResGuestsTypeResGuest $resGuests
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setResGuests(\dgsoft\ArrayType\DgArrayOfResGuestsTypeResGuest $resGuests = null)
    {
        $this->ResGuests = $resGuests;
        return $this;
    }
    /**
     * Get ResGlobalInfo value
     * @return \dgsoft\StructType\DgResGlobalInfoType|null
     */
    public function getResGlobalInfo()
    {
        return $this->ResGlobalInfo;
    }
    /**
     * Set ResGlobalInfo value
     * @param \dgsoft\StructType\DgResGlobalInfoType $resGlobalInfo
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setResGlobalInfo(\dgsoft\StructType\DgResGlobalInfoType $resGlobalInfo = null)
    {
        $this->ResGlobalInfo = $resGlobalInfo;
        return $this;
    }
    /**
     * Get WrittenConfInst value
     * @return \dgsoft\StructType\DgWrittenConfInstType|null
     */
    public function getWrittenConfInst()
    {
        return $this->WrittenConfInst;
    }
    /**
     * Set WrittenConfInst value
     * @param \dgsoft\StructType\DgWrittenConfInstType $writtenConfInst
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setWrittenConfInst(\dgsoft\StructType\DgWrittenConfInstType $writtenConfInst = null)
    {
        $this->WrittenConfInst = $writtenConfInst;
        return $this;
    }
    /**
     * Get Queue value
     * @return \dgsoft\StructType\DgQueue|null
     */
    public function getQueue()
    {
        return $this->Queue;
    }
    /**
     * Set Queue value
     * @param \dgsoft\StructType\DgQueue $queue
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setQueue(\dgsoft\StructType\DgQueue $queue = null)
    {
        $this->Queue = $queue;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get RoomStayReservation value
     * @return bool|null
     */
    public function getRoomStayReservation()
    {
        return $this->RoomStayReservation;
    }
    /**
     * Set RoomStayReservation value
     * @param bool $roomStayReservation
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setRoomStayReservation($roomStayReservation = null)
    {
        // validation for constraint: boolean
        if (!is_null($roomStayReservation) && !is_bool($roomStayReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($roomStayReservation)), __LINE__);
        }
        $this->RoomStayReservation = $roomStayReservation;
        return $this;
    }
    /**
     * Get CreateDateTime value
     * @return string|null
     */
    public function getCreateDateTime()
    {
        return $this->CreateDateTime;
    }
    /**
     * Set CreateDateTime value
     * @param string $createDateTime
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setCreateDateTime($createDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($createDateTime) && !is_string($createDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDateTime)), __LINE__);
        }
        $this->CreateDateTime = $createDateTime;
        return $this;
    }
    /**
     * Get CreatorID value
     * @return string|null
     */
    public function getCreatorID()
    {
        return $this->CreatorID;
    }
    /**
     * Set CreatorID value
     * @param string $creatorID
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setCreatorID($creatorID = null)
    {
        // validation for constraint: string
        if (!is_null($creatorID) && !is_string($creatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creatorID)), __LINE__);
        }
        $this->CreatorID = $creatorID;
        return $this;
    }
    /**
     * Get LastModifyDateTime value
     * @return string|null
     */
    public function getLastModifyDateTime()
    {
        return $this->LastModifyDateTime;
    }
    /**
     * Set LastModifyDateTime value
     * @param string $lastModifyDateTime
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setLastModifyDateTime($lastModifyDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifyDateTime) && !is_string($lastModifyDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastModifyDateTime)), __LINE__);
        }
        $this->LastModifyDateTime = $lastModifyDateTime;
        return $this;
    }
    /**
     * Get LastModifierID value
     * @return string|null
     */
    public function getLastModifierID()
    {
        return $this->LastModifierID;
    }
    /**
     * Set LastModifierID value
     * @param string $lastModifierID
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setLastModifierID($lastModifierID = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifierID) && !is_string($lastModifierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastModifierID)), __LINE__);
        }
        $this->LastModifierID = $lastModifierID;
        return $this;
    }
    /**
     * Get PurgeDate value
     * @return string|null
     */
    public function getPurgeDate()
    {
        return $this->PurgeDate;
    }
    /**
     * Set PurgeDate value
     * @param string $purgeDate
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setPurgeDate($purgeDate = null)
    {
        // validation for constraint: string
        if (!is_null($purgeDate) && !is_string($purgeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($purgeDate)), __LINE__);
        }
        $this->PurgeDate = $purgeDate;
        return $this;
    }
    /**
     * Get ResStatus value
     * @return string|null
     */
    public function getResStatus()
    {
        return $this->ResStatus;
    }
    /**
     * Set ResStatus value
     * @param string $resStatus
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setResStatus($resStatus = null)
    {
        // validation for constraint: string
        if (!is_null($resStatus) && !is_string($resStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resStatus)), __LINE__);
        }
        $this->ResStatus = $resStatus;
        return $this;
    }
    /**
     * Get ForcedSellIndicator value
     * @return bool|null
     */
    public function getForcedSellIndicator()
    {
        return $this->ForcedSellIndicator;
    }
    /**
     * Set ForcedSellIndicator value
     * @param bool $forcedSellIndicator
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setForcedSellIndicator($forcedSellIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($forcedSellIndicator) && !is_bool($forcedSellIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($forcedSellIndicator)), __LINE__);
        }
        $this->ForcedSellIndicator = $forcedSellIndicator;
        return $this;
    }
    /**
     * Get ServiceOverrideIndicator value
     * @return bool|null
     */
    public function getServiceOverrideIndicator()
    {
        return $this->ServiceOverrideIndicator;
    }
    /**
     * Set ServiceOverrideIndicator value
     * @param bool $serviceOverrideIndicator
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setServiceOverrideIndicator($serviceOverrideIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($serviceOverrideIndicator) && !is_bool($serviceOverrideIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($serviceOverrideIndicator)), __LINE__);
        }
        $this->ServiceOverrideIndicator = $serviceOverrideIndicator;
        return $this;
    }
    /**
     * Get RateOverrideIndicator value
     * @return bool|null
     */
    public function getRateOverrideIndicator()
    {
        return $this->RateOverrideIndicator;
    }
    /**
     * Set RateOverrideIndicator value
     * @param bool $rateOverrideIndicator
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setRateOverrideIndicator($rateOverrideIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($rateOverrideIndicator) && !is_bool($rateOverrideIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($rateOverrideIndicator)), __LINE__);
        }
        $this->RateOverrideIndicator = $rateOverrideIndicator;
        return $this;
    }
    /**
     * Get WalkInIndicator value
     * @return bool|null
     */
    public function getWalkInIndicator()
    {
        return $this->WalkInIndicator;
    }
    /**
     * Set WalkInIndicator value
     * @param bool $walkInIndicator
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setWalkInIndicator($walkInIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($walkInIndicator) && !is_bool($walkInIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($walkInIndicator)), __LINE__);
        }
        $this->WalkInIndicator = $walkInIndicator;
        return $this;
    }
    /**
     * Get RoomNumberLockedIndicator value
     * @return bool|null
     */
    public function getRoomNumberLockedIndicator()
    {
        return $this->RoomNumberLockedIndicator;
    }
    /**
     * Set RoomNumberLockedIndicator value
     * @param bool $roomNumberLockedIndicator
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public function setRoomNumberLockedIndicator($roomNumberLockedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($roomNumberLockedIndicator) && !is_bool($roomNumberLockedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($roomNumberLockedIndicator)), __LINE__);
        }
        $this->RoomNumberLockedIndicator = $roomNumberLockedIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgHotelReservationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
