<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelPriceChangeInfo StructType
 * @package Dg
 * @subpackage Structs
 */
class DgHotelPriceChangeInfo extends AbstractStructBase
{
    /**
     * The OldPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OldPrice;
    /**
     * The NewPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NewPrice;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for HotelPriceChangeInfo
     * @uses DgHotelPriceChangeInfo::setOldPrice()
     * @uses DgHotelPriceChangeInfo::setNewPrice()
     * @uses DgHotelPriceChangeInfo::setCurrency()
     * @param string $oldPrice
     * @param string $newPrice
     * @param string $currency
     */
    public function __construct($oldPrice = null, $newPrice = null, $currency = null)
    {
        $this
            ->setOldPrice($oldPrice)
            ->setNewPrice($newPrice)
            ->setCurrency($currency);
    }
    /**
     * Get OldPrice value
     * @return string|null
     */
    public function getOldPrice()
    {
        return $this->OldPrice;
    }
    /**
     * Set OldPrice value
     * @param string $oldPrice
     * @return \dgsoft\StructType\DgHotelPriceChangeInfo
     */
    public function setOldPrice($oldPrice = null)
    {
        // validation for constraint: string
        if (!is_null($oldPrice) && !is_string($oldPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oldPrice)), __LINE__);
        }
        $this->OldPrice = $oldPrice;
        return $this;
    }
    /**
     * Get NewPrice value
     * @return string|null
     */
    public function getNewPrice()
    {
        return $this->NewPrice;
    }
    /**
     * Set NewPrice value
     * @param string $newPrice
     * @return \dgsoft\StructType\DgHotelPriceChangeInfo
     */
    public function setNewPrice($newPrice = null)
    {
        // validation for constraint: string
        if (!is_null($newPrice) && !is_string($newPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newPrice)), __LINE__);
        }
        $this->NewPrice = $newPrice;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \dgsoft\StructType\DgHotelPriceChangeInfo
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgHotelPriceChangeInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
