<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupDetailType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgGroupDetailType extends AbstractStructBase
{
    /**
     * The PaxCountofGroup
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PaxCountofGroup;
    /**
     * The GroupCode
     * @var string
     */
    public $GroupCode;
    /**
     * Constructor method for GroupDetailType
     * @uses DgGroupDetailType::setPaxCountofGroup()
     * @uses DgGroupDetailType::setGroupCode()
     * @param int $paxCountofGroup
     * @param string $groupCode
     */
    public function __construct($paxCountofGroup = null, $groupCode = null)
    {
        $this
            ->setPaxCountofGroup($paxCountofGroup)
            ->setGroupCode($groupCode);
    }
    /**
     * Get PaxCountofGroup value
     * @return int
     */
    public function getPaxCountofGroup()
    {
        return $this->PaxCountofGroup;
    }
    /**
     * Set PaxCountofGroup value
     * @param int $paxCountofGroup
     * @return \dgsoft\StructType\DgGroupDetailType
     */
    public function setPaxCountofGroup($paxCountofGroup = null)
    {
        // validation for constraint: int
        if (!is_null($paxCountofGroup) && !is_numeric($paxCountofGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paxCountofGroup)), __LINE__);
        }
        $this->PaxCountofGroup = $paxCountofGroup;
        return $this;
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \dgsoft\StructType\DgGroupDetailType
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgGroupDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
