<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPNRPrice StructType
 * @package Dg
 * @subpackage Structs
 */
class DgGetPNRPrice extends AbstractStructBase
{
    /**
     * The PNRNo
     * @var string
     */
    public $PNRNo;
    /**
     * The Surname
     * @var string
     */
    public $Surname;
    /**
     * Constructor method for GetPNRPrice
     * @uses DgGetPNRPrice::setPNRNo()
     * @uses DgGetPNRPrice::setSurname()
     * @param string $pNRNo
     * @param string $surname
     */
    public function __construct($pNRNo = null, $surname = null)
    {
        $this
            ->setPNRNo($pNRNo)
            ->setSurname($surname);
    }
    /**
     * Get PNRNo value
     * @return string|null
     */
    public function getPNRNo()
    {
        return $this->PNRNo;
    }
    /**
     * Set PNRNo value
     * @param string $pNRNo
     * @return \dgsoft\StructType\DgGetPNRPrice
     */
    public function setPNRNo($pNRNo = null)
    {
        // validation for constraint: string
        if (!is_null($pNRNo) && !is_string($pNRNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pNRNo)), __LINE__);
        }
        $this->PNRNo = $pNRNo;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \dgsoft\StructType\DgGetPNRPrice
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgGetPNRPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
