<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenericSoapHeader StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GenericSoapHeader
 * @package Dg
 * @subpackage Structs
 */
class DgGenericSoapHeader extends AbstractStructBase
{
    /**
     * The SubSiteCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubSiteCode;
    /**
     * Constructor method for GenericSoapHeader
     * @uses DgGenericSoapHeader::setSubSiteCode()
     * @param string $subSiteCode
     */
    public function __construct($subSiteCode = null)
    {
        $this
            ->setSubSiteCode($subSiteCode);
    }
    /**
     * Get SubSiteCode value
     * @return string|null
     */
    public function getSubSiteCode()
    {
        return $this->SubSiteCode;
    }
    /**
     * Set SubSiteCode value
     * @param string $subSiteCode
     * @return \dgsoft\StructType\DgGenericSoapHeader
     */
    public function setSubSiteCode($subSiteCode = null)
    {
        // validation for constraint: string
        if (!is_null($subSiteCode) && !is_string($subSiteCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subSiteCode)), __LINE__);
        }
        $this->SubSiteCode = $subSiteCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgGenericSoapHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
