<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenericFlightRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgGenericFlightRQ extends AbstractStructBase
{
    /**
     * The RecommendationID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $RecommendationID;
    /**
     * The CombinationID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $CombinationID;
    /**
     * The FareFamilyPackageID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $FareFamilyPackageID;
    /**
     * The IsOneWayCombinable
     * @var bool
     */
    public $IsOneWayCombinable;
    /**
     * Constructor method for GenericFlightRQ
     * @uses DgGenericFlightRQ::setRecommendationID()
     * @uses DgGenericFlightRQ::setCombinationID()
     * @uses DgGenericFlightRQ::setFareFamilyPackageID()
     * @uses DgGenericFlightRQ::setIsOneWayCombinable()
     * @param int $recommendationID
     * @param int $combinationID
     * @param int $fareFamilyPackageID
     * @param bool $isOneWayCombinable
     */
    public function __construct($recommendationID = null, $combinationID = null, $fareFamilyPackageID = null, $isOneWayCombinable = null)
    {
        $this
            ->setRecommendationID($recommendationID)
            ->setCombinationID($combinationID)
            ->setFareFamilyPackageID($fareFamilyPackageID)
            ->setIsOneWayCombinable($isOneWayCombinable);
    }
    /**
     * Get RecommendationID value
     * @return int
     */
    public function getRecommendationID()
    {
        return $this->RecommendationID;
    }
    /**
     * Set RecommendationID value
     * @param int $recommendationID
     * @return \dgsoft\StructType\DgGenericFlightRQ
     */
    public function setRecommendationID($recommendationID = null)
    {
        // validation for constraint: int
        if (!is_null($recommendationID) && !is_numeric($recommendationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recommendationID)), __LINE__);
        }
        $this->RecommendationID = $recommendationID;
        return $this;
    }
    /**
     * Get CombinationID value
     * @return int
     */
    public function getCombinationID()
    {
        return $this->CombinationID;
    }
    /**
     * Set CombinationID value
     * @param int $combinationID
     * @return \dgsoft\StructType\DgGenericFlightRQ
     */
    public function setCombinationID($combinationID = null)
    {
        // validation for constraint: int
        if (!is_null($combinationID) && !is_numeric($combinationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($combinationID)), __LINE__);
        }
        $this->CombinationID = $combinationID;
        return $this;
    }
    /**
     * Get FareFamilyPackageID value
     * @return int
     */
    public function getFareFamilyPackageID()
    {
        return $this->FareFamilyPackageID;
    }
    /**
     * Set FareFamilyPackageID value
     * @param int $fareFamilyPackageID
     * @return \dgsoft\StructType\DgGenericFlightRQ
     */
    public function setFareFamilyPackageID($fareFamilyPackageID = null)
    {
        // validation for constraint: int
        if (!is_null($fareFamilyPackageID) && !is_numeric($fareFamilyPackageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fareFamilyPackageID)), __LINE__);
        }
        $this->FareFamilyPackageID = $fareFamilyPackageID;
        return $this;
    }
    /**
     * Get IsOneWayCombinable value
     * @return bool|null
     */
    public function getIsOneWayCombinable()
    {
        return $this->IsOneWayCombinable;
    }
    /**
     * Set IsOneWayCombinable value
     * @param bool $isOneWayCombinable
     * @return \dgsoft\StructType\DgGenericFlightRQ
     */
    public function setIsOneWayCombinable($isOneWayCombinable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOneWayCombinable) && !is_bool($isOneWayCombinable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isOneWayCombinable)), __LINE__);
        }
        $this->IsOneWayCombinable = $isOneWayCombinable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgGenericFlightRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
