<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fulfillment StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFulfillment extends AbstractStructBase
{
    /**
     * The PaymentDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfPaymentDetailType
     */
    public $PaymentDetails;
    /**
     * The DeliveryAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAddressType
     */
    public $DeliveryAddress;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPersonNameType
     */
    public $Name;
    /**
     * The Receipt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgReceipt
     */
    public $Receipt;
    /**
     * The PaymentText
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPaymentText[]
     */
    public $PaymentText;
    /**
     * The LCCUserLogin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLCCUserLogin
     */
    public $LCCUserLogin;
    /**
     * Constructor method for Fulfillment
     * @uses DgFulfillment::setPaymentDetails()
     * @uses DgFulfillment::setDeliveryAddress()
     * @uses DgFulfillment::setName()
     * @uses DgFulfillment::setReceipt()
     * @uses DgFulfillment::setPaymentText()
     * @uses DgFulfillment::setLCCUserLogin()
     * @param \dgsoft\ArrayType\DgArrayOfPaymentDetailType $paymentDetails
     * @param \dgsoft\StructType\DgAddressType $deliveryAddress
     * @param \dgsoft\StructType\DgPersonNameType $name
     * @param \dgsoft\StructType\DgReceipt $receipt
     * @param \dgsoft\StructType\DgPaymentText[] $paymentText
     * @param \dgsoft\StructType\DgLCCUserLogin $lCCUserLogin
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfPaymentDetailType $paymentDetails = null, \dgsoft\StructType\DgAddressType $deliveryAddress = null, \dgsoft\StructType\DgPersonNameType $name = null, \dgsoft\StructType\DgReceipt $receipt = null, array $paymentText = array(), \dgsoft\StructType\DgLCCUserLogin $lCCUserLogin = null)
    {
        $this
            ->setPaymentDetails($paymentDetails)
            ->setDeliveryAddress($deliveryAddress)
            ->setName($name)
            ->setReceipt($receipt)
            ->setPaymentText($paymentText)
            ->setLCCUserLogin($lCCUserLogin);
    }
    /**
     * Get PaymentDetails value
     * @return \dgsoft\ArrayType\DgArrayOfPaymentDetailType|null
     */
    public function getPaymentDetails()
    {
        return $this->PaymentDetails;
    }
    /**
     * Set PaymentDetails value
     * @param \dgsoft\ArrayType\DgArrayOfPaymentDetailType $paymentDetails
     * @return \dgsoft\StructType\DgFulfillment
     */
    public function setPaymentDetails(\dgsoft\ArrayType\DgArrayOfPaymentDetailType $paymentDetails = null)
    {
        $this->PaymentDetails = $paymentDetails;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * @return \dgsoft\StructType\DgAddressType|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param \dgsoft\StructType\DgAddressType $deliveryAddress
     * @return \dgsoft\StructType\DgFulfillment
     */
    public function setDeliveryAddress(\dgsoft\StructType\DgAddressType $deliveryAddress = null)
    {
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Get Name value
     * @return \dgsoft\StructType\DgPersonNameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \dgsoft\StructType\DgPersonNameType $name
     * @return \dgsoft\StructType\DgFulfillment
     */
    public function setName(\dgsoft\StructType\DgPersonNameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Receipt value
     * @return \dgsoft\StructType\DgReceipt|null
     */
    public function getReceipt()
    {
        return $this->Receipt;
    }
    /**
     * Set Receipt value
     * @param \dgsoft\StructType\DgReceipt $receipt
     * @return \dgsoft\StructType\DgFulfillment
     */
    public function setReceipt(\dgsoft\StructType\DgReceipt $receipt = null)
    {
        $this->Receipt = $receipt;
        return $this;
    }
    /**
     * Get PaymentText value
     * @return \dgsoft\StructType\DgPaymentText[]|null
     */
    public function getPaymentText()
    {
        return $this->PaymentText;
    }
    /**
     * Set PaymentText value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentText[] $paymentText
     * @return \dgsoft\StructType\DgFulfillment
     */
    public function setPaymentText(array $paymentText = array())
    {
        foreach ($paymentText as $fulfillmentPaymentTextItem) {
            // validation for constraint: itemType
            if (!$fulfillmentPaymentTextItem instanceof \dgsoft\StructType\DgPaymentText) {
                throw new \InvalidArgumentException(sprintf('The PaymentText property can only contain items of \dgsoft\StructType\DgPaymentText, "%s" given', is_object($fulfillmentPaymentTextItem) ? get_class($fulfillmentPaymentTextItem) : gettype($fulfillmentPaymentTextItem)), __LINE__);
            }
        }
        $this->PaymentText = $paymentText;
        return $this;
    }
    /**
     * Add item to PaymentText value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentText $item
     * @return \dgsoft\StructType\DgFulfillment
     */
    public function addToPaymentText(\dgsoft\StructType\DgPaymentText $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPaymentText) {
            throw new \InvalidArgumentException(sprintf('The PaymentText property can only contain items of \dgsoft\StructType\DgPaymentText, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentText[] = $item;
        return $this;
    }
    /**
     * Get LCCUserLogin value
     * @return \dgsoft\StructType\DgLCCUserLogin|null
     */
    public function getLCCUserLogin()
    {
        return $this->LCCUserLogin;
    }
    /**
     * Set LCCUserLogin value
     * @param \dgsoft\StructType\DgLCCUserLogin $lCCUserLogin
     * @return \dgsoft\StructType\DgFulfillment
     */
    public function setLCCUserLogin(\dgsoft\StructType\DgLCCUserLogin $lCCUserLogin = null)
    {
        $this->LCCUserLogin = $lCCUserLogin;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFulfillment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
