<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FreeBaggageAllowanceTypes StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFreeBaggageAllowanceTypes extends AbstractStructBase
{
    /**
     * The ItineraryReference
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $ItineraryReference;
    /**
     * The SegmentReference
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $SegmentReference;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Quantity;
    /**
     * The PassengerType
     * @var string
     */
    public $PassengerType;
    /**
     * The Unit
     * @var string
     */
    public $Unit;
    /**
     * Constructor method for FreeBaggageAllowanceTypes
     * @uses DgFreeBaggageAllowanceTypes::setItineraryReference()
     * @uses DgFreeBaggageAllowanceTypes::setSegmentReference()
     * @uses DgFreeBaggageAllowanceTypes::setQuantity()
     * @uses DgFreeBaggageAllowanceTypes::setPassengerType()
     * @uses DgFreeBaggageAllowanceTypes::setUnit()
     * @param int $itineraryReference
     * @param int $segmentReference
     * @param int $quantity
     * @param string $passengerType
     * @param string $unit
     */
    public function __construct($itineraryReference = null, $segmentReference = null, $quantity = null, $passengerType = null, $unit = null)
    {
        $this
            ->setItineraryReference($itineraryReference)
            ->setSegmentReference($segmentReference)
            ->setQuantity($quantity)
            ->setPassengerType($passengerType)
            ->setUnit($unit);
    }
    /**
     * Get ItineraryReference value
     * @return int
     */
    public function getItineraryReference()
    {
        return $this->ItineraryReference;
    }
    /**
     * Set ItineraryReference value
     * @param int $itineraryReference
     * @return \dgsoft\StructType\DgFreeBaggageAllowanceTypes
     */
    public function setItineraryReference($itineraryReference = null)
    {
        // validation for constraint: int
        if (!is_null($itineraryReference) && !is_numeric($itineraryReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itineraryReference)), __LINE__);
        }
        $this->ItineraryReference = $itineraryReference;
        return $this;
    }
    /**
     * Get SegmentReference value
     * @return int
     */
    public function getSegmentReference()
    {
        return $this->SegmentReference;
    }
    /**
     * Set SegmentReference value
     * @param int $segmentReference
     * @return \dgsoft\StructType\DgFreeBaggageAllowanceTypes
     */
    public function setSegmentReference($segmentReference = null)
    {
        // validation for constraint: int
        if (!is_null($segmentReference) && !is_numeric($segmentReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($segmentReference)), __LINE__);
        }
        $this->SegmentReference = $segmentReference;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \dgsoft\StructType\DgFreeBaggageAllowanceTypes
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return string|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @param string $passengerType
     * @return \dgsoft\StructType\DgFreeBaggageAllowanceTypes
     */
    public function setPassengerType($passengerType = null)
    {
        // validation for constraint: string
        if (!is_null($passengerType) && !is_string($passengerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passengerType)), __LINE__);
        }
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Get Unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->Unit;
    }
    /**
     * Set Unit value
     * @param string $unit
     * @return \dgsoft\StructType\DgFreeBaggageAllowanceTypes
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: string
        if (!is_null($unit) && !is_string($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unit)), __LINE__);
        }
        $this->Unit = $unit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFreeBaggageAllowanceTypes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
