<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightTermsAndCondition StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFlightTermsAndCondition extends AbstractStructBase
{
    /**
     * The RuleInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfRuleInfos
     */
    public $RuleInfo;
    /**
     * The Destination
     * @var string
     */
    public $Destination;
    /**
     * The Origin
     * @var string
     */
    public $Origin;
    /**
     * The AirlineCode
     * @var string
     */
    public $AirlineCode;
    /**
     * The AirlineName
     * @var string
     */
    public $AirlineName;
    /**
     * The FareBasisCode
     * @var string
     */
    public $FareBasisCode;
    /**
     * Constructor method for FlightTermsAndCondition
     * @uses DgFlightTermsAndCondition::setRuleInfo()
     * @uses DgFlightTermsAndCondition::setDestination()
     * @uses DgFlightTermsAndCondition::setOrigin()
     * @uses DgFlightTermsAndCondition::setAirlineCode()
     * @uses DgFlightTermsAndCondition::setAirlineName()
     * @uses DgFlightTermsAndCondition::setFareBasisCode()
     * @param \dgsoft\ArrayType\DgArrayOfRuleInfos $ruleInfo
     * @param string $destination
     * @param string $origin
     * @param string $airlineCode
     * @param string $airlineName
     * @param string $fareBasisCode
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfRuleInfos $ruleInfo = null, $destination = null, $origin = null, $airlineCode = null, $airlineName = null, $fareBasisCode = null)
    {
        $this
            ->setRuleInfo($ruleInfo)
            ->setDestination($destination)
            ->setOrigin($origin)
            ->setAirlineCode($airlineCode)
            ->setAirlineName($airlineName)
            ->setFareBasisCode($fareBasisCode);
    }
    /**
     * Get RuleInfo value
     * @return \dgsoft\ArrayType\DgArrayOfRuleInfos|null
     */
    public function getRuleInfo()
    {
        return $this->RuleInfo;
    }
    /**
     * Set RuleInfo value
     * @param \dgsoft\ArrayType\DgArrayOfRuleInfos $ruleInfo
     * @return \dgsoft\StructType\DgFlightTermsAndCondition
     */
    public function setRuleInfo(\dgsoft\ArrayType\DgArrayOfRuleInfos $ruleInfo = null)
    {
        $this->RuleInfo = $ruleInfo;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \dgsoft\StructType\DgFlightTermsAndCondition
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get Origin value
     * @return string|null
     */
    public function getOrigin()
    {
        return $this->Origin;
    }
    /**
     * Set Origin value
     * @param string $origin
     * @return \dgsoft\StructType\DgFlightTermsAndCondition
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: string
        if (!is_null($origin) && !is_string($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($origin)), __LINE__);
        }
        $this->Origin = $origin;
        return $this;
    }
    /**
     * Get AirlineCode value
     * @return string|null
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param string $airlineCode
     * @return \dgsoft\StructType\DgFlightTermsAndCondition
     */
    public function setAirlineCode($airlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($airlineCode) && !is_string($airlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airlineCode)), __LINE__);
        }
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Get AirlineName value
     * @return string|null
     */
    public function getAirlineName()
    {
        return $this->AirlineName;
    }
    /**
     * Set AirlineName value
     * @param string $airlineName
     * @return \dgsoft\StructType\DgFlightTermsAndCondition
     */
    public function setAirlineName($airlineName = null)
    {
        // validation for constraint: string
        if (!is_null($airlineName) && !is_string($airlineName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airlineName)), __LINE__);
        }
        $this->AirlineName = $airlineName;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \dgsoft\StructType\DgFlightTermsAndCondition
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFlightTermsAndCondition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
