<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightSegmentType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFlightSegmentType extends DgFlightSegmentBaseType
{
    /**
     * The MarketingAirline
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgMarketingAirline
     */
    public $MarketingAirline;
    /**
     * The Baggages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfFreeBaggageSegmentItem
     */
    public $Baggages;
    /**
     * The FlightNumber
     * @var string
     */
    public $FlightNumber;
    /**
     * The TourOperatorFlightID
     * @var string
     */
    public $TourOperatorFlightID;
    /**
     * Constructor method for FlightSegmentType
     * @uses DgFlightSegmentType::setMarketingAirline()
     * @uses DgFlightSegmentType::setBaggages()
     * @uses DgFlightSegmentType::setFlightNumber()
     * @uses DgFlightSegmentType::setTourOperatorFlightID()
     * @param \dgsoft\StructType\DgMarketingAirline $marketingAirline
     * @param \dgsoft\ArrayType\DgArrayOfFreeBaggageSegmentItem $baggages
     * @param string $flightNumber
     * @param string $tourOperatorFlightID
     */
    public function __construct(\dgsoft\StructType\DgMarketingAirline $marketingAirline = null, \dgsoft\ArrayType\DgArrayOfFreeBaggageSegmentItem $baggages = null, $flightNumber = null, $tourOperatorFlightID = null)
    {
        $this
            ->setMarketingAirline($marketingAirline)
            ->setBaggages($baggages)
            ->setFlightNumber($flightNumber)
            ->setTourOperatorFlightID($tourOperatorFlightID);
    }
    /**
     * Get MarketingAirline value
     * @return \dgsoft\StructType\DgMarketingAirline|null
     */
    public function getMarketingAirline()
    {
        return $this->MarketingAirline;
    }
    /**
     * Set MarketingAirline value
     * @param \dgsoft\StructType\DgMarketingAirline $marketingAirline
     * @return \dgsoft\StructType\DgFlightSegmentType
     */
    public function setMarketingAirline(\dgsoft\StructType\DgMarketingAirline $marketingAirline = null)
    {
        $this->MarketingAirline = $marketingAirline;
        return $this;
    }
    /**
     * Get Baggages value
     * @return \dgsoft\ArrayType\DgArrayOfFreeBaggageSegmentItem|null
     */
    public function getBaggages()
    {
        return $this->Baggages;
    }
    /**
     * Set Baggages value
     * @param \dgsoft\ArrayType\DgArrayOfFreeBaggageSegmentItem $baggages
     * @return \dgsoft\StructType\DgFlightSegmentType
     */
    public function setBaggages(\dgsoft\ArrayType\DgArrayOfFreeBaggageSegmentItem $baggages = null)
    {
        $this->Baggages = $baggages;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \dgsoft\StructType\DgFlightSegmentType
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get TourOperatorFlightID value
     * @return string|null
     */
    public function getTourOperatorFlightID()
    {
        return $this->TourOperatorFlightID;
    }
    /**
     * Set TourOperatorFlightID value
     * @param string $tourOperatorFlightID
     * @return \dgsoft\StructType\DgFlightSegmentType
     */
    public function setTourOperatorFlightID($tourOperatorFlightID = null)
    {
        // validation for constraint: string
        if (!is_null($tourOperatorFlightID) && !is_string($tourOperatorFlightID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tourOperatorFlightID)), __LINE__);
        }
        $this->TourOperatorFlightID = $tourOperatorFlightID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFlightSegmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
