<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightSegmentBaseType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFlightSegmentBaseType extends AbstractStructBase
{
    /**
     * The FlightDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FlightDuration;
    /**
     * The DepartureAirport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDepartureAirport
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgArrivalAirport
     */
    public $ArrivalAirport;
    /**
     * The OperatingAirline
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOperatingAirlineType
     */
    public $OperatingAirline;
    /**
     * The Equipment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgEquipmentType[]
     */
    public $Equipment;
    /**
     * The DepartureDateTime
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The ArrivalDateTime
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The StopQuantity
     * @var int
     */
    public $StopQuantity;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The InfoSource
     * @var string
     */
    public $InfoSource;
    /**
     * Constructor method for FlightSegmentBaseType
     * @uses DgFlightSegmentBaseType::setFlightDuration()
     * @uses DgFlightSegmentBaseType::setDepartureAirport()
     * @uses DgFlightSegmentBaseType::setArrivalAirport()
     * @uses DgFlightSegmentBaseType::setOperatingAirline()
     * @uses DgFlightSegmentBaseType::setEquipment()
     * @uses DgFlightSegmentBaseType::setDepartureDateTime()
     * @uses DgFlightSegmentBaseType::setArrivalDateTime()
     * @uses DgFlightSegmentBaseType::setStopQuantity()
     * @uses DgFlightSegmentBaseType::setRPH()
     * @uses DgFlightSegmentBaseType::setInfoSource()
     * @param string $flightDuration
     * @param \dgsoft\StructType\DgDepartureAirport $departureAirport
     * @param \dgsoft\StructType\DgArrivalAirport $arrivalAirport
     * @param \dgsoft\StructType\DgOperatingAirlineType $operatingAirline
     * @param \dgsoft\StructType\DgEquipmentType[] $equipment
     * @param string $departureDateTime
     * @param string $arrivalDateTime
     * @param int $stopQuantity
     * @param string $rPH
     * @param string $infoSource
     */
    public function __construct($flightDuration = null, \dgsoft\StructType\DgDepartureAirport $departureAirport = null, \dgsoft\StructType\DgArrivalAirport $arrivalAirport = null, \dgsoft\StructType\DgOperatingAirlineType $operatingAirline = null, array $equipment = array(), $departureDateTime = null, $arrivalDateTime = null, $stopQuantity = null, $rPH = null, $infoSource = null)
    {
        $this
            ->setFlightDuration($flightDuration)
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setOperatingAirline($operatingAirline)
            ->setEquipment($equipment)
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalDateTime($arrivalDateTime)
            ->setStopQuantity($stopQuantity)
            ->setRPH($rPH)
            ->setInfoSource($infoSource);
    }
    /**
     * Get FlightDuration value
     * @return string
     */
    public function getFlightDuration()
    {
        return $this->FlightDuration;
    }
    /**
     * Set FlightDuration value
     * @param string $flightDuration
     * @return \dgsoft\StructType\DgFlightSegmentBaseType
     */
    public function setFlightDuration($flightDuration = null)
    {
        // validation for constraint: string
        if (!is_null($flightDuration) && !is_string($flightDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightDuration)), __LINE__);
        }
        $this->FlightDuration = $flightDuration;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return \dgsoft\StructType\DgDepartureAirport|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \dgsoft\StructType\DgDepartureAirport $departureAirport
     * @return \dgsoft\StructType\DgFlightSegmentBaseType
     */
    public function setDepartureAirport(\dgsoft\StructType\DgDepartureAirport $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return \dgsoft\StructType\DgArrivalAirport|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param \dgsoft\StructType\DgArrivalAirport $arrivalAirport
     * @return \dgsoft\StructType\DgFlightSegmentBaseType
     */
    public function setArrivalAirport(\dgsoft\StructType\DgArrivalAirport $arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get OperatingAirline value
     * @return \dgsoft\StructType\DgOperatingAirlineType|null
     */
    public function getOperatingAirline()
    {
        return $this->OperatingAirline;
    }
    /**
     * Set OperatingAirline value
     * @param \dgsoft\StructType\DgOperatingAirlineType $operatingAirline
     * @return \dgsoft\StructType\DgFlightSegmentBaseType
     */
    public function setOperatingAirline(\dgsoft\StructType\DgOperatingAirlineType $operatingAirline = null)
    {
        $this->OperatingAirline = $operatingAirline;
        return $this;
    }
    /**
     * Get Equipment value
     * @return \dgsoft\StructType\DgEquipmentType[]|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * Set Equipment value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEquipmentType[] $equipment
     * @return \dgsoft\StructType\DgFlightSegmentBaseType
     */
    public function setEquipment(array $equipment = array())
    {
        foreach ($equipment as $flightSegmentBaseTypeEquipmentItem) {
            // validation for constraint: itemType
            if (!$flightSegmentBaseTypeEquipmentItem instanceof \dgsoft\StructType\DgEquipmentType) {
                throw new \InvalidArgumentException(sprintf('The Equipment property can only contain items of \dgsoft\StructType\DgEquipmentType, "%s" given', is_object($flightSegmentBaseTypeEquipmentItem) ? get_class($flightSegmentBaseTypeEquipmentItem) : gettype($flightSegmentBaseTypeEquipmentItem)), __LINE__);
            }
        }
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Add item to Equipment value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEquipmentType $item
     * @return \dgsoft\StructType\DgFlightSegmentBaseType
     */
    public function addToEquipment(\dgsoft\StructType\DgEquipmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgEquipmentType) {
            throw new \InvalidArgumentException(sprintf('The Equipment property can only contain items of \dgsoft\StructType\DgEquipmentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Equipment[] = $item;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \dgsoft\StructType\DgFlightSegmentBaseType
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureDateTime) && !is_string($departureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDateTime)), __LINE__);
        }
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \dgsoft\StructType\DgFlightSegmentBaseType
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalDateTime)), __LINE__);
        }
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get StopQuantity value
     * @return int|null
     */
    public function getStopQuantity()
    {
        return $this->StopQuantity;
    }
    /**
     * Set StopQuantity value
     * @param int $stopQuantity
     * @return \dgsoft\StructType\DgFlightSegmentBaseType
     */
    public function setStopQuantity($stopQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($stopQuantity) && !is_numeric($stopQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($stopQuantity)), __LINE__);
        }
        $this->StopQuantity = $stopQuantity;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \dgsoft\StructType\DgFlightSegmentBaseType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \dgsoft\StructType\DgFlightSegmentBaseType
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFlightSegmentBaseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
