<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightLegType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFlightLegType extends AbstractStructBase
{
    /**
     * The DepartureAirport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDepartureAirport
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgArrivalAirport
     */
    public $ArrivalAirport;
    /**
     * The FlightNumber
     * @var string
     */
    public $FlightNumber;
    /**
     * The ResBookDesigCode
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * Constructor method for FlightLegType
     * @uses DgFlightLegType::setDepartureAirport()
     * @uses DgFlightLegType::setArrivalAirport()
     * @uses DgFlightLegType::setFlightNumber()
     * @uses DgFlightLegType::setResBookDesigCode()
     * @uses DgFlightLegType::setDate()
     * @param \dgsoft\StructType\DgDepartureAirport $departureAirport
     * @param \dgsoft\StructType\DgArrivalAirport $arrivalAirport
     * @param string $flightNumber
     * @param string $resBookDesigCode
     * @param string $date
     */
    public function __construct(\dgsoft\StructType\DgDepartureAirport $departureAirport = null, \dgsoft\StructType\DgArrivalAirport $arrivalAirport = null, $flightNumber = null, $resBookDesigCode = null, $date = null)
    {
        $this
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setFlightNumber($flightNumber)
            ->setResBookDesigCode($resBookDesigCode)
            ->setDate($date);
    }
    /**
     * Get DepartureAirport value
     * @return \dgsoft\StructType\DgDepartureAirport|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \dgsoft\StructType\DgDepartureAirport $departureAirport
     * @return \dgsoft\StructType\DgFlightLegType
     */
    public function setDepartureAirport(\dgsoft\StructType\DgDepartureAirport $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return \dgsoft\StructType\DgArrivalAirport|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param \dgsoft\StructType\DgArrivalAirport $arrivalAirport
     * @return \dgsoft\StructType\DgFlightLegType
     */
    public function setArrivalAirport(\dgsoft\StructType\DgArrivalAirport $arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \dgsoft\StructType\DgFlightLegType
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \dgsoft\StructType\DgFlightLegType
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCode) && !is_string($resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resBookDesigCode)), __LINE__);
        }
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \dgsoft\StructType\DgFlightLegType
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFlightLegType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
