<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeeType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFeeType extends AbstractStructBase
{
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTaxesType
     */
    public $Taxes;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgParagraphType[]
     */
    public $Description;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The TaxInclusive
     * @var bool
     */
    public $TaxInclusive;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Percent
     * @var float
     */
    public $Percent;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The MandatoryIndicator
     * @var bool
     */
    public $MandatoryIndicator;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The ChargeUnit
     * @var string
     */
    public $ChargeUnit;
    /**
     * The ChargeFrequency
     * @var string
     */
    public $ChargeFrequency;
    /**
     * The ChargeUnitExempt
     * @var int
     */
    public $ChargeUnitExempt;
    /**
     * The ChargeFrequencyExempt
     * @var int
     */
    public $ChargeFrequencyExempt;
    /**
     * The MaxChargeUnitApplies
     * @var int
     */
    public $MaxChargeUnitApplies;
    /**
     * The MaxChargeFrequencyApplies
     * @var int
     */
    public $MaxChargeFrequencyApplies;
    /**
     * The TaxableIndicator
     * @var bool
     */
    public $TaxableIndicator;
    /**
     * Constructor method for FeeType
     * @uses DgFeeType::setTaxes()
     * @uses DgFeeType::setDescription()
     * @uses DgFeeType::setCurrencyCode()
     * @uses DgFeeType::setAmount()
     * @uses DgFeeType::setTaxInclusive()
     * @uses DgFeeType::setType()
     * @uses DgFeeType::setCode()
     * @uses DgFeeType::setPercent()
     * @uses DgFeeType::setEffectiveDate()
     * @uses DgFeeType::setExpireDate()
     * @uses DgFeeType::setMandatoryIndicator()
     * @uses DgFeeType::setRPH()
     * @uses DgFeeType::setChargeUnit()
     * @uses DgFeeType::setChargeFrequency()
     * @uses DgFeeType::setChargeUnitExempt()
     * @uses DgFeeType::setChargeFrequencyExempt()
     * @uses DgFeeType::setMaxChargeUnitApplies()
     * @uses DgFeeType::setMaxChargeFrequencyApplies()
     * @uses DgFeeType::setTaxableIndicator()
     * @param \dgsoft\StructType\DgTaxesType $taxes
     * @param \dgsoft\StructType\DgParagraphType[] $description
     * @param string $currencyCode
     * @param float $amount
     * @param bool $taxInclusive
     * @param string $type
     * @param string $code
     * @param float $percent
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $mandatoryIndicator
     * @param string $rPH
     * @param string $chargeUnit
     * @param string $chargeFrequency
     * @param int $chargeUnitExempt
     * @param int $chargeFrequencyExempt
     * @param int $maxChargeUnitApplies
     * @param int $maxChargeFrequencyApplies
     * @param bool $taxableIndicator
     */
    public function __construct(\dgsoft\StructType\DgTaxesType $taxes = null, array $description = array(), $currencyCode = null, $amount = null, $taxInclusive = null, $type = null, $code = null, $percent = null, $effectiveDate = null, $expireDate = null, $mandatoryIndicator = null, $rPH = null, $chargeUnit = null, $chargeFrequency = null, $chargeUnitExempt = null, $chargeFrequencyExempt = null, $maxChargeUnitApplies = null, $maxChargeFrequencyApplies = null, $taxableIndicator = null)
    {
        $this
            ->setTaxes($taxes)
            ->setDescription($description)
            ->setCurrencyCode($currencyCode)
            ->setAmount($amount)
            ->setTaxInclusive($taxInclusive)
            ->setType($type)
            ->setCode($code)
            ->setPercent($percent)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setMandatoryIndicator($mandatoryIndicator)
            ->setRPH($rPH)
            ->setChargeUnit($chargeUnit)
            ->setChargeFrequency($chargeFrequency)
            ->setChargeUnitExempt($chargeUnitExempt)
            ->setChargeFrequencyExempt($chargeFrequencyExempt)
            ->setMaxChargeUnitApplies($maxChargeUnitApplies)
            ->setMaxChargeFrequencyApplies($maxChargeFrequencyApplies)
            ->setTaxableIndicator($taxableIndicator);
    }
    /**
     * Get Taxes value
     * @return \dgsoft\StructType\DgTaxesType|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \dgsoft\StructType\DgTaxesType $taxes
     * @return \dgsoft\StructType\DgFeeType
     */
    public function setTaxes(\dgsoft\StructType\DgTaxesType $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get Description value
     * @return \dgsoft\StructType\DgParagraphType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgParagraphType[] $description
     * @return \dgsoft\StructType\DgFeeType
     */
    public function setDescription(array $description = array())
    {
        foreach ($description as $feeTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$feeTypeDescriptionItem instanceof \dgsoft\StructType\DgParagraphType) {
                throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \dgsoft\StructType\DgParagraphType, "%s" given', is_object($feeTypeDescriptionItem) ? get_class($feeTypeDescriptionItem) : gettype($feeTypeDescriptionItem)), __LINE__);
            }
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgParagraphType $item
     * @return \dgsoft\StructType\DgFeeType
     */
    public function addToDescription(\dgsoft\StructType\DgParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgParagraphType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \dgsoft\StructType\DgParagraphType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \dgsoft\StructType\DgFeeType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgFeeType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TaxInclusive value
     * @return bool|null
     */
    public function getTaxInclusive()
    {
        return $this->TaxInclusive;
    }
    /**
     * Set TaxInclusive value
     * @param bool $taxInclusive
     * @return \dgsoft\StructType\DgFeeType
     */
    public function setTaxInclusive($taxInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusive) && !is_bool($taxInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($taxInclusive)), __LINE__);
        }
        $this->TaxInclusive = $taxInclusive;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \dgsoft\EnumType\DgAmountDeterminationType::valueIsValid()
     * @uses \dgsoft\EnumType\DgAmountDeterminationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \dgsoft\StructType\DgFeeType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgAmountDeterminationType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \dgsoft\EnumType\DgAmountDeterminationType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \dgsoft\StructType\DgFeeType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \dgsoft\StructType\DgFeeType
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \dgsoft\StructType\DgFeeType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \dgsoft\StructType\DgFeeType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get MandatoryIndicator value
     * @return bool|null
     */
    public function getMandatoryIndicator()
    {
        return $this->MandatoryIndicator;
    }
    /**
     * Set MandatoryIndicator value
     * @param bool $mandatoryIndicator
     * @return \dgsoft\StructType\DgFeeType
     */
    public function setMandatoryIndicator($mandatoryIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatoryIndicator) && !is_bool($mandatoryIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mandatoryIndicator)), __LINE__);
        }
        $this->MandatoryIndicator = $mandatoryIndicator;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \dgsoft\StructType\DgFeeType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get ChargeUnit value
     * @return string|null
     */
    public function getChargeUnit()
    {
        return $this->ChargeUnit;
    }
    /**
     * Set ChargeUnit value
     * @param string $chargeUnit
     * @return \dgsoft\StructType\DgFeeType
     */
    public function setChargeUnit($chargeUnit = null)
    {
        // validation for constraint: string
        if (!is_null($chargeUnit) && !is_string($chargeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeUnit)), __LINE__);
        }
        $this->ChargeUnit = $chargeUnit;
        return $this;
    }
    /**
     * Get ChargeFrequency value
     * @return string|null
     */
    public function getChargeFrequency()
    {
        return $this->ChargeFrequency;
    }
    /**
     * Set ChargeFrequency value
     * @param string $chargeFrequency
     * @return \dgsoft\StructType\DgFeeType
     */
    public function setChargeFrequency($chargeFrequency = null)
    {
        // validation for constraint: string
        if (!is_null($chargeFrequency) && !is_string($chargeFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeFrequency)), __LINE__);
        }
        $this->ChargeFrequency = $chargeFrequency;
        return $this;
    }
    /**
     * Get ChargeUnitExempt value
     * @return int|null
     */
    public function getChargeUnitExempt()
    {
        return $this->ChargeUnitExempt;
    }
    /**
     * Set ChargeUnitExempt value
     * @param int $chargeUnitExempt
     * @return \dgsoft\StructType\DgFeeType
     */
    public function setChargeUnitExempt($chargeUnitExempt = null)
    {
        // validation for constraint: int
        if (!is_null($chargeUnitExempt) && !is_numeric($chargeUnitExempt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeUnitExempt)), __LINE__);
        }
        $this->ChargeUnitExempt = $chargeUnitExempt;
        return $this;
    }
    /**
     * Get ChargeFrequencyExempt value
     * @return int|null
     */
    public function getChargeFrequencyExempt()
    {
        return $this->ChargeFrequencyExempt;
    }
    /**
     * Set ChargeFrequencyExempt value
     * @param int $chargeFrequencyExempt
     * @return \dgsoft\StructType\DgFeeType
     */
    public function setChargeFrequencyExempt($chargeFrequencyExempt = null)
    {
        // validation for constraint: int
        if (!is_null($chargeFrequencyExempt) && !is_numeric($chargeFrequencyExempt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeFrequencyExempt)), __LINE__);
        }
        $this->ChargeFrequencyExempt = $chargeFrequencyExempt;
        return $this;
    }
    /**
     * Get MaxChargeUnitApplies value
     * @return int|null
     */
    public function getMaxChargeUnitApplies()
    {
        return $this->MaxChargeUnitApplies;
    }
    /**
     * Set MaxChargeUnitApplies value
     * @param int $maxChargeUnitApplies
     * @return \dgsoft\StructType\DgFeeType
     */
    public function setMaxChargeUnitApplies($maxChargeUnitApplies = null)
    {
        // validation for constraint: int
        if (!is_null($maxChargeUnitApplies) && !is_numeric($maxChargeUnitApplies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxChargeUnitApplies)), __LINE__);
        }
        $this->MaxChargeUnitApplies = $maxChargeUnitApplies;
        return $this;
    }
    /**
     * Get MaxChargeFrequencyApplies value
     * @return int|null
     */
    public function getMaxChargeFrequencyApplies()
    {
        return $this->MaxChargeFrequencyApplies;
    }
    /**
     * Set MaxChargeFrequencyApplies value
     * @param int $maxChargeFrequencyApplies
     * @return \dgsoft\StructType\DgFeeType
     */
    public function setMaxChargeFrequencyApplies($maxChargeFrequencyApplies = null)
    {
        // validation for constraint: int
        if (!is_null($maxChargeFrequencyApplies) && !is_numeric($maxChargeFrequencyApplies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxChargeFrequencyApplies)), __LINE__);
        }
        $this->MaxChargeFrequencyApplies = $maxChargeFrequencyApplies;
        return $this;
    }
    /**
     * Get TaxableIndicator value
     * @return bool|null
     */
    public function getTaxableIndicator()
    {
        return $this->TaxableIndicator;
    }
    /**
     * Set TaxableIndicator value
     * @param bool $taxableIndicator
     * @return \dgsoft\StructType\DgFeeType
     */
    public function setTaxableIndicator($taxableIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxableIndicator) && !is_bool($taxableIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($taxableIndicator)), __LINE__);
        }
        $this->TaxableIndicator = $taxableIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFeeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
